<?php

namespace Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Append Services
 * @subpackage Services
 */
class Append extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named appendParcelsToPackageCV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\AppendParcelsToPackageCV1 $parameters
     * @return \Structs\AppendParcelsToPackageCV1Response|bool
     */
    public function appendParcelsToPackageCV1(\Structs\AppendParcelsToPackageCV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->appendParcelsToPackageCV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named appendParcelsToPackageCV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\AppendParcelsToPackageCV2 $parameters
     * @return \Structs\AppendParcelsToPackageCV2Response|bool
     */
    public function appendParcelsToPackageCV2(\Structs\AppendParcelsToPackageCV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->appendParcelsToPackageCV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named appendParcelsToPackageXV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\AppendParcelsToPackageXV1 $parameters
     * @return \Structs\AppendParcelsToPackageXV1Response|bool
     */
    public function appendParcelsToPackageXV1(\Structs\AppendParcelsToPackageXV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->appendParcelsToPackageXV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named appendParcelsToPackageXV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\AppendParcelsToPackageXV2 $parameters
     * @return \Structs\AppendParcelsToPackageXV2Response|bool
     */
    public function appendParcelsToPackageXV2(\Structs\AppendParcelsToPackageXV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->appendParcelsToPackageXV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Structs\AppendParcelsToPackageCV1Response|\Structs\AppendParcelsToPackageCV2Response|\Structs\AppendParcelsToPackageXV1Response|\Structs\AppendParcelsToPackageXV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
