<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generatePackagesNumbersXV9 Structs
 * Meta information extracted from the WSDL
 * - type: tns:generatePackagesNumbersXV9
 * @subpackage Structs
 */
class GeneratePackagesNumbersXV9 extends AbstractStructBase
{
    /**
     * The openUMLFeV11
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openUMLFeV11;
    /**
     * The pkgNumsGenerationPolicyV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pkgNumsGenerationPolicyV1;
    /**
     * The langCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $langCode;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Structs\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generatePackagesNumbersXV9
     * @uses GeneratePackagesNumbersXV9::setOpenUMLFeV11()
     * @uses GeneratePackagesNumbersXV9::setPkgNumsGenerationPolicyV1()
     * @uses GeneratePackagesNumbersXV9::setLangCode()
     * @uses GeneratePackagesNumbersXV9::setAuthDataV1()
     * @param string $openUMLFeV11
     * @param string $pkgNumsGenerationPolicyV1
     * @param string $langCode
     * @param \Structs\AuthDataV1 $authDataV1
     */
    public function __construct($openUMLFeV11 = null, $pkgNumsGenerationPolicyV1 = null, $langCode = null, \Structs\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setOpenUMLFeV11($openUMLFeV11)
            ->setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1)
            ->setLangCode($langCode)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get openUMLFeV11 value
     * @return string|null
     */
    public function getOpenUMLFeV11()
    {
        return $this->openUMLFeV11;
    }
    /**
     * Set openUMLFeV11 value
     * @param string $openUMLFeV11
     * @return \Structs\GeneratePackagesNumbersXV9
     */
    public function setOpenUMLFeV11($openUMLFeV11 = null)
    {
        // validation for constraint: string
        if (!is_null($openUMLFeV11) && !is_string($openUMLFeV11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openUMLFeV11, true), gettype($openUMLFeV11)), __LINE__);
        }
        $this->openUMLFeV11 = $openUMLFeV11;
        return $this;
    }
    /**
     * Get pkgNumsGenerationPolicyV1 value
     * @return string|null
     */
    public function getPkgNumsGenerationPolicyV1()
    {
        return $this->pkgNumsGenerationPolicyV1;
    }
    /**
     * Set pkgNumsGenerationPolicyV1 value
     * @uses \Enums\PkgNumsGenerationPolicyV1::valueIsValid()
     * @uses \Enums\PkgNumsGenerationPolicyV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pkgNumsGenerationPolicyV1
     * @return \Structs\GeneratePackagesNumbersXV9
     */
    public function setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1 = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\PkgNumsGenerationPolicyV1::valueIsValid($pkgNumsGenerationPolicyV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\PkgNumsGenerationPolicyV1', is_array($pkgNumsGenerationPolicyV1) ? implode(', ', $pkgNumsGenerationPolicyV1) : var_export($pkgNumsGenerationPolicyV1, true), implode(', ', \Enums\PkgNumsGenerationPolicyV1::getValidValues())), __LINE__);
        }
        $this->pkgNumsGenerationPolicyV1 = $pkgNumsGenerationPolicyV1;
        return $this;
    }
    /**
     * Get langCode value
     * @return string|null
     */
    public function getLangCode()
    {
        return $this->langCode;
    }
    /**
     * Set langCode value
     * @param string $langCode
     * @return \Structs\GeneratePackagesNumbersXV9
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langCode, true), gettype($langCode)), __LINE__);
        }
        $this->langCode = $langCode;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \Structs\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \Structs\AuthDataV1 $authDataV1
     * @return \Structs\GeneratePackagesNumbersXV9
     */
    public function setAuthDataV1(\Structs\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
