<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generatePackagesNumbersXV1 Structs
 * Meta information extracted from the WSDL
 * - type: tns:generatePackagesNumbersXV1
 * @subpackage Structs
 */
class GeneratePackagesNumbersXV1 extends AbstractStructBase
{
    /**
     * The openUMLXV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openUMLXV1;
    /**
     * The pkgNumsGenerationPolicyV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pkgNumsGenerationPolicyV1;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Structs\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generatePackagesNumbersXV1
     * @uses GeneratePackagesNumbersXV1::setOpenUMLXV1()
     * @uses GeneratePackagesNumbersXV1::setPkgNumsGenerationPolicyV1()
     * @uses GeneratePackagesNumbersXV1::setAuthDataV1()
     * @param string $openUMLXV1
     * @param string $pkgNumsGenerationPolicyV1
     * @param \Structs\AuthDataV1 $authDataV1
     */
    public function __construct($openUMLXV1 = null, $pkgNumsGenerationPolicyV1 = null, \Structs\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setOpenUMLXV1($openUMLXV1)
            ->setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get openUMLXV1 value
     * @return string|null
     */
    public function getOpenUMLXV1()
    {
        return $this->openUMLXV1;
    }
    /**
     * Set openUMLXV1 value
     * @param string $openUMLXV1
     * @return \Structs\GeneratePackagesNumbersXV1
     */
    public function setOpenUMLXV1($openUMLXV1 = null)
    {
        // validation for constraint: string
        if (!is_null($openUMLXV1) && !is_string($openUMLXV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openUMLXV1, true), gettype($openUMLXV1)), __LINE__);
        }
        $this->openUMLXV1 = $openUMLXV1;
        return $this;
    }
    /**
     * Get pkgNumsGenerationPolicyV1 value
     * @return string|null
     */
    public function getPkgNumsGenerationPolicyV1()
    {
        return $this->pkgNumsGenerationPolicyV1;
    }
    /**
     * Set pkgNumsGenerationPolicyV1 value
     * @uses \Enums\PkgNumsGenerationPolicyV1::valueIsValid()
     * @uses \Enums\PkgNumsGenerationPolicyV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pkgNumsGenerationPolicyV1
     * @return \Structs\GeneratePackagesNumbersXV1
     */
    public function setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1 = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\PkgNumsGenerationPolicyV1::valueIsValid($pkgNumsGenerationPolicyV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\PkgNumsGenerationPolicyV1', is_array($pkgNumsGenerationPolicyV1) ? implode(', ', $pkgNumsGenerationPolicyV1) : var_export($pkgNumsGenerationPolicyV1, true), implode(', ', \Enums\PkgNumsGenerationPolicyV1::getValidValues())), __LINE__);
        }
        $this->pkgNumsGenerationPolicyV1 = $pkgNumsGenerationPolicyV1;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \Structs\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \Structs\AuthDataV1 $authDataV1
     * @return \Structs\GeneratePackagesNumbersXV1
     */
    public function setAuthDataV1(\Structs\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
