<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generatePackagesNumbersCV4 Structs
 * Meta information extracted from the WSDL
 * - type: tns:generatePackagesNumbersCV4
 * @subpackage Structs
 */
class GeneratePackagesNumbersCV4 extends AbstractStructBase
{
    /**
     * The openUMLFeV3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openUMLFeV3;
    /**
     * The pkgNumsGenerationPolicyV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pkgNumsGenerationPolicyV1;
    /**
     * The langCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $langCode;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Structs\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generatePackagesNumbersCV4
     * @uses GeneratePackagesNumbersCV4::setOpenUMLFeV3()
     * @uses GeneratePackagesNumbersCV4::setPkgNumsGenerationPolicyV1()
     * @uses GeneratePackagesNumbersCV4::setLangCode()
     * @uses GeneratePackagesNumbersCV4::setAuthDataV1()
     * @param string $openUMLFeV3
     * @param string $pkgNumsGenerationPolicyV1
     * @param string $langCode
     * @param \Structs\AuthDataV1 $authDataV1
     */
    public function __construct($openUMLFeV3 = null, $pkgNumsGenerationPolicyV1 = null, $langCode = null, \Structs\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setOpenUMLFeV3($openUMLFeV3)
            ->setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1)
            ->setLangCode($langCode)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get openUMLFeV3 value
     * @return string|null
     */
    public function getOpenUMLFeV3()
    {
        return $this->openUMLFeV3;
    }
    /**
     * Set openUMLFeV3 value
     * @param string $openUMLFeV3
     * @return \Structs\GeneratePackagesNumbersCV4
     */
    public function setOpenUMLFeV3($openUMLFeV3 = null)
    {
        // validation for constraint: string
        if (!is_null($openUMLFeV3) && !is_string($openUMLFeV3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openUMLFeV3, true), gettype($openUMLFeV3)), __LINE__);
        }
        $this->openUMLFeV3 = $openUMLFeV3;
        return $this;
    }
    /**
     * Get pkgNumsGenerationPolicyV1 value
     * @return string|null
     */
    public function getPkgNumsGenerationPolicyV1()
    {
        return $this->pkgNumsGenerationPolicyV1;
    }
    /**
     * Set pkgNumsGenerationPolicyV1 value
     * @uses \Enums\PkgNumsGenerationPolicyV1::valueIsValid()
     * @uses \Enums\PkgNumsGenerationPolicyV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pkgNumsGenerationPolicyV1
     * @return \Structs\GeneratePackagesNumbersCV4
     */
    public function setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1 = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\PkgNumsGenerationPolicyV1::valueIsValid($pkgNumsGenerationPolicyV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\PkgNumsGenerationPolicyV1', is_array($pkgNumsGenerationPolicyV1) ? implode(', ', $pkgNumsGenerationPolicyV1) : var_export($pkgNumsGenerationPolicyV1, true), implode(', ', \Enums\PkgNumsGenerationPolicyV1::getValidValues())), __LINE__);
        }
        $this->pkgNumsGenerationPolicyV1 = $pkgNumsGenerationPolicyV1;
        return $this;
    }
    /**
     * Get langCode value
     * @return string|null
     */
    public function getLangCode()
    {
        return $this->langCode;
    }
    /**
     * Set langCode value
     * @param string $langCode
     * @return \Structs\GeneratePackagesNumbersCV4
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langCode, true), gettype($langCode)), __LINE__);
        }
        $this->langCode = $langCode;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \Structs\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \Structs\AuthDataV1 $authDataV1
     * @return \Structs\GeneratePackagesNumbersCV4
     */
    public function setAuthDataV1(\Structs\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
