<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generateDomesticReturnLabelCV1 Structs
 * Meta information extracted from the WSDL
 * - type: tns:generateDomesticReturnLabelCV1
 * @subpackage Structs
 */
class GenerateDomesticReturnLabelCV1 extends AbstractStructBase
{
    /**
     * The returnedWaybillsCV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $returnedWaybillsCV1;
    /**
     * The receiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $receiver;
    /**
     * The outputDocFormatV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputDocFormatV1;
    /**
     * The outputDocPageFormatV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputDocPageFormatV1;
    /**
     * The outputLabelType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputLabelType;
    /**
     * The labelVariant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelVariant;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Structs\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generateDomesticReturnLabelCV1
     * @uses GenerateDomesticReturnLabelCV1::setReturnedWaybillsCV1()
     * @uses GenerateDomesticReturnLabelCV1::setReceiver()
     * @uses GenerateDomesticReturnLabelCV1::setOutputDocFormatV1()
     * @uses GenerateDomesticReturnLabelCV1::setOutputDocPageFormatV1()
     * @uses GenerateDomesticReturnLabelCV1::setOutputLabelType()
     * @uses GenerateDomesticReturnLabelCV1::setLabelVariant()
     * @uses GenerateDomesticReturnLabelCV1::setAuthDataV1()
     * @param string $returnedWaybillsCV1
     * @param string $receiver
     * @param string $outputDocFormatV1
     * @param string $outputDocPageFormatV1
     * @param string $outputLabelType
     * @param string $labelVariant
     * @param \Structs\AuthDataV1 $authDataV1
     */
    public function __construct($returnedWaybillsCV1 = null, $receiver = null, $outputDocFormatV1 = null, $outputDocPageFormatV1 = null, $outputLabelType = null, $labelVariant = null, \Structs\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setReturnedWaybillsCV1($returnedWaybillsCV1)
            ->setReceiver($receiver)
            ->setOutputDocFormatV1($outputDocFormatV1)
            ->setOutputDocPageFormatV1($outputDocPageFormatV1)
            ->setOutputLabelType($outputLabelType)
            ->setLabelVariant($labelVariant)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get returnedWaybillsCV1 value
     * @return string|null
     */
    public function getReturnedWaybillsCV1()
    {
        return $this->returnedWaybillsCV1;
    }
    /**
     * Set returnedWaybillsCV1 value
     * @param string $returnedWaybillsCV1
     * @return \Structs\GenerateDomesticReturnLabelCV1
     */
    public function setReturnedWaybillsCV1($returnedWaybillsCV1 = null)
    {
        // validation for constraint: string
        if (!is_null($returnedWaybillsCV1) && !is_string($returnedWaybillsCV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnedWaybillsCV1, true), gettype($returnedWaybillsCV1)), __LINE__);
        }
        $this->returnedWaybillsCV1 = $returnedWaybillsCV1;
        return $this;
    }
    /**
     * Get receiver value
     * @return string|null
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param string $receiver
     * @return \Structs\GenerateDomesticReturnLabelCV1
     */
    public function setReceiver($receiver = null)
    {
        // validation for constraint: string
        if (!is_null($receiver) && !is_string($receiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiver, true), gettype($receiver)), __LINE__);
        }
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Get outputDocFormatV1 value
     * @return string|null
     */
    public function getOutputDocFormatV1()
    {
        return $this->outputDocFormatV1;
    }
    /**
     * Set outputDocFormatV1 value
     * @uses \Enums\OutputDocFormatDSPEnumV1::valueIsValid()
     * @uses \Enums\OutputDocFormatDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputDocFormatV1
     * @return \Structs\GenerateDomesticReturnLabelCV1
     */
    public function setOutputDocFormatV1($outputDocFormatV1 = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\OutputDocFormatDSPEnumV1::valueIsValid($outputDocFormatV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\OutputDocFormatDSPEnumV1', is_array($outputDocFormatV1) ? implode(', ', $outputDocFormatV1) : var_export($outputDocFormatV1, true), implode(', ', \Enums\OutputDocFormatDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->outputDocFormatV1 = $outputDocFormatV1;
        return $this;
    }
    /**
     * Get outputDocPageFormatV1 value
     * @return string|null
     */
    public function getOutputDocPageFormatV1()
    {
        return $this->outputDocPageFormatV1;
    }
    /**
     * Set outputDocPageFormatV1 value
     * @uses \Enums\OutputDocPageFormatDSPEnumV1::valueIsValid()
     * @uses \Enums\OutputDocPageFormatDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputDocPageFormatV1
     * @return \Structs\GenerateDomesticReturnLabelCV1
     */
    public function setOutputDocPageFormatV1($outputDocPageFormatV1 = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\OutputDocPageFormatDSPEnumV1::valueIsValid($outputDocPageFormatV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\OutputDocPageFormatDSPEnumV1', is_array($outputDocPageFormatV1) ? implode(', ', $outputDocPageFormatV1) : var_export($outputDocPageFormatV1, true), implode(', ', \Enums\OutputDocPageFormatDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->outputDocPageFormatV1 = $outputDocPageFormatV1;
        return $this;
    }
    /**
     * Get outputLabelType value
     * @return string|null
     */
    public function getOutputLabelType()
    {
        return $this->outputLabelType;
    }
    /**
     * Set outputLabelType value
     * @uses \Enums\OutputLabelTypeEnumV2::valueIsValid()
     * @uses \Enums\OutputLabelTypeEnumV2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputLabelType
     * @return \Structs\GenerateDomesticReturnLabelCV1
     */
    public function setOutputLabelType($outputLabelType = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\OutputLabelTypeEnumV2::valueIsValid($outputLabelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\OutputLabelTypeEnumV2', is_array($outputLabelType) ? implode(', ', $outputLabelType) : var_export($outputLabelType, true), implode(', ', \Enums\OutputLabelTypeEnumV2::getValidValues())), __LINE__);
        }
        $this->outputLabelType = $outputLabelType;
        return $this;
    }
    /**
     * Get labelVariant value
     * @return string|null
     */
    public function getLabelVariant()
    {
        return $this->labelVariant;
    }
    /**
     * Set labelVariant value
     * @param string $labelVariant
     * @return \Structs\GenerateDomesticReturnLabelCV1
     */
    public function setLabelVariant($labelVariant = null)
    {
        // validation for constraint: string
        if (!is_null($labelVariant) && !is_string($labelVariant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelVariant, true), gettype($labelVariant)), __LINE__);
        }
        $this->labelVariant = $labelVariant;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \Structs\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \Structs\AuthDataV1 $authDataV1
     * @return \Structs\GenerateDomesticReturnLabelCV1
     */
    public function setAuthDataV1(\Structs\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
