<?php

namespace Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for importPackagesCV1 Structs
 * Meta information extracted from the WSDL
 * - type: tns:importPackagesCV1
 * @subpackage Structs
 */
class ImportPackagesCV1 extends AbstractStructBase
{
    /**
     * The openUMLFCV2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $openUMLFCV2;
    /**
     * The pkgNumsGenerationPolicyV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pkgNumsGenerationPolicyV1;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Structs\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for importPackagesCV1
     * @uses ImportPackagesCV1::setOpenUMLFCV2()
     * @uses ImportPackagesCV1::setPkgNumsGenerationPolicyV1()
     * @uses ImportPackagesCV1::setAuthDataV1()
     * @param string $openUMLFCV2
     * @param string $pkgNumsGenerationPolicyV1
     * @param \Structs\AuthDataV1 $authDataV1
     */
    public function __construct($openUMLFCV2 = null, $pkgNumsGenerationPolicyV1 = null, \Structs\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setOpenUMLFCV2($openUMLFCV2)
            ->setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get openUMLFCV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpenUMLFCV2()
    {
        return isset($this->openUMLFCV2) ? $this->openUMLFCV2 : null;
    }
    /**
     * Set openUMLFCV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $openUMLFCV2
     * @return \Structs\ImportPackagesCV1
     */
    public function setOpenUMLFCV2($openUMLFCV2 = null)
    {
        // validation for constraint: string
        if (!is_null($openUMLFCV2) && !is_string($openUMLFCV2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openUMLFCV2, true), gettype($openUMLFCV2)), __LINE__);
        }
        if (is_null($openUMLFCV2) || (is_array($openUMLFCV2) && empty($openUMLFCV2))) {
            unset($this->openUMLFCV2);
        } else {
            $this->openUMLFCV2 = $openUMLFCV2;
        }
        return $this;
    }
    /**
     * Get pkgNumsGenerationPolicyV1 value
     * @return string|null
     */
    public function getPkgNumsGenerationPolicyV1()
    {
        return $this->pkgNumsGenerationPolicyV1;
    }
    /**
     * Set pkgNumsGenerationPolicyV1 value
     * @uses \Enums\PkgImportPolicyV1::valueIsValid()
     * @uses \Enums\PkgImportPolicyV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pkgNumsGenerationPolicyV1
     * @return \Structs\ImportPackagesCV1
     */
    public function setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1 = null)
    {
        // validation for constraint: enumeration
        if (!\Enums\PkgImportPolicyV1::valueIsValid($pkgNumsGenerationPolicyV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enums\PkgImportPolicyV1', is_array($pkgNumsGenerationPolicyV1) ? implode(', ', $pkgNumsGenerationPolicyV1) : var_export($pkgNumsGenerationPolicyV1, true), implode(', ', \Enums\PkgImportPolicyV1::getValidValues())), __LINE__);
        }
        $this->pkgNumsGenerationPolicyV1 = $pkgNumsGenerationPolicyV1;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \Structs\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \Structs\AuthDataV1 $authDataV1
     * @return \Structs\ImportPackagesCV1
     */
    public function setAuthDataV1(\Structs\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
