<?php

namespace Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import Services
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importPackagesCV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ImportPackagesCV1 $parameters
     * @return \Structs\ImportPackagesCV1Response|bool
     */
    public function importPackagesCV1(\Structs\ImportPackagesCV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importPackagesCV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importPackagesXV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Structs\ImportPackagesXV1 $parameters
     * @return \Structs\ImportPackagesXV1Response|bool
     */
    public function importPackagesXV1(\Structs\ImportPackagesXV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importPackagesXV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Structs\ImportPackagesCV1Response|\Structs\ImportPackagesXV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
