<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintType StructType
 * @subpackage Structs
 */
class PrintType extends AbstractStructBase
{
    /**
     * The kind
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kind;
    /**
     * The method
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $method;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The resolution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $resolution;
    /**
     * Constructor method for PrintType
     * @uses PrintType::setKind()
     * @uses PrintType::setMethod()
     * @uses PrintType::setFormat()
     * @uses PrintType::setResolution()
     * @param string $kind
     * @param string $method
     * @param string $format
     * @param string $resolution
     */
    public function __construct($kind = null, $method = null, $format = null, $resolution = null)
    {
        $this
            ->setKind($kind)
            ->setMethod($method)
            ->setFormat($format)
            ->setResolution($resolution);
    }
    /**
     * Get kind value
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * Set kind value
     * @param string $kind
     * @return PrintType
     */
    public function setKind($kind = null)
    {
        $this->kind = $kind;
        return $this;
    }
    /**
     * Get method value
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param string $method
     * @return PrintType
     */
    public function setMethod($method = null)
    {
        $this->method = $method;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return PrintType
     */
    public function setFormat($format = null)
    {
        $this->format = $format;
        return $this;
    }
    /**
     * Get resolution value
     * @return string|null
     */
    public function getResolution()
    {
        return $this->resolution;
    }
    /**
     * Set resolution value
     * @param string $resolution
     * @return PrintType
     */
    public function setResolution($resolution = null)
    {
        $this->resolution = $resolution;
        return $this;
    }
}
