<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paczkaPocztowaType StructType
 * @subpackage Structs
 */
class PaczkaPocztowaType extends PrzesylkaRejestrowanaType
{
    /**
     * The kategoria
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $kategoria;
    /**
     * The gabaryt
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $gabaryt;
    /**
     * The epo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EPOType
     */
    public $epo;
    /**
     * The idLibraryForLegalDeposit
     * Meta information extracted from the WSDL
     * - documentation: Identifier library for legal deposit from list downloaded using the getLibrariesForLegalDeposits method
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 4
     * - minOccurs: 0
     * @var string
     */
    public $idLibraryForLegalDeposit;
    /**
     * The zasadySpecjalne
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $zasadySpecjalne;
    /**
     * The posteRestante
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $posteRestante;
    /**
     * The iloscPotwierdzenOdbioru
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - default: 0
     * - maxInclusive: 9
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $iloscPotwierdzenOdbioru;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $wartosc;
    /**
     * The zwrotDoslanie
     * @var bool
     */
    public $zwrotDoslanie;
    /**
     * The egzemplarzBiblioteczny
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $egzemplarzBiblioteczny;
    /**
     * The dlaOciemnialych
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $dlaOciemnialych;
    /**
     * Constructor method for paczkaPocztowaType
     * @uses PaczkaPocztowaType::setKategoria()
     * @uses PaczkaPocztowaType::setGabaryt()
     * @uses PaczkaPocztowaType::setEpo()
     * @uses PaczkaPocztowaType::setIdLibraryForLegalDeposit()
     * @uses PaczkaPocztowaType::setZasadySpecjalne()
     * @uses PaczkaPocztowaType::setPosteRestante()
     * @uses PaczkaPocztowaType::setIloscPotwierdzenOdbioru()
     * @uses PaczkaPocztowaType::setMasa()
     * @uses PaczkaPocztowaType::setWartosc()
     * @uses PaczkaPocztowaType::setZwrotDoslanie()
     * @uses PaczkaPocztowaType::setEgzemplarzBiblioteczny()
     * @uses PaczkaPocztowaType::setDlaOciemnialych()
     * @param string $kategoria
     * @param string $gabaryt
     * @param EPOType $epo
     * @param string $idLibraryForLegalDeposit
     * @param string $zasadySpecjalne
     * @param bool $posteRestante
     * @param int $iloscPotwierdzenOdbioru
     * @param int $masa
     * @param int $wartosc
     * @param bool $zwrotDoslanie
     * @param bool $egzemplarzBiblioteczny
     * @param bool $dlaOciemnialych
     */
    public function __construct($kategoria = null, $gabaryt = null, EPOType $epo = null, $idLibraryForLegalDeposit = null, $zasadySpecjalne = null, $posteRestante = false, $iloscPotwierdzenOdbioru = 0, $masa = null, $wartosc = null, $zwrotDoslanie = null, $egzemplarzBiblioteczny = false, $dlaOciemnialych = false)
    {
        $this
            ->setKategoria($kategoria)
            ->setGabaryt($gabaryt)
            ->setEpo($epo)
            ->setIdLibraryForLegalDeposit($idLibraryForLegalDeposit)
            ->setZasadySpecjalne($zasadySpecjalne)
            ->setPosteRestante($posteRestante)
            ->setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru)
            ->setMasa($masa)
            ->setWartosc($wartosc)
            ->setZwrotDoslanie($zwrotDoslanie)
            ->setEgzemplarzBiblioteczny($egzemplarzBiblioteczny)
            ->setDlaOciemnialych($dlaOciemnialych);
    }
    /**
     * Get kategoria value
     * @return string
     */
    public function getKategoria()
    {
        return $this->kategoria;
    }
    /**
     * Set kategoria value
     * @param string $kategoria
     * @return PaczkaPocztowaType
     */
    public function setKategoria($kategoria = null)
    {
        $this->kategoria = $kategoria;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return PaczkaPocztowaType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get epo value
     * @return EPOType|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param EPOType $epo
     * @return PaczkaPocztowaType
     */
    public function setEpo(EPOType $epo = null)
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Get idLibraryForLegalDeposit value
     * @return string|null
     */
    public function getIdLibraryForLegalDeposit()
    {
        return $this->idLibraryForLegalDeposit;
    }
    /**
     * Set idLibraryForLegalDeposit value
     * @param string $idLibraryForLegalDeposit
     * @return PaczkaPocztowaType
     */
    public function setIdLibraryForLegalDeposit($idLibraryForLegalDeposit = null)
    {
        $this->idLibraryForLegalDeposit = $idLibraryForLegalDeposit;
        return $this;
    }
    /**
     * Get zasadySpecjalne value
     * @return string|null
     */
    public function getZasadySpecjalne()
    {
        return $this->zasadySpecjalne;
    }
    /**
     * Set zasadySpecjalne value
     * @param string $zasadySpecjalne
     * @return PaczkaPocztowaType
     */
    public function setZasadySpecjalne($zasadySpecjalne = null)
    {
        $this->zasadySpecjalne = $zasadySpecjalne;
        return $this;
    }
    /**
     * Get posteRestante value
     * @return bool|null
     */
    public function getPosteRestante()
    {
        return $this->posteRestante;
    }
    /**
     * Set posteRestante value
     * @param bool $posteRestante
     * @return PaczkaPocztowaType
     */
    public function setPosteRestante($posteRestante = false)
    {
        $this->posteRestante = $posteRestante;
        return $this;
    }
    /**
     * Get iloscPotwierdzenOdbioru value
     * @return int|null
     */
    public function getIloscPotwierdzenOdbioru()
    {
        return $this->iloscPotwierdzenOdbioru;
    }
    /**
     * Set iloscPotwierdzenOdbioru value
     * @param int $iloscPotwierdzenOdbioru
     * @return PaczkaPocztowaType
     */
    public function setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru = 0)
    {
        $this->iloscPotwierdzenOdbioru = $iloscPotwierdzenOdbioru;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PaczkaPocztowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PaczkaPocztowaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get zwrotDoslanie value
     * @return bool|null
     */
    public function getZwrotDoslanie()
    {
        return $this->zwrotDoslanie;
    }
    /**
     * Set zwrotDoslanie value
     * @param bool $zwrotDoslanie
     * @return PaczkaPocztowaType
     */
    public function setZwrotDoslanie($zwrotDoslanie = null)
    {
        $this->zwrotDoslanie = $zwrotDoslanie;
        return $this;
    }
    /**
     * Get egzemplarzBiblioteczny value
     * @return bool|null
     */
    public function getEgzemplarzBiblioteczny()
    {
        return $this->egzemplarzBiblioteczny;
    }
    /**
     * Set egzemplarzBiblioteczny value
     * @param bool $egzemplarzBiblioteczny
     * @return PaczkaPocztowaType
     */
    public function setEgzemplarzBiblioteczny($egzemplarzBiblioteczny = false)
    {
        $this->egzemplarzBiblioteczny = $egzemplarzBiblioteczny;
        return $this;
    }
    /**
     * Get dlaOciemnialych value
     * @return bool|null
     */
    public function getDlaOciemnialych()
    {
        return $this->dlaOciemnialych;
    }
    /**
     * Set dlaOciemnialych value
     * @param bool $dlaOciemnialych
     * @return PaczkaPocztowaType
     */
    public function setDlaOciemnialych($dlaOciemnialych = false)
    {
        $this->dlaOciemnialych = $dlaOciemnialych;
        return $this;
    }
}
