<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountType StructType
 * @subpackage Structs
 */
class AccountType extends AbstractStructBase
{
    /**
     * The profil
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var ProfilType[]
     */
    public $profil;
    /**
     * The karta
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var KartaType[]
     */
    public $karta;
    /**
     * The permision
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $permision;
    /**
     * The jednostka
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var JednostkaOrganizacyjnaType[]
     */
    public $jednostka;
    /**
     * The domyslnaJednostka
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var JednostkaOrganizacyjnaType
     */
    public $domyslnaJednostka;
    /**
     * The domyslnyProfil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ProfilType
     */
    public $domyslnyProfil;
    /**
     * The dostepPoAdresieIP
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $dostepPoAdresieIP;
    /**
     * The userName
     * @var string
     */
    public $userName;
    /**
     * The firstName
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * @var string
     */
    public $lastName;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for accountType
     * @uses AccountType::setProfil()
     * @uses AccountType::setKarta()
     * @uses AccountType::setPermision()
     * @uses AccountType::setJednostka()
     * @uses AccountType::setDomyslnaJednostka()
     * @uses AccountType::setDomyslnyProfil()
     * @uses AccountType::setDostepPoAdresieIP()
     * @uses AccountType::setUserName()
     * @uses AccountType::setFirstName()
     * @uses AccountType::setLastName()
     * @uses AccountType::setEmail()
     * @uses AccountType::setStatus()
     * @param ProfilType[] $profil
     * @param KartaType[] $karta
     * @param string[] $permision
     * @param JednostkaOrganizacyjnaType[] $jednostka
     * @param JednostkaOrganizacyjnaType $domyslnaJednostka
     * @param ProfilType $domyslnyProfil
     * @param string[] $dostepPoAdresieIP
     * @param string $userName
     * @param string $firstName
     * @param string $lastName
     * @param string $email
     * @param string $status
     */
    public function __construct(array $profil = array(), array $karta = array(), array $permision = array(), array $jednostka = array(), JednostkaOrganizacyjnaType $domyslnaJednostka = null, ProfilType $domyslnyProfil = null, array $dostepPoAdresieIP = array(), $userName = null, $firstName = null, $lastName = null, $email = null, $status = null)
    {
        $this
            ->setProfil($profil)
            ->setKarta($karta)
            ->setPermision($permision)
            ->setJednostka($jednostka)
            ->setDomyslnaJednostka($domyslnaJednostka)
            ->setDomyslnyProfil($domyslnyProfil)
            ->setDostepPoAdresieIP($dostepPoAdresieIP)
            ->setUserName($userName)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmail($email)
            ->setStatus($status);
    }
    /**
     * Get profil value
     * @return ProfilType[]
     */
    public function getProfil()
    {
        return $this->profil;
    }
    /**
     * Set profil value
     * @param ProfilType[] $profil
     * @return AccountType
     */
    public function setProfil(array $profil = array())
    {
        $this->profil = $profil;
        return $this;
    }
    /**
     * Add item to profil value
     * @throws \InvalidArgumentException
     * @param ProfilType $item
     * @return AccountType
     */
    public function addToProfil(ProfilType $item)
    {
        $this->profil[] = $item;
        return $this;
    }
    /**
     * Get karta value
     * @return KartaType[]|null
     */
    public function getKarta()
    {
        return $this->karta;
    }
    /**
     * Set karta value
     * @param KartaType[] $karta
     * @return AccountType
     */
    public function setKarta(array $karta = array())
    {
        $this->karta = $karta;
        return $this;
    }
    /**
     * Add item to karta value
     * @throws \InvalidArgumentException
     * @param KartaType $item
     * @return AccountType
     */
    public function addToKarta(KartaType $item)
    {
        $this->karta[] = $item;
        return $this;
    }
    /**
     * Get permision value
     * @return string[]|null
     */
    public function getPermision()
    {
        return $this->permision;
    }
    /**
     * Set permision value
     * @param string[] $permision
     * @return AccountType
     */
    public function setPermision(array $permision = array())
    {
        $this->permision = $permision;
        return $this;
    }
    /**
     * Add item to permision value
     * @uses PermisionType::valueIsValid()
     * @uses PermisionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return AccountType
     */
    public function addToPermision($item)
    {
        $this->permision[] = $item;
        return $this;
    }
    /**
     * Get jednostka value
     * @return JednostkaOrganizacyjnaType[]|null
     */
    public function getJednostka()
    {
        return $this->jednostka;
    }
    /**
     * Set jednostka value
     * @param JednostkaOrganizacyjnaType[] $jednostka
     * @return AccountType
     */
    public function setJednostka(array $jednostka = array())
    {
        $this->jednostka = $jednostka;
        return $this;
    }
    /**
     * Add item to jednostka value
     * @throws \InvalidArgumentException
     * @param JednostkaOrganizacyjnaType $item
     * @return AccountType
     */
    public function addToJednostka(JednostkaOrganizacyjnaType $item)
    {
        $this->jednostka[] = $item;
        return $this;
    }
    /**
     * Get domyslnaJednostka value
     * @return JednostkaOrganizacyjnaType|null
     */
    public function getDomyslnaJednostka()
    {
        return $this->domyslnaJednostka;
    }
    /**
     * Set domyslnaJednostka value
     * @param JednostkaOrganizacyjnaType $domyslnaJednostka
     * @return AccountType
     */
    public function setDomyslnaJednostka(JednostkaOrganizacyjnaType $domyslnaJednostka = null)
    {
        $this->domyslnaJednostka = $domyslnaJednostka;
        return $this;
    }
    /**
     * Get domyslnyProfil value
     * @return ProfilType|null
     */
    public function getDomyslnyProfil()
    {
        return $this->domyslnyProfil;
    }
    /**
     * Set domyslnyProfil value
     * @param ProfilType $domyslnyProfil
     * @return AccountType
     */
    public function setDomyslnyProfil(ProfilType $domyslnyProfil = null)
    {
        $this->domyslnyProfil = $domyslnyProfil;
        return $this;
    }
    /**
     * Get dostepPoAdresieIP value
     * @return string[]|null
     */
    public function getDostepPoAdresieIP()
    {
        return $this->dostepPoAdresieIP;
    }
    /**
     * Set dostepPoAdresieIP value
     * @param string[] $dostepPoAdresieIP
     * @return AccountType
     */
    public function setDostepPoAdresieIP(array $dostepPoAdresieIP = array())
    {
        $this->dostepPoAdresieIP = $dostepPoAdresieIP;
        return $this;
    }
    /**
     * Add item to dostepPoAdresieIP value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return AccountType
     */
    public function addToDostepPoAdresieIP($item)
    {
        $this->dostepPoAdresieIP[] = $item;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return AccountType
     */
    public function setUserName($userName = null)
    {
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return AccountType
     */
    public function setFirstName($firstName = null)
    {
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return AccountType
     */
    public function setLastName($lastName = null)
    {
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return AccountType
     */
    public function setEmail($email = null)
    {
        $this->email = $email;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return AccountType
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
}
