<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for uslugaPaczkowaType StructType
 * @subpackage Structs
 */
class UslugaPaczkowaType extends PrzesylkaRejestrowanaType
{
    /**
     * The subPrzesylka
     * Meta information extracted from the WSDL
     * - choice: urzadWydaniaEPrzesylki | subPrzesylka
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var SubUslugaPaczkowaType[]
     */
    public $subPrzesylka;
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The potwierdzenieDoreczenia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PotwierdzenieDoreczeniaType
     */
    public $potwierdzenieDoreczenia;
    /**
     * The urzadWydaniaEPrzesylki
     * Meta information extracted from the WSDL
     * - choice: urzadWydaniaEPrzesylki | subPrzesylka
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UrzadWydaniaEPrzesylkiType
     */
    public $urzadWydaniaEPrzesylki;
    /**
     * The potwierdzenieOdbioru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PotwierdzenieOdbioruPaczkowaType
     */
    public $potwierdzenieOdbioru;
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The zwrotDokumentow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zwrotDokumentow;
    /**
     * The doreczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DoreczenieUslugaPocztowaType
     */
    public $doreczenie;
    /**
     * The epo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EPOType
     */
    public $epo;
    /**
     * The zasadySpecjalne
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $zasadySpecjalne;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ponadgabaryt
     * @var bool
     */
    public $ponadgabaryt;
    /**
     * The zawartosc
     * @var string
     */
    public $zawartosc;
    /**
     * The sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @var bool
     */
    public $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
    /**
     * The ostroznie
     * @var bool
     */
    public $ostroznie;
    /**
     * The uiszczaOplate
     * @var string
     */
    public $uiszczaOplate;
    /**
     * The termin
     * @var string
     */
    public $termin;
    /**
     * The opakowanie
     * @var string
     */
    public $opakowanie;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * The numerTransakcjiOdbioru
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $numerTransakcjiOdbioru;
    /**
     * The gabaryt
     * @var string
     */
    public $gabaryt;
    /**
     * Constructor method for uslugaPaczkowaType
     * @uses UslugaPaczkowaType::setSubPrzesylka()
     * @uses UslugaPaczkowaType::setPobranie()
     * @uses UslugaPaczkowaType::setPotwierdzenieDoreczenia()
     * @uses UslugaPaczkowaType::setUrzadWydaniaEPrzesylki()
     * @uses UslugaPaczkowaType::setPotwierdzenieOdbioru()
     * @uses UslugaPaczkowaType::setUbezpieczenie()
     * @uses UslugaPaczkowaType::setZwrotDokumentow()
     * @uses UslugaPaczkowaType::setDoreczenie()
     * @uses UslugaPaczkowaType::setEpo()
     * @uses UslugaPaczkowaType::setZasadySpecjalne()
     * @uses UslugaPaczkowaType::setMasa()
     * @uses UslugaPaczkowaType::setWartosc()
     * @uses UslugaPaczkowaType::setPonadgabaryt()
     * @uses UslugaPaczkowaType::setZawartosc()
     * @uses UslugaPaczkowaType::setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce()
     * @uses UslugaPaczkowaType::setOstroznie()
     * @uses UslugaPaczkowaType::setUiszczaOplate()
     * @uses UslugaPaczkowaType::setTermin()
     * @uses UslugaPaczkowaType::setOpakowanie()
     * @uses UslugaPaczkowaType::setNumerPrzesylkiKlienta()
     * @uses UslugaPaczkowaType::setNumerTransakcjiOdbioru()
     * @uses UslugaPaczkowaType::setGabaryt()
     * @param SubUslugaPaczkowaType[] $subPrzesylka
     * @param PobranieType $pobranie
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @param UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @param PotwierdzenieOdbioruPaczkowaType $potwierdzenieOdbioru
     * @param UbezpieczenieType $ubezpieczenie
     * @param string $zwrotDokumentow
     * @param DoreczenieUslugaPocztowaType $doreczenie
     * @param EPOType $epo
     * @param string $zasadySpecjalne
     * @param int $masa
     * @param int $wartosc
     * @param bool $ponadgabaryt
     * @param string $zawartosc
     * @param bool $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @param bool $ostroznie
     * @param string $uiszczaOplate
     * @param string $termin
     * @param string $opakowanie
     * @param string $numerPrzesylkiKlienta
     * @param string $numerTransakcjiOdbioru
     * @param string $gabaryt
     */
    public function __construct(array $subPrzesylka = array(), PobranieType $pobranie = null, PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null, UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null, PotwierdzenieOdbioruPaczkowaType $potwierdzenieOdbioru = null, UbezpieczenieType $ubezpieczenie = null, $zwrotDokumentow = null, DoreczenieUslugaPocztowaType $doreczenie = null, EPOType $epo = null, $zasadySpecjalne = null, $masa = null, $wartosc = null, $ponadgabaryt = null, $zawartosc = null, $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = null, $ostroznie = null, $uiszczaOplate = null, $termin = null, $opakowanie = null, $numerPrzesylkiKlienta = null, $numerTransakcjiOdbioru = null, $gabaryt = null)
    {
        $this
            ->setSubPrzesylka($subPrzesylka)
            ->setPobranie($pobranie)
            ->setPotwierdzenieDoreczenia($potwierdzenieDoreczenia)
            ->setUrzadWydaniaEPrzesylki($urzadWydaniaEPrzesylki)
            ->setPotwierdzenieOdbioru($potwierdzenieOdbioru)
            ->setUbezpieczenie($ubezpieczenie)
            ->setZwrotDokumentow($zwrotDokumentow)
            ->setDoreczenie($doreczenie)
            ->setEpo($epo)
            ->setZasadySpecjalne($zasadySpecjalne)
            ->setMasa($masa)
            ->setWartosc($wartosc)
            ->setPonadgabaryt($ponadgabaryt)
            ->setZawartosc($zawartosc)
            ->setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce)
            ->setOstroznie($ostroznie)
            ->setUiszczaOplate($uiszczaOplate)
            ->setTermin($termin)
            ->setOpakowanie($opakowanie)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta)
            ->setNumerTransakcjiOdbioru($numerTransakcjiOdbioru)
            ->setGabaryt($gabaryt);
    }
    /**
     * Get subPrzesylka value
     * @return SubUslugaPaczkowaType[]
     */
    public function getSubPrzesylka()
    {
        return isset($this->subPrzesylka) ? $this->subPrzesylka : null;
    }
    /**
     * Set subPrzesylka value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param SubUslugaPaczkowaType[] $subPrzesylka
     * @return UslugaPaczkowaType
     */
    public function setSubPrzesylka(array $subPrzesylka = array())
    {
        if (is_null($subPrzesylka) || (is_array($subPrzesylka) && empty($subPrzesylka))) {
            unset($this->subPrzesylka);
        } else {
            $this->subPrzesylka = $subPrzesylka;
        }
        return $this;
    }
    /**
     * Add item to subPrzesylka value
     * @throws \InvalidArgumentException
     * @param SubUslugaPaczkowaType $item
     * @return UslugaPaczkowaType
     */
    public function addToSubPrzesylka(SubUslugaPaczkowaType $item)
    {
        $this->subPrzesylka[] = $item;
        return $this;
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return UslugaPaczkowaType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get potwierdzenieDoreczenia value
     * @return PotwierdzenieDoreczeniaType|null
     */
    public function getPotwierdzenieDoreczenia()
    {
        return $this->potwierdzenieDoreczenia;
    }
    /**
     * Set potwierdzenieDoreczenia value
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @return UslugaPaczkowaType
     */
    public function setPotwierdzenieDoreczenia(PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null)
    {
        $this->potwierdzenieDoreczenia = $potwierdzenieDoreczenia;
        return $this;
    }
    /**
     * Get urzadWydaniaEPrzesylki value
     * @return UrzadWydaniaEPrzesylkiType|null
     */
    public function getUrzadWydaniaEPrzesylki()
    {
        return isset($this->urzadWydaniaEPrzesylki) ? $this->urzadWydaniaEPrzesylki : null;
    }
    /**
     * Set urzadWydaniaEPrzesylki value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @return UslugaPaczkowaType
     */
    public function setUrzadWydaniaEPrzesylki(UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null)
    {
        if (is_null($urzadWydaniaEPrzesylki) || (is_array($urzadWydaniaEPrzesylki) && empty($urzadWydaniaEPrzesylki))) {
            unset($this->urzadWydaniaEPrzesylki);
        } else {
            $this->urzadWydaniaEPrzesylki = $urzadWydaniaEPrzesylki;
        }
        return $this;
    }
    /**
     * Get potwierdzenieOdbioru value
     * @return PotwierdzenieOdbioruPaczkowaType|null
     */
    public function getPotwierdzenieOdbioru()
    {
        return $this->potwierdzenieOdbioru;
    }
    /**
     * Set potwierdzenieOdbioru value
     * @param PotwierdzenieOdbioruPaczkowaType $potwierdzenieOdbioru
     * @return UslugaPaczkowaType
     */
    public function setPotwierdzenieOdbioru(PotwierdzenieOdbioruPaczkowaType $potwierdzenieOdbioru = null)
    {
        $this->potwierdzenieOdbioru = $potwierdzenieOdbioru;
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return UslugaPaczkowaType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get zwrotDokumentow value
     * @return string|null
     */
    public function getZwrotDokumentow()
    {
        return $this->zwrotDokumentow;
    }
    /**
     * Set zwrotDokumentow value
     * @param string $zwrotDokumentow
     * @return UslugaPaczkowaType
     */
    public function setZwrotDokumentow($zwrotDokumentow = null)
    {
        $this->zwrotDokumentow = $zwrotDokumentow;
        return $this;
    }
    /**
     * Get doreczenie value
     * @return DoreczenieUslugaPocztowaType|null
     */
    public function getDoreczenie()
    {
        return $this->doreczenie;
    }
    /**
     * Set doreczenie value
     * @param DoreczenieUslugaPocztowaType $doreczenie
     * @return UslugaPaczkowaType
     */
    public function setDoreczenie(DoreczenieUslugaPocztowaType $doreczenie = null)
    {
        $this->doreczenie = $doreczenie;
        return $this;
    }
    /**
     * Get epo value
     * @return EPOType|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param EPOType $epo
     * @return UslugaPaczkowaType
     */
    public function setEpo(EPOType $epo = null)
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Get zasadySpecjalne value
     * @return string|null
     */
    public function getZasadySpecjalne()
    {
        return $this->zasadySpecjalne;
    }
    /**
     * Set zasadySpecjalne value
     * @param string $zasadySpecjalne
     * @return UslugaPaczkowaType
     */
    public function setZasadySpecjalne($zasadySpecjalne = null)
    {
        $this->zasadySpecjalne = $zasadySpecjalne;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return UslugaPaczkowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return UslugaPaczkowaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ponadgabaryt value
     * @return bool|null
     */
    public function getPonadgabaryt()
    {
        return $this->ponadgabaryt;
    }
    /**
     * Set ponadgabaryt value
     * @param bool $ponadgabaryt
     * @return UslugaPaczkowaType
     */
    public function setPonadgabaryt($ponadgabaryt = null)
    {
        $this->ponadgabaryt = $ponadgabaryt;
        return $this;
    }
    /**
     * Get zawartosc value
     * @return string|null
     */
    public function getZawartosc()
    {
        return $this->zawartosc;
    }
    /**
     * Set zawartosc value
     * @param string $zawartosc
     * @return UslugaPaczkowaType
     */
    public function setZawartosc($zawartosc = null)
    {
        $this->zawartosc = $zawartosc;
        return $this;
    }
    /**
     * Get sprawdzenieZawartosciPrzesylkiPrzezOdbiorce value
     * @return bool|null
     */
    public function getSprawdzenieZawartosciPrzesylkiPrzezOdbiorce()
    {
        return $this->sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
    }
    /**
     * Set sprawdzenieZawartosciPrzesylkiPrzezOdbiorce value
     * @param bool $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @return UslugaPaczkowaType
     */
    public function setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = null)
    {
        $this->sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return UslugaPaczkowaType
     */
    public function setOstroznie($ostroznie = null)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get uiszczaOplate value
     * @return string|null
     */
    public function getUiszczaOplate()
    {
        return $this->uiszczaOplate;
    }
    /**
     * Set uiszczaOplate value
     * @param string $uiszczaOplate
     * @return UslugaPaczkowaType
     */
    public function setUiszczaOplate($uiszczaOplate = null)
    {
        $this->uiszczaOplate = $uiszczaOplate;
        return $this;
    }
    /**
     * Get termin value
     * @return string|null
     */
    public function getTermin()
    {
        return $this->termin;
    }
    /**
     * Set termin value
     * @param string $termin
     * @return UslugaPaczkowaType
     */
    public function setTermin($termin = null)
    {
        $this->termin = $termin;
        return $this;
    }
    /**
     * Get opakowanie value
     * @return string|null
     */
    public function getOpakowanie()
    {
        return $this->opakowanie;
    }
    /**
     * Set opakowanie value
     * @param string $opakowanie
     * @return UslugaPaczkowaType
     */
    public function setOpakowanie($opakowanie = null)
    {
        $this->opakowanie = $opakowanie;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return UslugaPaczkowaType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Get numerTransakcjiOdbioru value
     * @return string|null
     */
    public function getNumerTransakcjiOdbioru()
    {
        return $this->numerTransakcjiOdbioru;
    }
    /**
     * Set numerTransakcjiOdbioru value
     * @param string $numerTransakcjiOdbioru
     * @return UslugaPaczkowaType
     */
    public function setNumerTransakcjiOdbioru($numerTransakcjiOdbioru = null)
    {
        $this->numerTransakcjiOdbioru = $numerTransakcjiOdbioru;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return UslugaPaczkowaType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
}
