<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subUslugaKurierskaType StructType
 * @subpackage Structs
 */
class SubUslugaKurierskaType extends PrzesylkaType
{
    /**
     * The pobranie
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The ubezpieczenie
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The numerNadania
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 10
     * @var string
     */
    public $numerNadania;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ostroznie
     * @var bool
     */
    public $ostroznie;
    /**
     * The opakowanie
     * @var string
     */
    public $opakowanie;
    /**
     * The ponadgabaryt
     * @var bool
     */
    public $ponadgabaryt;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * Constructor method for subUslugaKurierskaType
     * @uses SubUslugaKurierskaType::setPobranie()
     * @uses SubUslugaKurierskaType::setUbezpieczenie()
     * @uses SubUslugaKurierskaType::setNumerNadania()
     * @uses SubUslugaKurierskaType::setMasa()
     * @uses SubUslugaKurierskaType::setWartosc()
     * @uses SubUslugaKurierskaType::setOstroznie()
     * @uses SubUslugaKurierskaType::setOpakowanie()
     * @uses SubUslugaKurierskaType::setPonadgabaryt()
     * @uses SubUslugaKurierskaType::setNumerPrzesylkiKlienta()
     * @param PobranieType $pobranie
     * @param UbezpieczenieType $ubezpieczenie
     * @param string $numerNadania
     * @param int $masa
     * @param int $wartosc
     * @param bool $ostroznie
     * @param string $opakowanie
     * @param bool $ponadgabaryt
     * @param string $numerPrzesylkiKlienta
     */
    public function __construct(PobranieType $pobranie = null, UbezpieczenieType $ubezpieczenie = null, $numerNadania = null, $masa = null, $wartosc = null, $ostroznie = null, $opakowanie = null, $ponadgabaryt = null, $numerPrzesylkiKlienta = null)
    {
        $this
            ->setPobranie($pobranie)
            ->setUbezpieczenie($ubezpieczenie)
            ->setNumerNadania($numerNadania)
            ->setMasa($masa)
            ->setWartosc($wartosc)
            ->setOstroznie($ostroznie)
            ->setOpakowanie($opakowanie)
            ->setPonadgabaryt($ponadgabaryt)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta);
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return SubUslugaKurierskaType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return SubUslugaKurierskaType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get numerNadania value
     * @return string|null
     */
    public function getNumerNadania()
    {
        return $this->numerNadania;
    }
    /**
     * Set numerNadania value
     * @param string $numerNadania
     * @return SubUslugaKurierskaType
     */
    public function setNumerNadania($numerNadania = null)
    {
        $this->numerNadania = $numerNadania;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return SubUslugaKurierskaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return SubUslugaKurierskaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return SubUslugaKurierskaType
     */
    public function setOstroznie($ostroznie = null)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get opakowanie value
     * @return string|null
     */
    public function getOpakowanie()
    {
        return $this->opakowanie;
    }
    /**
     * Set opakowanie value
     * @param string $opakowanie
     * @return SubUslugaKurierskaType
     */
    public function setOpakowanie($opakowanie = null)
    {
        $this->opakowanie = $opakowanie;
        return $this;
    }
    /**
     * Get ponadgabaryt value
     * @return bool|null
     */
    public function getPonadgabaryt()
    {
        return $this->ponadgabaryt;
    }
    /**
     * Set ponadgabaryt value
     * @param bool $ponadgabaryt
     * @return SubUslugaKurierskaType
     */
    public function setPonadgabaryt($ponadgabaryt = null)
    {
        $this->ponadgabaryt = $ponadgabaryt;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return SubUslugaKurierskaType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
}
