<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paczkaPocztowaPLUSType StructType
 * @subpackage Structs
 */
class PaczkaPocztowaPLUSType extends PrzesylkaRejestrowanaType
{
    /**
     * The kategoria
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $kategoria;
    /**
     * The gabaryt
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $gabaryt;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * - use: required
     * @var int
     */
    public $wartosc;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $masa;
    /**
     * The posteRestante
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $posteRestante;
    /**
     * The iloscPotwierdzenOdbioru
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - default: 0
     * - maxInclusive: 9
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $iloscPotwierdzenOdbioru;
    /**
     * The zwrotDoslanie
     * @var bool
     */
    public $zwrotDoslanie;
    /**
     * Constructor method for paczkaPocztowaPLUSType
     * @uses PaczkaPocztowaPLUSType::setKategoria()
     * @uses PaczkaPocztowaPLUSType::setGabaryt()
     * @uses PaczkaPocztowaPLUSType::setWartosc()
     * @uses PaczkaPocztowaPLUSType::setMasa()
     * @uses PaczkaPocztowaPLUSType::setPosteRestante()
     * @uses PaczkaPocztowaPLUSType::setIloscPotwierdzenOdbioru()
     * @uses PaczkaPocztowaPLUSType::setZwrotDoslanie()
     * @param string $kategoria
     * @param string $gabaryt
     * @param int $wartosc
     * @param int $masa
     * @param bool $posteRestante
     * @param int $iloscPotwierdzenOdbioru
     * @param bool $zwrotDoslanie
     */
    public function __construct($kategoria = null, $gabaryt = null, $wartosc = null, $masa = null, $posteRestante = false, $iloscPotwierdzenOdbioru = 0, $zwrotDoslanie = null)
    {
        $this
            ->setKategoria($kategoria)
            ->setGabaryt($gabaryt)
            ->setWartosc($wartosc)
            ->setMasa($masa)
            ->setPosteRestante($posteRestante)
            ->setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru)
            ->setZwrotDoslanie($zwrotDoslanie);
    }
    /**
     * Get kategoria value
     * @return string
     */
    public function getKategoria()
    {
        return $this->kategoria;
    }
    /**
     * Set kategoria value
     * @param string $kategoria
     * @return PaczkaPocztowaPLUSType
     */
    public function setKategoria($kategoria = null)
    {
        $this->kategoria = $kategoria;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return PaczkaPocztowaPLUSType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PaczkaPocztowaPLUSType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get masa value
     * @return int
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PaczkaPocztowaPLUSType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get posteRestante value
     * @return bool|null
     */
    public function getPosteRestante()
    {
        return $this->posteRestante;
    }
    /**
     * Set posteRestante value
     * @param bool $posteRestante
     * @return PaczkaPocztowaPLUSType
     */
    public function setPosteRestante($posteRestante = false)
    {
        $this->posteRestante = $posteRestante;
        return $this;
    }
    /**
     * Get iloscPotwierdzenOdbioru value
     * @return int|null
     */
    public function getIloscPotwierdzenOdbioru()
    {
        return $this->iloscPotwierdzenOdbioru;
    }
    /**
     * Set iloscPotwierdzenOdbioru value
     * @param int $iloscPotwierdzenOdbioru
     * @return PaczkaPocztowaPLUSType
     */
    public function setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru = 0)
    {
        $this->iloscPotwierdzenOdbioru = $iloscPotwierdzenOdbioru;
        return $this;
    }
    /**
     * Get zwrotDoslanie value
     * @return bool|null
     */
    public function getZwrotDoslanie()
    {
        return $this->zwrotDoslanie;
    }
    /**
     * Set zwrotDoslanie value
     * @param bool $zwrotDoslanie
     * @return PaczkaPocztowaPLUSType
     */
    public function setZwrotDoslanie($zwrotDoslanie = null)
    {
        $this->zwrotDoslanie = $zwrotDoslanie;
        return $this;
    }
}
