<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateEnvelopeBufor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateEnvelopeBufor $parameters
     * @return UpdateEnvelopeBuforResponse|bool
     */
    public function updateEnvelopeBufor(UpdateEnvelopeBufor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEnvelopeBufor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateAccount $parameters
     * @return UpdateAccountResponse|bool
     */
    public function updateAccount(UpdateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateProfil $parameters
     * @return UpdateProfilResponse|bool
     */
    public function updateProfil(UpdateProfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateShopEZwroty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateShopEZwroty $parameters
     * @return UpdateShopEZwrotyResponse|bool
     */
    public function updateShopEZwroty(UpdateShopEZwroty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateShopEZwroty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return UpdateAccountResponse|UpdateEnvelopeBuforResponse|UpdateProfilResponse|UpdateShopEZwrotyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
