<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintType StructType
 * @subpackage Structs
 */
class PrintType extends AbstractStructBase
{
    /**
     * The kind
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kind;
    /**
     * The method
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $method;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The resolution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $resolution;
    /**
     * Constructor method for PrintType
     * @uses PrintType::setKind()
     * @uses PrintType::setMethod()
     * @uses PrintType::setFormat()
     * @uses PrintType::setResolution()
     * @param string $kind
     * @param string $method
     * @param string $format
     * @param string $resolution
     */
    public function __construct($kind = null, $method = null, $format = null, $resolution = null)
    {
        $this
            ->setKind($kind)
            ->setMethod($method)
            ->setFormat($format)
            ->setResolution($resolution);
    }
    /**
     * Get kind value
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * Set kind value
     * @uses PrintKindEnum::valueIsValid()
     * @uses PrintKindEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kind
     * @return PrintType
     */
    public function setKind($kind = null)
    {
        // validation for constraint: enumeration
        if (!PrintKindEnum::valueIsValid($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrintKindEnum', is_array($kind) ? implode(', ', $kind) : var_export($kind, true), implode(', ', PrintKindEnum::getValidValues())), __LINE__);
        }
        $this->kind = $kind;
        return $this;
    }
    /**
     * Get method value
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @uses PrintMethodEnum::valueIsValid()
     * @uses PrintMethodEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $method
     * @return PrintType
     */
    public function setMethod($method = null)
    {
        // validation for constraint: enumeration
        if (!PrintMethodEnum::valueIsValid($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrintMethodEnum', is_array($method) ? implode(', ', $method) : var_export($method, true), implode(', ', PrintMethodEnum::getValidValues())), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses PrintFormatEnum::valueIsValid()
     * @uses PrintFormatEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return PrintType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!PrintFormatEnum::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrintFormatEnum', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', PrintFormatEnum::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get resolution value
     * @return string|null
     */
    public function getResolution()
    {
        return $this->resolution;
    }
    /**
     * Set resolution value
     * @uses PrintResolutionEnum::valueIsValid()
     * @uses PrintResolutionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resolution
     * @return PrintType
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: enumeration
        if (!PrintResolutionEnum::valueIsValid($resolution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrintResolutionEnum', is_array($resolution) ? implode(', ', $resolution) : var_export($resolution, true), implode(', ', PrintResolutionEnum::getValidValues())), __LINE__);
        }
        $this->resolution = $resolution;
        return $this;
    }
}
