<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for marketingowaZAdresemType StructType
 * @subpackage Structs
 */
class MarketingowaZAdresemType extends PrzesylkaType
{
    /**
     * The adres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var AdresType
     */
    public $adres;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - maxOccurs: 1
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $masa;
    /**
     * The gabaryt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gabaryt;
    /**
     * Constructor method for marketingowaZAdresemType
     * @uses MarketingowaZAdresemType::setAdres()
     * @uses MarketingowaZAdresemType::setMasa()
     * @uses MarketingowaZAdresemType::setGabaryt()
     * @param AdresType $adres
     * @param int $masa
     * @param string $gabaryt
     */
    public function __construct(AdresType $adres = null, $masa = null, $gabaryt = null)
    {
        $this
            ->setAdres($adres)
            ->setMasa($masa)
            ->setGabaryt($gabaryt);
    }
    /**
     * Get adres value
     * @return AdresType
     */
    public function getAdres()
    {
        return $this->adres;
    }
    /**
     * Set adres value
     * @param AdresType $adres
     * @return MarketingowaZAdresemType
     */
    public function setAdres(AdresType $adres = null)
    {
        $this->adres = $adres;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return MarketingowaZAdresemType
     */
    public function setMasa($masa = null)
    {
        // validation for constraint: int
        if (!is_null($masa) && !(is_int($masa) || ctype_digit($masa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masa, true), gettype($masa)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($masa) && $masa > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($masa, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($masa) && $masa < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($masa, true)), __LINE__);
        }
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @uses GabarytType::valueIsValid()
     * @uses GabarytType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gabaryt
     * @return MarketingowaZAdresemType
     */
    public function setGabaryt($gabaryt = null)
    {
        // validation for constraint: enumeration
        if (!GabarytType::valueIsValid($gabaryt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class GabarytType', is_array($gabaryt) ? implode(', ', $gabaryt) : var_export($gabaryt, true), implode(', ', GabarytType::getValidValues())), __LINE__);
        }
        $this->gabaryt = $gabaryt;
        return $this;
    }
}
