<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LibraryForLegalDepositType StructType
 * @subpackage Structs
 */
class LibraryForLegalDepositType extends AbstractStructBase
{
    /**
     * The idLibraryForLegalDeposit
     * Meta information extracted from the WSDL
     * - documentation: Library ID to use for shipment data in the <idLibraryForLegalDeposit/> element
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 4
     * - minOccurs: 1
     * @var string
     */
    public $idLibraryForLegalDeposit;
    /**
     * The libraryName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $libraryName;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - documentation: For a P.O. Box, this item includes a string &quot;skr. poczt.&quot; and box_number
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The apartmentNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $apartmentNumber;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 63
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * Constructor method for LibraryForLegalDepositType
     * @uses LibraryForLegalDepositType::setIdLibraryForLegalDeposit()
     * @uses LibraryForLegalDepositType::setLibraryName()
     * @uses LibraryForLegalDepositType::setStreet()
     * @uses LibraryForLegalDepositType::setHouseNumber()
     * @uses LibraryForLegalDepositType::setApartmentNumber()
     * @uses LibraryForLegalDepositType::setZipCode()
     * @uses LibraryForLegalDepositType::setCity()
     * @param string $idLibraryForLegalDeposit
     * @param string $libraryName
     * @param string $street
     * @param string $houseNumber
     * @param string $apartmentNumber
     * @param string $zipCode
     * @param string $city
     */
    public function __construct($idLibraryForLegalDeposit = null, $libraryName = null, $street = null, $houseNumber = null, $apartmentNumber = null, $zipCode = null, $city = null)
    {
        $this
            ->setIdLibraryForLegalDeposit($idLibraryForLegalDeposit)
            ->setLibraryName($libraryName)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setApartmentNumber($apartmentNumber)
            ->setZipCode($zipCode)
            ->setCity($city);
    }
    /**
     * Get idLibraryForLegalDeposit value
     * @return string
     */
    public function getIdLibraryForLegalDeposit()
    {
        return $this->idLibraryForLegalDeposit;
    }
    /**
     * Set idLibraryForLegalDeposit value
     * @param string $idLibraryForLegalDeposit
     * @return LibraryForLegalDepositType
     */
    public function setIdLibraryForLegalDeposit($idLibraryForLegalDeposit = null)
    {
        // validation for constraint: string
        if (!is_null($idLibraryForLegalDeposit) && !is_string($idLibraryForLegalDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idLibraryForLegalDeposit, true), gettype($idLibraryForLegalDeposit)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($idLibraryForLegalDeposit) && mb_strlen($idLibraryForLegalDeposit) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($idLibraryForLegalDeposit)), __LINE__);
        }
        // validation for constraint: minLength(4)
        if (!is_null($idLibraryForLegalDeposit) && mb_strlen($idLibraryForLegalDeposit) < 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 4', mb_strlen($idLibraryForLegalDeposit)), __LINE__);
        }
        $this->idLibraryForLegalDeposit = $idLibraryForLegalDeposit;
        return $this;
    }
    /**
     * Get libraryName value
     * @return string
     */
    public function getLibraryName()
    {
        return $this->libraryName;
    }
    /**
     * Set libraryName value
     * @param string $libraryName
     * @return LibraryForLegalDepositType
     */
    public function setLibraryName($libraryName = null)
    {
        // validation for constraint: string
        if (!is_null($libraryName) && !is_string($libraryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($libraryName, true), gettype($libraryName)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($libraryName) && mb_strlen($libraryName) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($libraryName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($libraryName) && mb_strlen($libraryName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($libraryName)), __LINE__);
        }
        $this->libraryName = $libraryName;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return LibraryForLegalDepositType
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($street) && mb_strlen($street) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($street) && mb_strlen($street) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return LibraryForLegalDepositType
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($houseNumber) && mb_strlen($houseNumber) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($houseNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($houseNumber) && mb_strlen($houseNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get apartmentNumber value
     * @return string|null
     */
    public function getApartmentNumber()
    {
        return $this->apartmentNumber;
    }
    /**
     * Set apartmentNumber value
     * @param string $apartmentNumber
     * @return LibraryForLegalDepositType
     */
    public function setApartmentNumber($apartmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($apartmentNumber) && !is_string($apartmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apartmentNumber, true), gettype($apartmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($apartmentNumber) && mb_strlen($apartmentNumber) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($apartmentNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($apartmentNumber) && mb_strlen($apartmentNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($apartmentNumber)), __LINE__);
        }
        $this->apartmentNumber = $apartmentNumber;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return LibraryForLegalDepositType
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($zipCode) && mb_strlen($zipCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($zipCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($zipCode) && mb_strlen($zipCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return LibraryForLegalDepositType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(63)
        if (!is_null($city) && mb_strlen($city) > 63) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 63', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($city) && mb_strlen($city) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
}
