<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named isMiejscowa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IsMiejscowa $parameters
     * @return IsMiejscowaResponse|bool
     */
    public function isMiejscowa(IsMiejscowa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isMiejscowa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isObszarMiasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IsObszarMiasto $parameters
     * @return IsObszarMiastoResponse|bool
     */
    public function isObszarMiasto(IsObszarMiasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isObszarMiasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return IsMiejscowaResponse|IsObszarMiastoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
