<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Clear ServiceType
 * @subpackage Services
 */
class Clear extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named clearEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ClearEnvelope $parameters
     * @return ClearEnvelopeResponse|bool
     */
    public function clearEnvelope(ClearEnvelope $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->clearEnvelope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named clearEnvelopeByGuids
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ClearEnvelopeByGuids $parameters
     * @return ClearEnvelopeByGuidsResponse|bool
     */
    public function clearEnvelopeByGuids(ClearEnvelopeByGuids $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->clearEnvelopeByGuids($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ClearEnvelopeByGuidsResponse|ClearEnvelopeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
