<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Download ServiceType
 * @subpackage Services
 */
class Download extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named downloadIWDContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DownloadIWDContent $parameters
     * @return DownloadIWDContentResponse|bool
     */
    public function downloadIWDContent(DownloadIWDContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->downloadIWDContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return DownloadIWDContentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
