<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deliveryPathType StructType
 * @subpackage Structs
 */
class DeliveryPathType extends AbstractStructBase
{
    /**
     * The endNode
     * @var string
     */
    public $endNode;
    /**
     * The targetingNode
     * @var string
     */
    public $targetingNode;
    /**
     * The assistantNode
     * @var string
     */
    public $assistantNode;
    /**
     * The reloadingPoint
     * @var string
     */
    public $reloadingPoint;
    /**
     * The postOffice
     * @var string
     */
    public $postOffice;
    /**
     * The deliveryRegion
     * @var string
     */
    public $deliveryRegion;
    /**
     * Constructor method for deliveryPathType
     * @uses DeliveryPathType::setEndNode()
     * @uses DeliveryPathType::setTargetingNode()
     * @uses DeliveryPathType::setAssistantNode()
     * @uses DeliveryPathType::setReloadingPoint()
     * @uses DeliveryPathType::setPostOffice()
     * @uses DeliveryPathType::setDeliveryRegion()
     * @param string $endNode
     * @param string $targetingNode
     * @param string $assistantNode
     * @param string $reloadingPoint
     * @param string $postOffice
     * @param string $deliveryRegion
     */
    public function __construct($endNode = null, $targetingNode = null, $assistantNode = null, $reloadingPoint = null, $postOffice = null, $deliveryRegion = null)
    {
        $this
            ->setEndNode($endNode)
            ->setTargetingNode($targetingNode)
            ->setAssistantNode($assistantNode)
            ->setReloadingPoint($reloadingPoint)
            ->setPostOffice($postOffice)
            ->setDeliveryRegion($deliveryRegion);
    }
    /**
     * Get endNode value
     * @return string|null
     */
    public function getEndNode()
    {
        return $this->endNode;
    }
    /**
     * Set endNode value
     * @param string $endNode
     * @return DeliveryPathType
     */
    public function setEndNode($endNode = null)
    {
        // validation for constraint: string
        if (!is_null($endNode) && !is_string($endNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endNode, true), gettype($endNode)), __LINE__);
        }
        $this->endNode = $endNode;
        return $this;
    }
    /**
     * Get targetingNode value
     * @return string|null
     */
    public function getTargetingNode()
    {
        return $this->targetingNode;
    }
    /**
     * Set targetingNode value
     * @param string $targetingNode
     * @return DeliveryPathType
     */
    public function setTargetingNode($targetingNode = null)
    {
        // validation for constraint: string
        if (!is_null($targetingNode) && !is_string($targetingNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetingNode, true), gettype($targetingNode)), __LINE__);
        }
        $this->targetingNode = $targetingNode;
        return $this;
    }
    /**
     * Get assistantNode value
     * @return string|null
     */
    public function getAssistantNode()
    {
        return $this->assistantNode;
    }
    /**
     * Set assistantNode value
     * @param string $assistantNode
     * @return DeliveryPathType
     */
    public function setAssistantNode($assistantNode = null)
    {
        // validation for constraint: string
        if (!is_null($assistantNode) && !is_string($assistantNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assistantNode, true), gettype($assistantNode)), __LINE__);
        }
        $this->assistantNode = $assistantNode;
        return $this;
    }
    /**
     * Get reloadingPoint value
     * @return string|null
     */
    public function getReloadingPoint()
    {
        return $this->reloadingPoint;
    }
    /**
     * Set reloadingPoint value
     * @param string $reloadingPoint
     * @return DeliveryPathType
     */
    public function setReloadingPoint($reloadingPoint = null)
    {
        // validation for constraint: string
        if (!is_null($reloadingPoint) && !is_string($reloadingPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reloadingPoint, true), gettype($reloadingPoint)), __LINE__);
        }
        $this->reloadingPoint = $reloadingPoint;
        return $this;
    }
    /**
     * Get postOffice value
     * @return string|null
     */
    public function getPostOffice()
    {
        return $this->postOffice;
    }
    /**
     * Set postOffice value
     * @param string $postOffice
     * @return DeliveryPathType
     */
    public function setPostOffice($postOffice = null)
    {
        // validation for constraint: string
        if (!is_null($postOffice) && !is_string($postOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postOffice, true), gettype($postOffice)), __LINE__);
        }
        $this->postOffice = $postOffice;
        return $this;
    }
    /**
     * Get deliveryRegion value
     * @return string|null
     */
    public function getDeliveryRegion()
    {
        return $this->deliveryRegion;
    }
    /**
     * Set deliveryRegion value
     * @param string $deliveryRegion
     * @return DeliveryPathType
     */
    public function setDeliveryRegion($deliveryRegion = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryRegion) && !is_string($deliveryRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryRegion, true), gettype($deliveryRegion)), __LINE__);
        }
        $this->deliveryRegion = $deliveryRegion;
        return $this;
    }
}
