<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createEnvelopeBufor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateEnvelopeBufor $parameters
     * @return CreateEnvelopeBuforResponse|bool
     */
    public function createEnvelopeBufor(CreateEnvelopeBufor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createEnvelopeBufor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateAccount $parameters
     * @return CreateAccountResponse|bool
     */
    public function createAccount(CreateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createProfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateProfil $parameters
     * @return CreateProfilResponse|bool
     */
    public function createProfil(CreateProfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createProfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createShopEZwroty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateShopEZwroty $parameters
     * @return CreateShopEZwrotyResponse|bool
     */
    public function createShopEZwroty(CreateShopEZwroty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createShopEZwroty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return CreateAccountResponse|CreateEnvelopeBuforResponse|CreateProfilResponse|CreateShopEZwrotyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
