<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddShipment $parameters
     * @return AddShipmentResponse|bool
     */
    public function addShipment(AddShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addReklamacje
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddReklamacje $parameters
     * @return AddReklamacjeResponse|bool
     */
    public function addReklamacje(AddReklamacje $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addReklamacje($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addOdwolanieDoReklamacji
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddOdwolanieDoReklamacji $parameters
     * @return AddOdwolanieDoReklamacjiResponse|bool
     */
    public function addOdwolanieDoReklamacji(AddOdwolanieDoReklamacji $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addOdwolanieDoReklamacji($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRozbieznoscDoZapowiedziFaktur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddRozbieznoscDoZapowiedziFaktur $parameters
     * @return AddRozbieznoscDoZapowiedziFakturResponse|bool
     */
    public function addRozbieznoscDoZapowiedziFaktur(AddRozbieznoscDoZapowiedziFaktur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addRozbieznoscDoZapowiedziFaktur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addZalacznikDoReklamacji
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddZalacznikDoReklamacji $parameters
     * @return AddZalacznikDoReklamacjiResponse|bool
     */
    public function addZalacznikDoReklamacji(AddZalacznikDoReklamacji $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addZalacznikDoReklamacji($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return AddOdwolanieDoReklamacjiResponse|AddReklamacjeResponse|AddRozbieznoscDoZapowiedziFakturResponse|AddShipmentResponse|AddZalacznikDoReklamacjiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
