<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Variants StructType
 * @subpackage Structs
 */
class Variants extends AbstractStructBase
{
    /**
     * The Variant
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \LectorSOAP\StructType\Variant[]
     */
    public $Variant;
    /**
     * Constructor method for Variants
     * @uses Variants::setVariant()
     * @param \LectorSOAP\StructType\Variant[] $variant
     */
    public function __construct(array $variant = array())
    {
        $this
            ->setVariant($variant);
    }
    /**
     * Get Variant value
     * @return \LectorSOAP\StructType\Variant[]|null
     */
    public function getVariant()
    {
        return $this->Variant;
    }
    /**
     * This method is responsible for validating the values passed to the setVariant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariant method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariantForArrayConstraintsFromSetVariant(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $variantsVariantItem) {
            // validation for constraint: itemType
            if (!$variantsVariantItem instanceof \LectorSOAP\StructType\Variant) {
                $invalidValues[] = is_object($variantsVariantItem) ? get_class($variantsVariantItem) : sprintf('%s(%s)', gettype($variantsVariantItem), var_export($variantsVariantItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Variant property can only contain items of type \LectorSOAP\StructType\Variant, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Variant value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Variant[] $variant
     * @return \LectorSOAP\StructType\Variants
     */
    public function setVariant(array $variant = array())
    {
        // validation for constraint: array
        if ('' !== ($variantArrayErrorMessage = self::validateVariantForArrayConstraintsFromSetVariant($variant))) {
            throw new \InvalidArgumentException($variantArrayErrorMessage, __LINE__);
        }
        $this->Variant = $variant;
        return $this;
    }
    /**
     * Add item to Variant value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Variant $item
     * @return \LectorSOAP\StructType\Variants
     */
    public function addToVariant(\LectorSOAP\StructType\Variant $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LectorSOAP\StructType\Variant) {
            throw new \InvalidArgumentException(sprintf('The Variant property can only contain items of type \LectorSOAP\StructType\Variant, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Variant[] = $item;
        return $this;
    }
}
