<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TradingPartner StructType
 * @subpackage Structs
 */
class TradingPartner extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - documentation: The identifier used to identify the trading partner in the originating system. It is crucial that this identifier is unique and never reused for any other trading partner. LTS uses this value to determine if the same trading partner
     * is already in the system. If LTS receives a trading partner with same identifier as an existing, but with different information, the existing trading partner will be updated. The updated information will be used for all future references to this
     * trading partner.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $Id;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Optional field for an internal number related to a trading partner, like a customer number or something similar. Currently only used for customer specific reports.
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Trading partner name.
     * - base: xs:string
     * - maxLength: 250
     * @var string
     */
    public $Name;
    /**
     * The ShortName
     * Meta information extracted from the WSDL
     * - documentation: A short name for the trading partner.
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $ShortName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: This field should contain the entire address (Road name, number etc.). Line breaks are allowed and will be preserved.
     * - base: xs:string
     * - maxLength: 500
     * @var string
     */
    public $Address;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - documentation: Postal code for the trading partner address.
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $ZipCode;
    /**
     * The ZipPlace
     * Meta information extracted from the WSDL
     * - documentation: Town or City related to the trading partner address.
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $ZipPlace;
    /**
     * The InternationalCode
     * Meta information extracted from the WSDL
     * - documentation: ISO2 code.
     * - base: xs:string
     * - pattern: [A-Z]{2,3}
     * @var string
     */
    public $InternationalCode;
    /**
     * The TaxNumber
     * Meta information extracted from the WSDL
     * - documentation: This is required information for all local trading partners where the goods are to be declared. This information may be omitted for any other countries(even though the XSD says it is required).
     * - base: xs:string
     * - maxLength: 30
     * @var string
     */
    public $TaxNumber;
    /**
     * The Eori
     * Meta information extracted from the WSDL
     * - documentation: The Economic Operators Registration and Identification number is used as an identification number in all customs procedures when exchanging information with Customs administrations. The number is alpha numeric and consists of an
     * international code (ISO2) followed by a number that is unique for that country. No spaces are allowed and for trade with GB a suffix of 3 zeros is required. Please note that this value may differ from the local tax number in certain cases.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $Eori;
    /**
     * The ExciseNumber
     * Meta information extracted from the WSDL
     * - documentation: The excise number in SEED registry used for EMCS to identification purposes.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $ExciseNumber;
    /**
     * The DestinationTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Used for EMCS e-AD Box 1a to identify the destination. Valid values are as follows: 1 – dispatch to an excise warehouse keeper 2 – dispatch to a registered consignee 3 – dispatch to a registered consignee, who may occasionally
     * receive goods under an excise duty suspension arrangement dispatched from another Member State 4 – direct delivery (delivery to an excise warehouse keeper who receives goods outside the excise warehouse) 5 – dispatch to an exempted consignee
     * (NATO and diplomats, requires a valid permit for exemption from excise duty) 6 – export through another Member State
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationTypeCode;
    /**
     * The RexNumber
     * Meta information extracted from the WSDL
     * - documentation: The Registered Exporter system (in short, the REX system) is a system of certification of origin of goods that the European Union is progressively introducing for the purpose of its preferential trade arrangements. The REX system is
     * based on a principle of self-certification by economic operators who will make out themselves so-called statements on origin. Please note that all registrations for GB businesses have been revoked and should be replaced by EORI.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $RexNumber;
    /**
     * The MvaRequired
     * Meta information extracted from the WSDL
     * - documentation: Yes or No value. Used to inform Norwegian Customs whether MVA(VAT) should be part of the import declaration. The default value is no.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [YN]
     * @var string
     */
    public $MvaRequired;
    /**
     * The GLN
     * Meta information extracted from the WSDL
     * - documentation: Global Location Number.
     * - base: xs:string
     * - maxLength: 13
     * - minOccurs: 0
     * @var string
     */
    public $GLN;
    /**
     * The CustomsAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: This information is used on the Shipping Invoice to inform authorities of the existance of a duty credit account.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $CustomsAccountNumber;
    /**
     * Constructor method for TradingPartner
     * @uses TradingPartner::setId()
     * @uses TradingPartner::setNumber()
     * @uses TradingPartner::setName()
     * @uses TradingPartner::setShortName()
     * @uses TradingPartner::setAddress()
     * @uses TradingPartner::setZipCode()
     * @uses TradingPartner::setZipPlace()
     * @uses TradingPartner::setInternationalCode()
     * @uses TradingPartner::setTaxNumber()
     * @uses TradingPartner::setEori()
     * @uses TradingPartner::setExciseNumber()
     * @uses TradingPartner::setDestinationTypeCode()
     * @uses TradingPartner::setRexNumber()
     * @uses TradingPartner::setMvaRequired()
     * @uses TradingPartner::setGLN()
     * @uses TradingPartner::setCustomsAccountNumber()
     * @param string $id
     * @param string $number
     * @param string $name
     * @param string $shortName
     * @param string $address
     * @param string $zipCode
     * @param string $zipPlace
     * @param string $internationalCode
     * @param string $taxNumber
     * @param string $eori
     * @param string $exciseNumber
     * @param string $destinationTypeCode
     * @param string $rexNumber
     * @param string $mvaRequired
     * @param string $gLN
     * @param string $customsAccountNumber
     */
    public function __construct($id = null, $number = null, $name = null, $shortName = null, $address = null, $zipCode = null, $zipPlace = null, $internationalCode = null, $taxNumber = null, $eori = null, $exciseNumber = null, $destinationTypeCode = null, $rexNumber = null, $mvaRequired = null, $gLN = null, $customsAccountNumber = null)
    {
        $this
            ->setId($id)
            ->setNumber($number)
            ->setName($name)
            ->setShortName($shortName)
            ->setAddress($address)
            ->setZipCode($zipCode)
            ->setZipPlace($zipPlace)
            ->setInternationalCode($internationalCode)
            ->setTaxNumber($taxNumber)
            ->setEori($eori)
            ->setExciseNumber($exciseNumber)
            ->setDestinationTypeCode($destinationTypeCode)
            ->setRexNumber($rexNumber)
            ->setMvaRequired($mvaRequired)
            ->setGLN($gLN)
            ->setCustomsAccountNumber($customsAccountNumber);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($id) && mb_strlen($id) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($number) && mb_strlen($number) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($name) && mb_strlen($name) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ShortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->ShortName;
    }
    /**
     * Set ShortName value
     * @param string $shortName
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortName, true), gettype($shortName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($shortName) && mb_strlen($shortName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($shortName)), __LINE__);
        }
        $this->ShortName = $shortName;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($address) && mb_strlen($address) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($zipCode) && mb_strlen($zipCode) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get ZipPlace value
     * @return string|null
     */
    public function getZipPlace()
    {
        return $this->ZipPlace;
    }
    /**
     * Set ZipPlace value
     * @param string $zipPlace
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setZipPlace($zipPlace = null)
    {
        // validation for constraint: string
        if (!is_null($zipPlace) && !is_string($zipPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipPlace, true), gettype($zipPlace)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($zipPlace) && mb_strlen($zipPlace) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($zipPlace)), __LINE__);
        }
        $this->ZipPlace = $zipPlace;
        return $this;
    }
    /**
     * Get InternationalCode value
     * @return string|null
     */
    public function getInternationalCode()
    {
        return $this->InternationalCode;
    }
    /**
     * Set InternationalCode value
     * @param string $internationalCode
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setInternationalCode($internationalCode = null)
    {
        // validation for constraint: string
        if (!is_null($internationalCode) && !is_string($internationalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalCode, true), gettype($internationalCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,3})
        if (!is_null($internationalCode) && !preg_match('/[A-Z]{2,3}/', $internationalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,3}', var_export($internationalCode, true)), __LINE__);
        }
        $this->InternationalCode = $internationalCode;
        return $this;
    }
    /**
     * Get TaxNumber value
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->TaxNumber;
    }
    /**
     * Set TaxNumber value
     * @param string $taxNumber
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setTaxNumber($taxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxNumber) && !is_string($taxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNumber, true), gettype($taxNumber)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($taxNumber) && mb_strlen($taxNumber) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($taxNumber)), __LINE__);
        }
        $this->TaxNumber = $taxNumber;
        return $this;
    }
    /**
     * Get Eori value
     * @return string|null
     */
    public function getEori()
    {
        return $this->Eori;
    }
    /**
     * Set Eori value
     * @param string $eori
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setEori($eori = null)
    {
        // validation for constraint: string
        if (!is_null($eori) && !is_string($eori)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eori, true), gettype($eori)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($eori) && mb_strlen($eori) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($eori)), __LINE__);
        }
        $this->Eori = $eori;
        return $this;
    }
    /**
     * Get ExciseNumber value
     * @return string|null
     */
    public function getExciseNumber()
    {
        return $this->ExciseNumber;
    }
    /**
     * Set ExciseNumber value
     * @param string $exciseNumber
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setExciseNumber($exciseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($exciseNumber) && !is_string($exciseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exciseNumber, true), gettype($exciseNumber)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($exciseNumber) && mb_strlen($exciseNumber) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($exciseNumber)), __LINE__);
        }
        $this->ExciseNumber = $exciseNumber;
        return $this;
    }
    /**
     * Get DestinationTypeCode value
     * @return string|null
     */
    public function getDestinationTypeCode()
    {
        return $this->DestinationTypeCode;
    }
    /**
     * Set DestinationTypeCode value
     * @param string $destinationTypeCode
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setDestinationTypeCode($destinationTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationTypeCode) && !is_string($destinationTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationTypeCode, true), gettype($destinationTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($destinationTypeCode) && mb_strlen($destinationTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($destinationTypeCode)), __LINE__);
        }
        $this->DestinationTypeCode = $destinationTypeCode;
        return $this;
    }
    /**
     * Get RexNumber value
     * @return string|null
     */
    public function getRexNumber()
    {
        return $this->RexNumber;
    }
    /**
     * Set RexNumber value
     * @param string $rexNumber
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setRexNumber($rexNumber = null)
    {
        // validation for constraint: string
        if (!is_null($rexNumber) && !is_string($rexNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rexNumber, true), gettype($rexNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($rexNumber) && mb_strlen($rexNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($rexNumber)), __LINE__);
        }
        $this->RexNumber = $rexNumber;
        return $this;
    }
    /**
     * Get MvaRequired value
     * @return string|null
     */
    public function getMvaRequired()
    {
        return $this->MvaRequired;
    }
    /**
     * Set MvaRequired value
     * @param string $mvaRequired
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setMvaRequired($mvaRequired = null)
    {
        // validation for constraint: string
        if (!is_null($mvaRequired) && !is_string($mvaRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mvaRequired, true), gettype($mvaRequired)), __LINE__);
        }
        // validation for constraint: pattern([YN])
        if (!is_null($mvaRequired) && !preg_match('/[YN]/', $mvaRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [YN]', var_export($mvaRequired, true)), __LINE__);
        }
        $this->MvaRequired = $mvaRequired;
        return $this;
    }
    /**
     * Get GLN value
     * @return string|null
     */
    public function getGLN()
    {
        return $this->GLN;
    }
    /**
     * Set GLN value
     * @param string $gLN
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setGLN($gLN = null)
    {
        // validation for constraint: string
        if (!is_null($gLN) && !is_string($gLN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLN, true), gettype($gLN)), __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($gLN) && mb_strlen($gLN) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen($gLN)), __LINE__);
        }
        $this->GLN = $gLN;
        return $this;
    }
    /**
     * Get CustomsAccountNumber value
     * @return string|null
     */
    public function getCustomsAccountNumber()
    {
        return $this->CustomsAccountNumber;
    }
    /**
     * Set CustomsAccountNumber value
     * @param string $customsAccountNumber
     * @return \LectorSOAP\StructType\TradingPartner
     */
    public function setCustomsAccountNumber($customsAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customsAccountNumber) && !is_string($customsAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsAccountNumber, true), gettype($customsAccountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($customsAccountNumber) && mb_strlen($customsAccountNumber) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($customsAccountNumber)), __LINE__);
        }
        $this->CustomsAccountNumber = $customsAccountNumber;
        return $this;
    }
}
