<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierDocuments StructType
 * @subpackage Structs
 */
class SupplierDocuments extends AbstractStructBase
{
    /**
     * The SupplierDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \LectorSOAP\StructType\Document[]
     */
    public $SupplierDocument;
    /**
     * Constructor method for SupplierDocuments
     * @uses SupplierDocuments::setSupplierDocument()
     * @param \LectorSOAP\StructType\Document[] $supplierDocument
     */
    public function __construct(array $supplierDocument = array())
    {
        $this
            ->setSupplierDocument($supplierDocument);
    }
    /**
     * Get SupplierDocument value
     * @return \LectorSOAP\StructType\Document[]|null
     */
    public function getSupplierDocument()
    {
        return $this->SupplierDocument;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplierDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplierDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplierDocumentForArrayConstraintsFromSetSupplierDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierDocumentsSupplierDocumentItem) {
            // validation for constraint: itemType
            if (!$supplierDocumentsSupplierDocumentItem instanceof \LectorSOAP\StructType\Document) {
                $invalidValues[] = is_object($supplierDocumentsSupplierDocumentItem) ? get_class($supplierDocumentsSupplierDocumentItem) : sprintf('%s(%s)', gettype($supplierDocumentsSupplierDocumentItem), var_export($supplierDocumentsSupplierDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplierDocument property can only contain items of type \LectorSOAP\StructType\Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplierDocument value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Document[] $supplierDocument
     * @return \LectorSOAP\StructType\SupplierDocuments
     */
    public function setSupplierDocument(array $supplierDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($supplierDocumentArrayErrorMessage = self::validateSupplierDocumentForArrayConstraintsFromSetSupplierDocument($supplierDocument))) {
            throw new \InvalidArgumentException($supplierDocumentArrayErrorMessage, __LINE__);
        }
        $this->SupplierDocument = $supplierDocument;
        return $this;
    }
    /**
     * Add item to SupplierDocument value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Document $item
     * @return \LectorSOAP\StructType\SupplierDocuments
     */
    public function addToSupplierDocument(\LectorSOAP\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LectorSOAP\StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The SupplierDocument property can only contain items of type \LectorSOAP\StructType\Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SupplierDocument[] = $item;
        return $this;
    }
}
