<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceHeader StructType
 * Meta information extracted from the WSDL
 * - documentation: The main inbound. | Common information enveloping several inbound elements.
 * @subpackage Structs
 */
class InterfaceHeader extends AbstractStructBase
{
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: The version attribute defines the version number for the XML file. This is used solely by the update functionality, to determine which file should be the final one, if multiple files marked as updates are present in the import folder
     * at the same time. The number used is not important, as long as it is an actual number and the latest file has the highest number.
     * - use: required
     * @var string
     */
    public $version;
    /**
     * The originatingsystem
     * Meta information extracted from the WSDL
     * - documentation: This should indicate the origin of the data in the XML file. The actual information given here should be a LTS username of the originating system. E.g. if the XML is exported from a C5 system, you could write “MY-C5” in this
     * attribute, and then create a user with that username under user management in the LTS user interface with further description of the originating system.
     * - use: required
     * @var string
     */
    public $originatingsystem;
    /**
     * The systemdate
     * Meta information extracted from the WSDL
     * - documentation: The time and date where this file were exported from the source system.
     * - use: required
     * @var string
     */
    public $systemdate;
    /**
     * The Inbound
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:Inbound
     * @var \LectorSOAP\StructType\Inbound[]
     */
    public $Inbound;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - documentation: The user who triggered the generation of this file, in the originating system. It is important to register this user in LTS under ADMIN->Administration->User Management.
     * @var string
     */
    public $username;
    /**
     * The testindicator
     * Meta information extracted from the WSDL
     * - documentation: An indicator for test-files that should not manipulate data. This attribute may be omitted in production files (it defaults to false)
     * - base: xs:string
     * - default: N
     * - pattern: [YN]
     * @var string
     */
    public $testindicator;
    /**
     * Constructor method for InterfaceHeader
     * @uses InterfaceHeader::setVersion()
     * @uses InterfaceHeader::setOriginatingsystem()
     * @uses InterfaceHeader::setSystemdate()
     * @uses InterfaceHeader::setInbound()
     * @uses InterfaceHeader::setUsername()
     * @uses InterfaceHeader::setTestindicator()
     * @param string $version
     * @param string $originatingsystem
     * @param string $systemdate
     * @param \LectorSOAP\StructType\Inbound[] $inbound
     * @param string $username
     * @param string $testindicator
     */
    public function __construct($version = null, $originatingsystem = null, $systemdate = null, array $inbound = array(), $username = null, $testindicator = 'N')
    {
        $this
            ->setVersion($version)
            ->setOriginatingsystem($originatingsystem)
            ->setSystemdate($systemdate)
            ->setInbound($inbound)
            ->setUsername($username)
            ->setTestindicator($testindicator);
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \LectorSOAP\StructType\InterfaceHeader
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get originatingsystem value
     * @return string
     */
    public function getOriginatingsystem()
    {
        return $this->originatingsystem;
    }
    /**
     * Set originatingsystem value
     * @param string $originatingsystem
     * @return \LectorSOAP\StructType\InterfaceHeader
     */
    public function setOriginatingsystem($originatingsystem = null)
    {
        // validation for constraint: string
        if (!is_null($originatingsystem) && !is_string($originatingsystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatingsystem, true), gettype($originatingsystem)), __LINE__);
        }
        $this->originatingsystem = $originatingsystem;
        return $this;
    }
    /**
     * Get systemdate value
     * @return string
     */
    public function getSystemdate()
    {
        return $this->systemdate;
    }
    /**
     * Set systemdate value
     * @param string $systemdate
     * @return \LectorSOAP\StructType\InterfaceHeader
     */
    public function setSystemdate($systemdate = null)
    {
        // validation for constraint: string
        if (!is_null($systemdate) && !is_string($systemdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemdate, true), gettype($systemdate)), __LINE__);
        }
        $this->systemdate = $systemdate;
        return $this;
    }
    /**
     * Get Inbound value
     * @return \LectorSOAP\StructType\Inbound[]|null
     */
    public function getInbound()
    {
        return $this->Inbound;
    }
    /**
     * This method is responsible for validating the values passed to the setInbound method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInbound method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInboundForArrayConstraintsFromSetInbound(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interfaceHeaderInboundItem) {
            // validation for constraint: itemType
            if (!$interfaceHeaderInboundItem instanceof \LectorSOAP\StructType\Inbound) {
                $invalidValues[] = is_object($interfaceHeaderInboundItem) ? get_class($interfaceHeaderInboundItem) : sprintf('%s(%s)', gettype($interfaceHeaderInboundItem), var_export($interfaceHeaderInboundItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Inbound property can only contain items of type \LectorSOAP\StructType\Inbound, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Inbound value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Inbound[] $inbound
     * @return \LectorSOAP\StructType\InterfaceHeader
     */
    public function setInbound(array $inbound = array())
    {
        // validation for constraint: array
        if ('' !== ($inboundArrayErrorMessage = self::validateInboundForArrayConstraintsFromSetInbound($inbound))) {
            throw new \InvalidArgumentException($inboundArrayErrorMessage, __LINE__);
        }
        $this->Inbound = $inbound;
        return $this;
    }
    /**
     * Add item to Inbound value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Inbound $item
     * @return \LectorSOAP\StructType\InterfaceHeader
     */
    public function addToInbound(\LectorSOAP\StructType\Inbound $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LectorSOAP\StructType\Inbound) {
            throw new \InvalidArgumentException(sprintf('The Inbound property can only contain items of type \LectorSOAP\StructType\Inbound, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Inbound[] = $item;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \LectorSOAP\StructType\InterfaceHeader
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get testindicator value
     * @return string|null
     */
    public function getTestindicator()
    {
        return $this->testindicator;
    }
    /**
     * Set testindicator value
     * @param string $testindicator
     * @return \LectorSOAP\StructType\InterfaceHeader
     */
    public function setTestindicator($testindicator = 'N')
    {
        // validation for constraint: string
        if (!is_null($testindicator) && !is_string($testindicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testindicator, true), gettype($testindicator)), __LINE__);
        }
        // validation for constraint: pattern([YN])
        if (!is_null($testindicator) && !preg_match('/[YN]/', $testindicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [YN]', var_export($testindicator, true)), __LINE__);
        }
        $this->testindicator = $testindicator;
        return $this;
    }
}
