<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundDocuments StructType
 * @subpackage Structs
 */
class InboundDocuments extends AbstractStructBase
{
    /**
     * The InboundDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \LectorSOAP\StructType\Document[]
     */
    public $InboundDocument;
    /**
     * Constructor method for InboundDocuments
     * @uses InboundDocuments::setInboundDocument()
     * @param \LectorSOAP\StructType\Document[] $inboundDocument
     */
    public function __construct(array $inboundDocument = array())
    {
        $this
            ->setInboundDocument($inboundDocument);
    }
    /**
     * Get InboundDocument value
     * @return \LectorSOAP\StructType\Document[]|null
     */
    public function getInboundDocument()
    {
        return $this->InboundDocument;
    }
    /**
     * This method is responsible for validating the values passed to the setInboundDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInboundDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInboundDocumentForArrayConstraintsFromSetInboundDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundDocumentsInboundDocumentItem) {
            // validation for constraint: itemType
            if (!$inboundDocumentsInboundDocumentItem instanceof \LectorSOAP\StructType\Document) {
                $invalidValues[] = is_object($inboundDocumentsInboundDocumentItem) ? get_class($inboundDocumentsInboundDocumentItem) : sprintf('%s(%s)', gettype($inboundDocumentsInboundDocumentItem), var_export($inboundDocumentsInboundDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InboundDocument property can only contain items of type \LectorSOAP\StructType\Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InboundDocument value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Document[] $inboundDocument
     * @return \LectorSOAP\StructType\InboundDocuments
     */
    public function setInboundDocument(array $inboundDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($inboundDocumentArrayErrorMessage = self::validateInboundDocumentForArrayConstraintsFromSetInboundDocument($inboundDocument))) {
            throw new \InvalidArgumentException($inboundDocumentArrayErrorMessage, __LINE__);
        }
        $this->InboundDocument = $inboundDocument;
        return $this;
    }
    /**
     * Add item to InboundDocument value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Document $item
     * @return \LectorSOAP\StructType\InboundDocuments
     */
    public function addToInboundDocument(\LectorSOAP\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LectorSOAP\StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The InboundDocument property can only contain items of type \LectorSOAP\StructType\Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InboundDocument[] = $item;
        return $this;
    }
}
