<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Inbound StructType
 * Meta information extracted from the WSDL
 * - documentation: This tag should contain any documents that are general for the entire transport and not limited to any specific PurchaseOrder, e.g. transport document(s). The InboundDocuments-tag should be thought of as a list, containing one to
 * many InboundDocumenttags (which should comply with the Documents datatype, as specified in COMMON.xsd). The InboundDocuments-tag itself may be omitted entirely, if no documents are attached to the transport. Transport documents from this tag are
 * automatically added to SAD box 40 on the import declaration. | This element holds a collection of all purchase orders / products available on the transport. | Note: This section relies on the XSD default values of minOccurs, maxOccurs and nillable
 * attributes (1, 1, false) This effectively means that any field with nothing else specified is mandatory by default.
 * @subpackage Structs
 */
class Inbound extends AbstractStructBase
{
    /**
     * The InboundType
     * Meta information extracted from the WSDL
     * - documentation: The inboundType-tag determines if a file contains a new transport (1) or an update (2).
     * - default: 1
     * @var string
     */
    public $InboundType;
    /**
     * The MakeImport
     * Meta information extracted from the WSDL
     * - documentation: Automatically validates data and makes an import declaration.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [YN]
     * @var string
     */
    public $MakeImport;
    /**
     * The MakePrePurchaseOrders
     * Meta information extracted from the WSDL
     * - documentation: Make pre-purchase orders for sample transports. This type of purchase order is used when creating documents in LTS.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [YN]
     * @var string
     */
    public $MakePrePurchaseOrders;
    /**
     * The SourceShipmentId
     * Meta information extracted from the WSDL
     * - documentation: TODO
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $SourceShipmentId;
    /**
     * The TransportId
     * Meta information extracted from the WSDL
     * - documentation: This is the transport identifier in the originating system. This identifier should be unique and may not be used for other transports.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $TransportId;
    /**
     * The TransportReference
     * Meta information extracted from the WSDL
     * - documentation: AWB/TruckNumber/ContainerNumber
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $TransportReference;
    /**
     * The TransportCode
     * Meta information extracted from the WSDL
     * - documentation: Defines the transport mode at the border crossing. The current valid values are 1(Sea), 2(Rail), 3(Land), 4(Air), 5(Post), 7(Pipe), 8(Canal), 9(Other). This will set the initial value for SAD Box 25 on the import declaration.
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $TransportCode;
    /**
     * The TotalGrossMass
     * Meta information extracted from the WSDL
     * - documentation: The total gross mass for the transport.
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $TotalGrossMass;
    /**
     * The TotalNetMass
     * Meta information extracted from the WSDL
     * - documentation: The total net mass for the transport.
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $TotalNetMass;
    /**
     * The TotalPackageQty
     * Meta information extracted from the WSDL
     * - documentation: The total number of packages or colli for the transport. The value is transferred to SAD Box 6 on the import declaration.
     * - base: xs:int
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $TotalPackageQty;
    /**
     * The TransportNumber
     * Meta information extracted from the WSDL
     * - documentation: This element identifies the transport and is used in the SAD document Box 18.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $TransportNumber;
    /**
     * The Eta
     * Meta information extracted from the WSDL
     * - documentation: The estimated time of border arrival and is used in the SAD document Box ETA.
     * @var string
     */
    public $Eta;
    /**
     * The Etd
     * Meta information extracted from the WSDL
     * - documentation: TODO
     * - minOccurs: 0
     * @var string
     */
    public $Etd;
    /**
     * The CustomsOfficeCode
     * Meta information extracted from the WSDL
     * - documentation: The customs office code for the handling office SAD Box 18. e.g. '5604'
     * - minOccurs: 0
     * @var string
     */
    public $CustomsOfficeCode;
    /**
     * The WarehouseName
     * Meta information extracted from the WSDL
     * - documentation: The name of the goods-in warehouse. The name must match a warehouse that exists in LTS.
     * - minOccurs: 0
     * @var string
     */
    public $WarehouseName;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: The carrier for the selected transport. This is the value that will be shown in the “Carrier” column on the Inbound Overview page. Please note that this element is a Trading Partner data type which includes several sub-tags of
     * mandatory data.
     * - minOccurs: 0
     * @var \LectorSOAP\StructType\TradingPartner
     */
    public $Carrier;
    /**
     * The Agent
     * Meta information extracted from the WSDL
     * - documentation: An Agent is a person or company acting on behalf of the customs authorisation holder. The holder of the authorisation may appoint a customs agent as its direct representative. A written agreement must be provided to local customs if
     * requested. The direct representative who completes and signs box 54 in the SAD is indicated in box 14. As a person other than the debtor, this person may also pay the import duties in lieu of the debtor (Article 81(3) of UCC). In this case, code 2
     * should be entered in box 14 before the full name and address to designate the status of the representative. Please note that this element is a Trading Partner data type which includes several sub-tags of mandatory data.
     * @var \LectorSOAP\StructType\TradingPartner
     */
    public $Agent;
    /**
     * The Declarant
     * Meta information extracted from the WSDL
     * - documentation: A "declarant" is the person or company lodging the customs declaration in accordance with the authorisation given by local customs (SAD Box 14). Please note that this element is a Trading Partner data type which includes several
     * sub-tags of mandatory data.
     * @var \LectorSOAP\StructType\TradingPartner
     */
    public $Declarant;
    /**
     * The FreightAmountEu
     * Meta information extracted from the WSDL
     * - documentation: The freight costs within the EU. SAD Box 12.
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $FreightAmountEu;
    /**
     * The FreightAmountNonEu
     * Meta information extracted from the WSDL
     * - documentation: The freight costs incurred outside the EU. SAD Box 12. This cost is used in calculating the statistical value of the goods.
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $FreightAmountNonEu;
    /**
     * The FreightCurrency
     * Meta information extracted from the WSDL
     * - documentation: If freight costs are present in the file then a currency is required.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $FreightCurrency;
    /**
     * The InvoiceAmount
     * Meta information extracted from the WSDL
     * - documentation: The total amount on the supplier invoice or trade document. This is the initial value for SAD Box 22 and should reflect the total purchase for the transport.
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $InvoiceAmount;
    /**
     * The InvoiceCurrency
     * Meta information extracted from the WSDL
     * - documentation: The currency used on the trade document. This value is required if an invoice amount is present in the file. Note that this currency value should match the currency on the purchase order.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $InvoiceCurrency;
    /**
     * The LicenseNumber
     * Meta information extracted from the WSDL
     * - documentation: The customs permit number for the receiver of the goods.
     * - minOccurs: 0
     * @var string
     */
    public $LicenseNumber;
    /**
     * The CustomsCountry
     * Meta information extracted from the WSDL
     * - documentation: The country code - ISO2 - for the customs authority handling the import declaration.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [A-Z]{2,3}
     * @var string
     */
    public $CustomsCountry;
    /**
     * The IgnoreAutoReservation
     * Meta information extracted from the WSDL
     * - documentation: Goods may be reserved automatically and later released with a "goods-in" message when the goods arrive at the warehouse. This prohibits the Warehouse module in comparing stock under a duty suspension procedure with stock that has not
     * yet arrived at the warehouse. Auto-reservations is an option that must be configured for each individual customer. The Ignore Autoreservation flag (Y/N) overides the permit-location value in LTS.
     * - minOccurs: 0
     * @var string
     */
    public $IgnoreAutoReservation;
    /**
     * The Consignee
     * Meta information extracted from the WSDL
     * - documentation: This element identifies the receiver of the goods - Consignee - and is used in the SAD document Box 8. Please note that this element is a Trading Partner data type which includes several sub-tags of mandatory data.
     * @var \LectorSOAP\StructType\TradingPartner
     */
    public $Consignee;
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - documentation: This element identifies the supplier of the goods - Consignor - and is used in the SAD document Box 2. Please note that this element is a Trading Partner data type which includes several sub-tags of mandatory data.
     * @var \LectorSOAP\StructType\TradingPartner
     */
    public $Supplier;
    /**
     * The InboundCargo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:InboundCargo
     * @var \LectorSOAP\StructType\InboundCargo[]
     */
    public $InboundCargo;
    /**
     * The InboundDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:InboundDocuments
     * @var \LectorSOAP\StructType\InboundDocuments
     */
    public $InboundDocuments;
    /**
     * Constructor method for Inbound
     * @uses Inbound::setInboundType()
     * @uses Inbound::setMakeImport()
     * @uses Inbound::setMakePrePurchaseOrders()
     * @uses Inbound::setSourceShipmentId()
     * @uses Inbound::setTransportId()
     * @uses Inbound::setTransportReference()
     * @uses Inbound::setTransportCode()
     * @uses Inbound::setTotalGrossMass()
     * @uses Inbound::setTotalNetMass()
     * @uses Inbound::setTotalPackageQty()
     * @uses Inbound::setTransportNumber()
     * @uses Inbound::setEta()
     * @uses Inbound::setEtd()
     * @uses Inbound::setCustomsOfficeCode()
     * @uses Inbound::setWarehouseName()
     * @uses Inbound::setCarrier()
     * @uses Inbound::setAgent()
     * @uses Inbound::setDeclarant()
     * @uses Inbound::setFreightAmountEu()
     * @uses Inbound::setFreightAmountNonEu()
     * @uses Inbound::setFreightCurrency()
     * @uses Inbound::setInvoiceAmount()
     * @uses Inbound::setInvoiceCurrency()
     * @uses Inbound::setLicenseNumber()
     * @uses Inbound::setCustomsCountry()
     * @uses Inbound::setIgnoreAutoReservation()
     * @uses Inbound::setConsignee()
     * @uses Inbound::setSupplier()
     * @uses Inbound::setInboundCargo()
     * @uses Inbound::setInboundDocuments()
     * @param string $inboundType
     * @param string $makeImport
     * @param string $makePrePurchaseOrders
     * @param string $sourceShipmentId
     * @param string $transportId
     * @param string $transportReference
     * @param string $transportCode
     * @param float $totalGrossMass
     * @param float $totalNetMass
     * @param int $totalPackageQty
     * @param string $transportNumber
     * @param string $eta
     * @param string $etd
     * @param string $customsOfficeCode
     * @param string $warehouseName
     * @param \LectorSOAP\StructType\TradingPartner $carrier
     * @param \LectorSOAP\StructType\TradingPartner $agent
     * @param \LectorSOAP\StructType\TradingPartner $declarant
     * @param float $freightAmountEu
     * @param float $freightAmountNonEu
     * @param string $freightCurrency
     * @param float $invoiceAmount
     * @param string $invoiceCurrency
     * @param string $licenseNumber
     * @param string $customsCountry
     * @param string $ignoreAutoReservation
     * @param \LectorSOAP\StructType\TradingPartner $consignee
     * @param \LectorSOAP\StructType\TradingPartner $supplier
     * @param \LectorSOAP\StructType\InboundCargo[] $inboundCargo
     * @param \LectorSOAP\StructType\InboundDocuments $inboundDocuments
     */
    public function __construct($inboundType = '1', $makeImport = null, $makePrePurchaseOrders = null, $sourceShipmentId = null, $transportId = null, $transportReference = null, $transportCode = null, $totalGrossMass = null, $totalNetMass = null, $totalPackageQty = null, $transportNumber = null, $eta = null, $etd = null, $customsOfficeCode = null, $warehouseName = null, \LectorSOAP\StructType\TradingPartner $carrier = null, \LectorSOAP\StructType\TradingPartner $agent = null, \LectorSOAP\StructType\TradingPartner $declarant = null, $freightAmountEu = null, $freightAmountNonEu = null, $freightCurrency = null, $invoiceAmount = null, $invoiceCurrency = null, $licenseNumber = null, $customsCountry = null, $ignoreAutoReservation = null, \LectorSOAP\StructType\TradingPartner $consignee = null, \LectorSOAP\StructType\TradingPartner $supplier = null, array $inboundCargo = array(), \LectorSOAP\StructType\InboundDocuments $inboundDocuments = null)
    {
        $this
            ->setInboundType($inboundType)
            ->setMakeImport($makeImport)
            ->setMakePrePurchaseOrders($makePrePurchaseOrders)
            ->setSourceShipmentId($sourceShipmentId)
            ->setTransportId($transportId)
            ->setTransportReference($transportReference)
            ->setTransportCode($transportCode)
            ->setTotalGrossMass($totalGrossMass)
            ->setTotalNetMass($totalNetMass)
            ->setTotalPackageQty($totalPackageQty)
            ->setTransportNumber($transportNumber)
            ->setEta($eta)
            ->setEtd($etd)
            ->setCustomsOfficeCode($customsOfficeCode)
            ->setWarehouseName($warehouseName)
            ->setCarrier($carrier)
            ->setAgent($agent)
            ->setDeclarant($declarant)
            ->setFreightAmountEu($freightAmountEu)
            ->setFreightAmountNonEu($freightAmountNonEu)
            ->setFreightCurrency($freightCurrency)
            ->setInvoiceAmount($invoiceAmount)
            ->setInvoiceCurrency($invoiceCurrency)
            ->setLicenseNumber($licenseNumber)
            ->setCustomsCountry($customsCountry)
            ->setIgnoreAutoReservation($ignoreAutoReservation)
            ->setConsignee($consignee)
            ->setSupplier($supplier)
            ->setInboundCargo($inboundCargo)
            ->setInboundDocuments($inboundDocuments);
    }
    /**
     * Get InboundType value
     * @return string|null
     */
    public function getInboundType()
    {
        return $this->InboundType;
    }
    /**
     * Set InboundType value
     * @uses \LectorSOAP\EnumType\InboundType::valueIsValid()
     * @uses \LectorSOAP\EnumType\InboundType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inboundType
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setInboundType($inboundType = '1')
    {
        // validation for constraint: enumeration
        if (!\LectorSOAP\EnumType\InboundType::valueIsValid($inboundType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LectorSOAP\EnumType\InboundType', is_array($inboundType) ? implode(', ', $inboundType) : var_export($inboundType, true), implode(', ', \LectorSOAP\EnumType\InboundType::getValidValues())), __LINE__);
        }
        $this->InboundType = $inboundType;
        return $this;
    }
    /**
     * Get MakeImport value
     * @return string|null
     */
    public function getMakeImport()
    {
        return $this->MakeImport;
    }
    /**
     * Set MakeImport value
     * @param string $makeImport
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setMakeImport($makeImport = null)
    {
        // validation for constraint: string
        if (!is_null($makeImport) && !is_string($makeImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($makeImport, true), gettype($makeImport)), __LINE__);
        }
        // validation for constraint: pattern([YN])
        if (!is_null($makeImport) && !preg_match('/[YN]/', $makeImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [YN]', var_export($makeImport, true)), __LINE__);
        }
        $this->MakeImport = $makeImport;
        return $this;
    }
    /**
     * Get MakePrePurchaseOrders value
     * @return string|null
     */
    public function getMakePrePurchaseOrders()
    {
        return $this->MakePrePurchaseOrders;
    }
    /**
     * Set MakePrePurchaseOrders value
     * @param string $makePrePurchaseOrders
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setMakePrePurchaseOrders($makePrePurchaseOrders = null)
    {
        // validation for constraint: string
        if (!is_null($makePrePurchaseOrders) && !is_string($makePrePurchaseOrders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($makePrePurchaseOrders, true), gettype($makePrePurchaseOrders)), __LINE__);
        }
        // validation for constraint: pattern([YN])
        if (!is_null($makePrePurchaseOrders) && !preg_match('/[YN]/', $makePrePurchaseOrders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [YN]', var_export($makePrePurchaseOrders, true)), __LINE__);
        }
        $this->MakePrePurchaseOrders = $makePrePurchaseOrders;
        return $this;
    }
    /**
     * Get SourceShipmentId value
     * @return string|null
     */
    public function getSourceShipmentId()
    {
        return $this->SourceShipmentId;
    }
    /**
     * Set SourceShipmentId value
     * @param string $sourceShipmentId
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setSourceShipmentId($sourceShipmentId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceShipmentId) && !is_string($sourceShipmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceShipmentId, true), gettype($sourceShipmentId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($sourceShipmentId) && mb_strlen($sourceShipmentId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($sourceShipmentId)), __LINE__);
        }
        $this->SourceShipmentId = $sourceShipmentId;
        return $this;
    }
    /**
     * Get TransportId value
     * @return string|null
     */
    public function getTransportId()
    {
        return $this->TransportId;
    }
    /**
     * Set TransportId value
     * @param string $transportId
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setTransportId($transportId = null)
    {
        // validation for constraint: string
        if (!is_null($transportId) && !is_string($transportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportId, true), gettype($transportId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($transportId) && mb_strlen($transportId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($transportId)), __LINE__);
        }
        $this->TransportId = $transportId;
        return $this;
    }
    /**
     * Get TransportReference value
     * @return string|null
     */
    public function getTransportReference()
    {
        return $this->TransportReference;
    }
    /**
     * Set TransportReference value
     * @param string $transportReference
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setTransportReference($transportReference = null)
    {
        // validation for constraint: string
        if (!is_null($transportReference) && !is_string($transportReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportReference, true), gettype($transportReference)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($transportReference) && mb_strlen($transportReference) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($transportReference)), __LINE__);
        }
        $this->TransportReference = $transportReference;
        return $this;
    }
    /**
     * Get TransportCode value
     * @return string|null
     */
    public function getTransportCode()
    {
        return $this->TransportCode;
    }
    /**
     * Set TransportCode value
     * @param string $transportCode
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setTransportCode($transportCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportCode) && !is_string($transportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportCode, true), gettype($transportCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($transportCode) && mb_strlen($transportCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($transportCode)), __LINE__);
        }
        $this->TransportCode = $transportCode;
        return $this;
    }
    /**
     * Get TotalGrossMass value
     * @return float|null
     */
    public function getTotalGrossMass()
    {
        return $this->TotalGrossMass;
    }
    /**
     * Set TotalGrossMass value
     * @param float $totalGrossMass
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setTotalGrossMass($totalGrossMass = null)
    {
        // validation for constraint: float
        if (!is_null($totalGrossMass) && !(is_float($totalGrossMass) || is_numeric($totalGrossMass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalGrossMass, true), gettype($totalGrossMass)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($totalGrossMass) && $totalGrossMass < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($totalGrossMass, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($totalGrossMass) && !preg_match('/[0-9]*[.]?[0-9]+/', $totalGrossMass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($totalGrossMass, true)), __LINE__);
        }
        $this->TotalGrossMass = $totalGrossMass;
        return $this;
    }
    /**
     * Get TotalNetMass value
     * @return float|null
     */
    public function getTotalNetMass()
    {
        return $this->TotalNetMass;
    }
    /**
     * Set TotalNetMass value
     * @param float $totalNetMass
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setTotalNetMass($totalNetMass = null)
    {
        // validation for constraint: float
        if (!is_null($totalNetMass) && !(is_float($totalNetMass) || is_numeric($totalNetMass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalNetMass, true), gettype($totalNetMass)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($totalNetMass) && $totalNetMass < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($totalNetMass, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($totalNetMass) && !preg_match('/[0-9]*[.]?[0-9]+/', $totalNetMass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($totalNetMass, true)), __LINE__);
        }
        $this->TotalNetMass = $totalNetMass;
        return $this;
    }
    /**
     * Get TotalPackageQty value
     * @return int|null
     */
    public function getTotalPackageQty()
    {
        return $this->TotalPackageQty;
    }
    /**
     * Set TotalPackageQty value
     * @param int $totalPackageQty
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setTotalPackageQty($totalPackageQty = null)
    {
        // validation for constraint: int
        if (!is_null($totalPackageQty) && !(is_int($totalPackageQty) || ctype_digit($totalPackageQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPackageQty, true), gettype($totalPackageQty)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($totalPackageQty) && $totalPackageQty < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($totalPackageQty, true)), __LINE__);
        }
        $this->TotalPackageQty = $totalPackageQty;
        return $this;
    }
    /**
     * Get TransportNumber value
     * @return string|null
     */
    public function getTransportNumber()
    {
        return $this->TransportNumber;
    }
    /**
     * Set TransportNumber value
     * @param string $transportNumber
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setTransportNumber($transportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transportNumber) && !is_string($transportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportNumber, true), gettype($transportNumber)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($transportNumber) && mb_strlen($transportNumber) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($transportNumber)), __LINE__);
        }
        $this->TransportNumber = $transportNumber;
        return $this;
    }
    /**
     * Get Eta value
     * @return string|null
     */
    public function getEta()
    {
        return $this->Eta;
    }
    /**
     * Set Eta value
     * @param string $eta
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setEta($eta = null)
    {
        // validation for constraint: string
        if (!is_null($eta) && !is_string($eta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eta, true), gettype($eta)), __LINE__);
        }
        $this->Eta = $eta;
        return $this;
    }
    /**
     * Get Etd value
     * @return string|null
     */
    public function getEtd()
    {
        return $this->Etd;
    }
    /**
     * Set Etd value
     * @param string $etd
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setEtd($etd = null)
    {
        // validation for constraint: string
        if (!is_null($etd) && !is_string($etd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($etd, true), gettype($etd)), __LINE__);
        }
        $this->Etd = $etd;
        return $this;
    }
    /**
     * Get CustomsOfficeCode value
     * @return string|null
     */
    public function getCustomsOfficeCode()
    {
        return $this->CustomsOfficeCode;
    }
    /**
     * Set CustomsOfficeCode value
     * @param string $customsOfficeCode
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setCustomsOfficeCode($customsOfficeCode = null)
    {
        // validation for constraint: string
        if (!is_null($customsOfficeCode) && !is_string($customsOfficeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsOfficeCode, true), gettype($customsOfficeCode)), __LINE__);
        }
        $this->CustomsOfficeCode = $customsOfficeCode;
        return $this;
    }
    /**
     * Get WarehouseName value
     * @return string|null
     */
    public function getWarehouseName()
    {
        return $this->WarehouseName;
    }
    /**
     * Set WarehouseName value
     * @param string $warehouseName
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setWarehouseName($warehouseName = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseName) && !is_string($warehouseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseName, true), gettype($warehouseName)), __LINE__);
        }
        $this->WarehouseName = $warehouseName;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \LectorSOAP\StructType\TradingPartner|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \LectorSOAP\StructType\TradingPartner $carrier
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setCarrier(\LectorSOAP\StructType\TradingPartner $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get Agent value
     * @return \LectorSOAP\StructType\TradingPartner|null
     */
    public function getAgent()
    {
        return $this->Agent;
    }
    /**
     * Set Agent value
     * @param \LectorSOAP\StructType\TradingPartner $agent
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setAgent(\LectorSOAP\StructType\TradingPartner $agent = null)
    {
        $this->Agent = $agent;
        return $this;
    }
    /**
     * Get Declarant value
     * @return \LectorSOAP\StructType\TradingPartner|null
     */
    public function getDeclarant()
    {
        return $this->Declarant;
    }
    /**
     * Set Declarant value
     * @param \LectorSOAP\StructType\TradingPartner $declarant
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setDeclarant(\LectorSOAP\StructType\TradingPartner $declarant = null)
    {
        $this->Declarant = $declarant;
        return $this;
    }
    /**
     * Get FreightAmountEu value
     * @return float|null
     */
    public function getFreightAmountEu()
    {
        return $this->FreightAmountEu;
    }
    /**
     * Set FreightAmountEu value
     * @param float $freightAmountEu
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setFreightAmountEu($freightAmountEu = null)
    {
        // validation for constraint: float
        if (!is_null($freightAmountEu) && !(is_float($freightAmountEu) || is_numeric($freightAmountEu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freightAmountEu, true), gettype($freightAmountEu)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($freightAmountEu) && $freightAmountEu < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($freightAmountEu, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($freightAmountEu) && !preg_match('/[0-9]*[.]?[0-9]+/', $freightAmountEu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($freightAmountEu, true)), __LINE__);
        }
        $this->FreightAmountEu = $freightAmountEu;
        return $this;
    }
    /**
     * Get FreightAmountNonEu value
     * @return float|null
     */
    public function getFreightAmountNonEu()
    {
        return $this->FreightAmountNonEu;
    }
    /**
     * Set FreightAmountNonEu value
     * @param float $freightAmountNonEu
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setFreightAmountNonEu($freightAmountNonEu = null)
    {
        // validation for constraint: float
        if (!is_null($freightAmountNonEu) && !(is_float($freightAmountNonEu) || is_numeric($freightAmountNonEu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freightAmountNonEu, true), gettype($freightAmountNonEu)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($freightAmountNonEu) && $freightAmountNonEu < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($freightAmountNonEu, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($freightAmountNonEu) && !preg_match('/[0-9]*[.]?[0-9]+/', $freightAmountNonEu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($freightAmountNonEu, true)), __LINE__);
        }
        $this->FreightAmountNonEu = $freightAmountNonEu;
        return $this;
    }
    /**
     * Get FreightCurrency value
     * @return string|null
     */
    public function getFreightCurrency()
    {
        return $this->FreightCurrency;
    }
    /**
     * Set FreightCurrency value
     * @param string $freightCurrency
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setFreightCurrency($freightCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($freightCurrency) && !is_string($freightCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freightCurrency, true), gettype($freightCurrency)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{3})
        if (!is_null($freightCurrency) && !preg_match('/[A-Z]{3}/', $freightCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{3}', var_export($freightCurrency, true)), __LINE__);
        }
        $this->FreightCurrency = $freightCurrency;
        return $this;
    }
    /**
     * Get InvoiceAmount value
     * @return float|null
     */
    public function getInvoiceAmount()
    {
        return $this->InvoiceAmount;
    }
    /**
     * Set InvoiceAmount value
     * @param float $invoiceAmount
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setInvoiceAmount($invoiceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($invoiceAmount) && !(is_float($invoiceAmount) || is_numeric($invoiceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoiceAmount, true), gettype($invoiceAmount)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($invoiceAmount) && $invoiceAmount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($invoiceAmount, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($invoiceAmount) && !preg_match('/[0-9]*[.]?[0-9]+/', $invoiceAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($invoiceAmount, true)), __LINE__);
        }
        $this->InvoiceAmount = $invoiceAmount;
        return $this;
    }
    /**
     * Get InvoiceCurrency value
     * @return string|null
     */
    public function getInvoiceCurrency()
    {
        return $this->InvoiceCurrency;
    }
    /**
     * Set InvoiceCurrency value
     * @param string $invoiceCurrency
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setInvoiceCurrency($invoiceCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCurrency) && !is_string($invoiceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCurrency, true), gettype($invoiceCurrency)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{3})
        if (!is_null($invoiceCurrency) && !preg_match('/[A-Z]{3}/', $invoiceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{3}', var_export($invoiceCurrency, true)), __LINE__);
        }
        $this->InvoiceCurrency = $invoiceCurrency;
        return $this;
    }
    /**
     * Get LicenseNumber value
     * @return string|null
     */
    public function getLicenseNumber()
    {
        return $this->LicenseNumber;
    }
    /**
     * Set LicenseNumber value
     * @param string $licenseNumber
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setLicenseNumber($licenseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($licenseNumber) && !is_string($licenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseNumber, true), gettype($licenseNumber)), __LINE__);
        }
        $this->LicenseNumber = $licenseNumber;
        return $this;
    }
    /**
     * Get CustomsCountry value
     * @return string|null
     */
    public function getCustomsCountry()
    {
        return $this->CustomsCountry;
    }
    /**
     * Set CustomsCountry value
     * @param string $customsCountry
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setCustomsCountry($customsCountry = null)
    {
        // validation for constraint: string
        if (!is_null($customsCountry) && !is_string($customsCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsCountry, true), gettype($customsCountry)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,3})
        if (!is_null($customsCountry) && !preg_match('/[A-Z]{2,3}/', $customsCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,3}', var_export($customsCountry, true)), __LINE__);
        }
        $this->CustomsCountry = $customsCountry;
        return $this;
    }
    /**
     * Get IgnoreAutoReservation value
     * @return string|null
     */
    public function getIgnoreAutoReservation()
    {
        return $this->IgnoreAutoReservation;
    }
    /**
     * Set IgnoreAutoReservation value
     * @param string $ignoreAutoReservation
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setIgnoreAutoReservation($ignoreAutoReservation = null)
    {
        // validation for constraint: string
        if (!is_null($ignoreAutoReservation) && !is_string($ignoreAutoReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ignoreAutoReservation, true), gettype($ignoreAutoReservation)), __LINE__);
        }
        $this->IgnoreAutoReservation = $ignoreAutoReservation;
        return $this;
    }
    /**
     * Get Consignee value
     * @return \LectorSOAP\StructType\TradingPartner|null
     */
    public function getConsignee()
    {
        return $this->Consignee;
    }
    /**
     * Set Consignee value
     * @param \LectorSOAP\StructType\TradingPartner $consignee
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setConsignee(\LectorSOAP\StructType\TradingPartner $consignee = null)
    {
        $this->Consignee = $consignee;
        return $this;
    }
    /**
     * Get Supplier value
     * @return \LectorSOAP\StructType\TradingPartner|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \LectorSOAP\StructType\TradingPartner $supplier
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setSupplier(\LectorSOAP\StructType\TradingPartner $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get InboundCargo value
     * @return \LectorSOAP\StructType\InboundCargo[]|null
     */
    public function getInboundCargo()
    {
        return $this->InboundCargo;
    }
    /**
     * This method is responsible for validating the values passed to the setInboundCargo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInboundCargo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInboundCargoForArrayConstraintsFromSetInboundCargo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundInboundCargoItem) {
            // validation for constraint: itemType
            if (!$inboundInboundCargoItem instanceof \LectorSOAP\StructType\InboundCargo) {
                $invalidValues[] = is_object($inboundInboundCargoItem) ? get_class($inboundInboundCargoItem) : sprintf('%s(%s)', gettype($inboundInboundCargoItem), var_export($inboundInboundCargoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InboundCargo property can only contain items of type \LectorSOAP\StructType\InboundCargo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InboundCargo value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\InboundCargo[] $inboundCargo
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setInboundCargo(array $inboundCargo = array())
    {
        // validation for constraint: array
        if ('' !== ($inboundCargoArrayErrorMessage = self::validateInboundCargoForArrayConstraintsFromSetInboundCargo($inboundCargo))) {
            throw new \InvalidArgumentException($inboundCargoArrayErrorMessage, __LINE__);
        }
        $this->InboundCargo = $inboundCargo;
        return $this;
    }
    /**
     * Add item to InboundCargo value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\InboundCargo $item
     * @return \LectorSOAP\StructType\Inbound
     */
    public function addToInboundCargo(\LectorSOAP\StructType\InboundCargo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LectorSOAP\StructType\InboundCargo) {
            throw new \InvalidArgumentException(sprintf('The InboundCargo property can only contain items of type \LectorSOAP\StructType\InboundCargo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InboundCargo[] = $item;
        return $this;
    }
    /**
     * Get InboundDocuments value
     * @return \LectorSOAP\StructType\InboundDocuments|null
     */
    public function getInboundDocuments()
    {
        return $this->InboundDocuments;
    }
    /**
     * Set InboundDocuments value
     * @param \LectorSOAP\StructType\InboundDocuments $inboundDocuments
     * @return \LectorSOAP\StructType\Inbound
     */
    public function setInboundDocuments(\LectorSOAP\StructType\InboundDocuments $inboundDocuments = null)
    {
        $this->InboundDocuments = $inboundDocuments;
        return $this;
    }
}
