<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCustomsValue StructType
 * @subpackage Structs
 */
class AdditionalCustomsValue extends AbstractStructBase
{
    /**
     * The CustomsValueType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $CustomsValueType;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $Value;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $Currency;
    /**
     * The InvoiceDependent
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - default: N
     * - minOccurs: 0
     * - pattern: [YN]
     * @var string
     */
    public $InvoiceDependent;
    /**
     * Constructor method for AdditionalCustomsValue
     * @uses AdditionalCustomsValue::setCustomsValueType()
     * @uses AdditionalCustomsValue::setValue()
     * @uses AdditionalCustomsValue::setCurrency()
     * @uses AdditionalCustomsValue::setInvoiceDependent()
     * @param string $customsValueType
     * @param float $value
     * @param string $currency
     * @param string $invoiceDependent
     */
    public function __construct($customsValueType = null, $value = null, $currency = null, $invoiceDependent = 'N')
    {
        $this
            ->setCustomsValueType($customsValueType)
            ->setValue($value)
            ->setCurrency($currency)
            ->setInvoiceDependent($invoiceDependent);
    }
    /**
     * Get CustomsValueType value
     * @return string|null
     */
    public function getCustomsValueType()
    {
        return $this->CustomsValueType;
    }
    /**
     * Set CustomsValueType value
     * @param string $customsValueType
     * @return \LectorSOAP\StructType\AdditionalCustomsValue
     */
    public function setCustomsValueType($customsValueType = null)
    {
        // validation for constraint: string
        if (!is_null($customsValueType) && !is_string($customsValueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsValueType, true), gettype($customsValueType)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($customsValueType) && mb_strlen($customsValueType) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($customsValueType)), __LINE__);
        }
        $this->CustomsValueType = $customsValueType;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \LectorSOAP\StructType\AdditionalCustomsValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($value) && $value < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($value, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($value) && !preg_match('/[0-9]*[.]?[0-9]+/', $value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($value, true)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \LectorSOAP\StructType\AdditionalCustomsValue
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{3})
        if (!is_null($currency) && !preg_match('/[A-Z]{3}/', $currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{3}', var_export($currency, true)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get InvoiceDependent value
     * @return string|null
     */
    public function getInvoiceDependent()
    {
        return $this->InvoiceDependent;
    }
    /**
     * Set InvoiceDependent value
     * @param string $invoiceDependent
     * @return \LectorSOAP\StructType\AdditionalCustomsValue
     */
    public function setInvoiceDependent($invoiceDependent = 'N')
    {
        // validation for constraint: string
        if (!is_null($invoiceDependent) && !is_string($invoiceDependent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDependent, true), gettype($invoiceDependent)), __LINE__);
        }
        // validation for constraint: pattern([YN])
        if (!is_null($invoiceDependent) && !preg_match('/[YN]/', $invoiceDependent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [YN]', var_export($invoiceDependent, true)), __LINE__);
        }
        $this->InvoiceDependent = $invoiceDependent;
        return $this;
    }
}
