<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Variant StructType
 * @subpackage Structs
 */
class Variant extends AbstractStructBase
{
    /**
     * The VariantId
     * Meta information extracted from the WSDL
     * - documentation: The variant identifier from the originating system. It is only stored for traceability and debugging purposes.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $VariantId;
    /**
     * The VariantSKU
     * Meta information extracted from the WSDL
     * - documentation: The variant Stock Keeping Unit from the originating WMS. It is important to note that the LTS system uses this value in all accounting. It is therefore imperative that this value should not be altered under a product life cycle. This
     * key should be unique for an item/variant. We suggest using the item barcode, if possible – but any string less than 25 characters is fine, as long as it uniquely and consistently identifies the item.
     * - base: xs:string
     * - maxLength: 25
     * @var string
     */
    public $VariantSKU;
    /**
     * The VariantQty
     * Meta information extracted from the WSDL
     * - documentation: The variant quantity for the selected product. This is used as base for calculating the value for Box 41 (Supp.Units).
     * - base: xs:decimal
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $VariantQty;
    /**
     * The VariantSize
     * Meta information extracted from the WSDL
     * - documentation: The variant size.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $VariantSize;
    /**
     * The VariantColor
     * Meta information extracted from the WSDL
     * - documentation: The color of the product variant.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $VariantColor;
    /**
     * The VariantHeight
     * Meta information extracted from the WSDL
     * - documentation: The height of the product variant.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $VariantHeight;
    /**
     * The VariantLength
     * Meta information extracted from the WSDL
     * - documentation: The length of the product variant.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $VariantLength;
    /**
     * The VariantWidth
     * Meta information extracted from the WSDL
     * - documentation: The width of the product variant.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $VariantWidth;
    /**
     * The VariantGrossMass
     * Meta information extracted from the WSDL
     * - documentation: The gross mass of the product variant. The LTS system handles a value of up to six decimals. Please note that local customs handle three decimals at the present time. IMPORTANT: This is always the unit gross weight except when
     * importing from a spreadsheet where it is possible to specify unit or line weight.
     * - base: xs:decimal
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $VariantGrossMass;
    /**
     * The VariantNetMass
     * Meta information extracted from the WSDL
     * - documentation: The net mass of the product variant. The LTS system handles a value of up to six decimals. Please note that local customs cannot handle a value lower that 1 at the present time. IMPORTANT: This is always the unit net weight except
     * when importing from a spreadsheet where it is possible to specify unit or line weight.
     * - base: xs:decimal
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $VariantNetMass;
    /**
     * The VariantCommodityCode
     * Meta information extracted from the WSDL
     * - documentation: Eight or ten-digit commodity codes are used in import(10) and export(8) declarations. The commodity code determines the customs duties and other charges levied on goods, the preferential treatments that may apply to their import, and
     * the restrictions and prohibitions that may apply to the import, export or transit of goods.
     * - base: xs:string
     * - maxLength: 20
     * @var string
     */
    public $VariantCommodityCode;
    /**
     * The VariantNonEuCommodityCode
     * Meta information extracted from the WSDL
     * - documentation: This is the commodity code used in non EU countries and is mostly used in the Outbound data set. This value is used in the LTS TURN function when converting a local export declaration to an import declaration in the country of
     * destination. LTS provides functionality for the creation of Taric Mapping between countries should this value be unavailable in the originating system.
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $VariantNonEuCommodityCode;
    /**
     * The SupplementUnitFactor
     * Meta information extracted from the WSDL
     * - documentation: Box 41 on the SAD document. The default value is 1. This field is to be completed when the HS code requires the item to be classified in some other unit of measurement such as liters,etc. The value is multiplied by the number of
     * units/pieces to give the total number of units.
     * - base: xs:decimal
     * - default: 1
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $SupplementUnitFactor;
    /**
     * The CountryOfOrigin
     * Meta information extracted from the WSDL
     * - documentation: This is mandatory for all Outbound transactions. This required for Inbound transactions where no country of origin is noted on the purchase order.This should be a valid ISO2 code and is used in Box 34 of the SAD document.
     * - base: xs:string
     * - pattern: [A-Z]{2,3}
     * @var string
     */
    public $CountryOfOrigin;
    /**
     * The SplitKey
     * Meta information extracted from the WSDL
     * - documentation: This is a custom key to force a single product split across two import records on a customs import declaration. The system normally creates one record per product.
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $SplitKey;
    /**
     * The ExportOptions
     * Meta information extracted from the WSDL
     * - documentation: This Element for Outbound files only. This element allows the file source to take control of the LTS settlement process. This facilitates the physical picking of stock from a warehouse location with a designated T-status or customs
     * procedure whilst ensuring that the LTS system makes the same choice under the countdown or settlement process. The element content is dependent on the Customs Permits registered in the LTS Permits module. For customers with a Bonded Warehouse permit
     * a simple T1 or T2 value may suffice. For customers with multiple permits or accounts a specific customs procedure code is required. The element may be used in conjunction with the optional IgnoreExportOptions element. This element tells LTS how to
     * react if the settlement process cannot match the designated procedure code or T-status in the LTS stock item accounts. If the element is present and the value is 'Y' then the settlement will continue regardless of a T-status mismatch. The resulting
     * mismatch will be marked as NOT FOUND and will automatically be allocated a T2-status. If the IgnoreExportOptions element is present and the value is 'N' or the element has been omitted then the settlement process will stop and the shipment is marked
     * with a data error status-icon. This status requires user interaction for the settlements process to continue. When sending a procedure code a minimum af two numbers is required. These numbers denote the procedure as registered in LTS accounts.
     * Sending a complete procedure code will look for an exact match in accounts. IMPORTANT! If the EXPORT OPTIONS element is not present LTS will automatically take control of the settlement process.
     * - minOccurs: 0
     * @var string
     */
    public $ExportOptions;
    /**
     * Constructor method for Variant
     * @uses Variant::setVariantId()
     * @uses Variant::setVariantSKU()
     * @uses Variant::setVariantQty()
     * @uses Variant::setVariantSize()
     * @uses Variant::setVariantColor()
     * @uses Variant::setVariantHeight()
     * @uses Variant::setVariantLength()
     * @uses Variant::setVariantWidth()
     * @uses Variant::setVariantGrossMass()
     * @uses Variant::setVariantNetMass()
     * @uses Variant::setVariantCommodityCode()
     * @uses Variant::setVariantNonEuCommodityCode()
     * @uses Variant::setSupplementUnitFactor()
     * @uses Variant::setCountryOfOrigin()
     * @uses Variant::setSplitKey()
     * @uses Variant::setExportOptions()
     * @param string $variantId
     * @param string $variantSKU
     * @param float $variantQty
     * @param string $variantSize
     * @param string $variantColor
     * @param string $variantHeight
     * @param string $variantLength
     * @param string $variantWidth
     * @param float $variantGrossMass
     * @param float $variantNetMass
     * @param string $variantCommodityCode
     * @param string $variantNonEuCommodityCode
     * @param float $supplementUnitFactor
     * @param string $countryOfOrigin
     * @param string $splitKey
     * @param string $exportOptions
     */
    public function __construct($variantId = null, $variantSKU = null, $variantQty = null, $variantSize = null, $variantColor = null, $variantHeight = null, $variantLength = null, $variantWidth = null, $variantGrossMass = null, $variantNetMass = null, $variantCommodityCode = null, $variantNonEuCommodityCode = null, $supplementUnitFactor = 1, $countryOfOrigin = null, $splitKey = null, $exportOptions = null)
    {
        $this
            ->setVariantId($variantId)
            ->setVariantSKU($variantSKU)
            ->setVariantQty($variantQty)
            ->setVariantSize($variantSize)
            ->setVariantColor($variantColor)
            ->setVariantHeight($variantHeight)
            ->setVariantLength($variantLength)
            ->setVariantWidth($variantWidth)
            ->setVariantGrossMass($variantGrossMass)
            ->setVariantNetMass($variantNetMass)
            ->setVariantCommodityCode($variantCommodityCode)
            ->setVariantNonEuCommodityCode($variantNonEuCommodityCode)
            ->setSupplementUnitFactor($supplementUnitFactor)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setSplitKey($splitKey)
            ->setExportOptions($exportOptions);
    }
    /**
     * Get VariantId value
     * @return string|null
     */
    public function getVariantId()
    {
        return $this->VariantId;
    }
    /**
     * Set VariantId value
     * @param string $variantId
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantId($variantId = null)
    {
        // validation for constraint: string
        if (!is_null($variantId) && !is_string($variantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantId, true), gettype($variantId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($variantId) && mb_strlen($variantId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($variantId)), __LINE__);
        }
        $this->VariantId = $variantId;
        return $this;
    }
    /**
     * Get VariantSKU value
     * @return string|null
     */
    public function getVariantSKU()
    {
        return $this->VariantSKU;
    }
    /**
     * Set VariantSKU value
     * @param string $variantSKU
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantSKU($variantSKU = null)
    {
        // validation for constraint: string
        if (!is_null($variantSKU) && !is_string($variantSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantSKU, true), gettype($variantSKU)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($variantSKU) && mb_strlen($variantSKU) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($variantSKU)), __LINE__);
        }
        $this->VariantSKU = $variantSKU;
        return $this;
    }
    /**
     * Get VariantQty value
     * @return float|null
     */
    public function getVariantQty()
    {
        return $this->VariantQty;
    }
    /**
     * Set VariantQty value
     * @param float $variantQty
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantQty($variantQty = null)
    {
        // validation for constraint: float
        if (!is_null($variantQty) && !(is_float($variantQty) || is_numeric($variantQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variantQty, true), gettype($variantQty)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($variantQty) && $variantQty < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($variantQty, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($variantQty) && !preg_match('/[0-9]*[.]?[0-9]+/', $variantQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($variantQty, true)), __LINE__);
        }
        $this->VariantQty = $variantQty;
        return $this;
    }
    /**
     * Get VariantSize value
     * @return string|null
     */
    public function getVariantSize()
    {
        return $this->VariantSize;
    }
    /**
     * Set VariantSize value
     * @param string $variantSize
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantSize($variantSize = null)
    {
        // validation for constraint: string
        if (!is_null($variantSize) && !is_string($variantSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantSize, true), gettype($variantSize)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($variantSize) && mb_strlen($variantSize) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($variantSize)), __LINE__);
        }
        $this->VariantSize = $variantSize;
        return $this;
    }
    /**
     * Get VariantColor value
     * @return string|null
     */
    public function getVariantColor()
    {
        return $this->VariantColor;
    }
    /**
     * Set VariantColor value
     * @param string $variantColor
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantColor($variantColor = null)
    {
        // validation for constraint: string
        if (!is_null($variantColor) && !is_string($variantColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantColor, true), gettype($variantColor)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($variantColor) && mb_strlen($variantColor) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($variantColor)), __LINE__);
        }
        $this->VariantColor = $variantColor;
        return $this;
    }
    /**
     * Get VariantHeight value
     * @return string|null
     */
    public function getVariantHeight()
    {
        return $this->VariantHeight;
    }
    /**
     * Set VariantHeight value
     * @param string $variantHeight
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantHeight($variantHeight = null)
    {
        // validation for constraint: string
        if (!is_null($variantHeight) && !is_string($variantHeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantHeight, true), gettype($variantHeight)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($variantHeight) && mb_strlen($variantHeight) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($variantHeight)), __LINE__);
        }
        $this->VariantHeight = $variantHeight;
        return $this;
    }
    /**
     * Get VariantLength value
     * @return string|null
     */
    public function getVariantLength()
    {
        return $this->VariantLength;
    }
    /**
     * Set VariantLength value
     * @param string $variantLength
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantLength($variantLength = null)
    {
        // validation for constraint: string
        if (!is_null($variantLength) && !is_string($variantLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantLength, true), gettype($variantLength)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($variantLength) && mb_strlen($variantLength) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($variantLength)), __LINE__);
        }
        $this->VariantLength = $variantLength;
        return $this;
    }
    /**
     * Get VariantWidth value
     * @return string|null
     */
    public function getVariantWidth()
    {
        return $this->VariantWidth;
    }
    /**
     * Set VariantWidth value
     * @param string $variantWidth
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantWidth($variantWidth = null)
    {
        // validation for constraint: string
        if (!is_null($variantWidth) && !is_string($variantWidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantWidth, true), gettype($variantWidth)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($variantWidth) && mb_strlen($variantWidth) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($variantWidth)), __LINE__);
        }
        $this->VariantWidth = $variantWidth;
        return $this;
    }
    /**
     * Get VariantGrossMass value
     * @return float|null
     */
    public function getVariantGrossMass()
    {
        return $this->VariantGrossMass;
    }
    /**
     * Set VariantGrossMass value
     * @param float $variantGrossMass
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantGrossMass($variantGrossMass = null)
    {
        // validation for constraint: float
        if (!is_null($variantGrossMass) && !(is_float($variantGrossMass) || is_numeric($variantGrossMass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variantGrossMass, true), gettype($variantGrossMass)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($variantGrossMass) && $variantGrossMass < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($variantGrossMass, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($variantGrossMass) && !preg_match('/[0-9]*[.]?[0-9]+/', $variantGrossMass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($variantGrossMass, true)), __LINE__);
        }
        $this->VariantGrossMass = $variantGrossMass;
        return $this;
    }
    /**
     * Get VariantNetMass value
     * @return float|null
     */
    public function getVariantNetMass()
    {
        return $this->VariantNetMass;
    }
    /**
     * Set VariantNetMass value
     * @param float $variantNetMass
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantNetMass($variantNetMass = null)
    {
        // validation for constraint: float
        if (!is_null($variantNetMass) && !(is_float($variantNetMass) || is_numeric($variantNetMass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variantNetMass, true), gettype($variantNetMass)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($variantNetMass) && $variantNetMass < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($variantNetMass, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($variantNetMass) && !preg_match('/[0-9]*[.]?[0-9]+/', $variantNetMass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($variantNetMass, true)), __LINE__);
        }
        $this->VariantNetMass = $variantNetMass;
        return $this;
    }
    /**
     * Get VariantCommodityCode value
     * @return string|null
     */
    public function getVariantCommodityCode()
    {
        return $this->VariantCommodityCode;
    }
    /**
     * Set VariantCommodityCode value
     * @param string $variantCommodityCode
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantCommodityCode($variantCommodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($variantCommodityCode) && !is_string($variantCommodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantCommodityCode, true), gettype($variantCommodityCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($variantCommodityCode) && mb_strlen($variantCommodityCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($variantCommodityCode)), __LINE__);
        }
        $this->VariantCommodityCode = $variantCommodityCode;
        return $this;
    }
    /**
     * Get VariantNonEuCommodityCode value
     * @return string|null
     */
    public function getVariantNonEuCommodityCode()
    {
        return $this->VariantNonEuCommodityCode;
    }
    /**
     * Set VariantNonEuCommodityCode value
     * @param string $variantNonEuCommodityCode
     * @return \LectorSOAP\StructType\Variant
     */
    public function setVariantNonEuCommodityCode($variantNonEuCommodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($variantNonEuCommodityCode) && !is_string($variantNonEuCommodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantNonEuCommodityCode, true), gettype($variantNonEuCommodityCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($variantNonEuCommodityCode) && mb_strlen($variantNonEuCommodityCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($variantNonEuCommodityCode)), __LINE__);
        }
        $this->VariantNonEuCommodityCode = $variantNonEuCommodityCode;
        return $this;
    }
    /**
     * Get SupplementUnitFactor value
     * @return float|null
     */
    public function getSupplementUnitFactor()
    {
        return $this->SupplementUnitFactor;
    }
    /**
     * Set SupplementUnitFactor value
     * @param float $supplementUnitFactor
     * @return \LectorSOAP\StructType\Variant
     */
    public function setSupplementUnitFactor($supplementUnitFactor = 1)
    {
        // validation for constraint: float
        if (!is_null($supplementUnitFactor) && !(is_float($supplementUnitFactor) || is_numeric($supplementUnitFactor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($supplementUnitFactor, true), gettype($supplementUnitFactor)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($supplementUnitFactor) && $supplementUnitFactor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($supplementUnitFactor, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($supplementUnitFactor) && !preg_match('/[0-9]*[.]?[0-9]+/', $supplementUnitFactor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($supplementUnitFactor, true)), __LINE__);
        }
        $this->SupplementUnitFactor = $supplementUnitFactor;
        return $this;
    }
    /**
     * Get CountryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->CountryOfOrigin;
    }
    /**
     * Set CountryOfOrigin value
     * @param string $countryOfOrigin
     * @return \LectorSOAP\StructType\Variant
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfOrigin, true), gettype($countryOfOrigin)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,3})
        if (!is_null($countryOfOrigin) && !preg_match('/[A-Z]{2,3}/', $countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,3}', var_export($countryOfOrigin, true)), __LINE__);
        }
        $this->CountryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get SplitKey value
     * @return string|null
     */
    public function getSplitKey()
    {
        return $this->SplitKey;
    }
    /**
     * Set SplitKey value
     * @param string $splitKey
     * @return \LectorSOAP\StructType\Variant
     */
    public function setSplitKey($splitKey = null)
    {
        // validation for constraint: string
        if (!is_null($splitKey) && !is_string($splitKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($splitKey, true), gettype($splitKey)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($splitKey) && mb_strlen($splitKey) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($splitKey)), __LINE__);
        }
        $this->SplitKey = $splitKey;
        return $this;
    }
    /**
     * Get ExportOptions value
     * @return string|null
     */
    public function getExportOptions()
    {
        return $this->ExportOptions;
    }
    /**
     * Set ExportOptions value
     * @param string $exportOptions
     * @return \LectorSOAP\StructType\Variant
     */
    public function setExportOptions($exportOptions = null)
    {
        // validation for constraint: string
        if (!is_null($exportOptions) && !is_string($exportOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportOptions, true), gettype($exportOptions)), __LINE__);
        }
        $this->ExportOptions = $exportOptions;
        return $this;
    }
}
