<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrders StructType
 * @subpackage Structs
 */
class PurchaseOrders extends AbstractStructBase
{
    /**
     * The PurchaseOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \LectorSOAP\StructType\PurchaseOrder[]
     */
    public $PurchaseOrder;
    /**
     * Constructor method for PurchaseOrders
     * @uses PurchaseOrders::setPurchaseOrder()
     * @param \LectorSOAP\StructType\PurchaseOrder[] $purchaseOrder
     */
    public function __construct(array $purchaseOrder = array())
    {
        $this
            ->setPurchaseOrder($purchaseOrder);
    }
    /**
     * Get PurchaseOrder value
     * @return \LectorSOAP\StructType\PurchaseOrder[]|null
     */
    public function getPurchaseOrder()
    {
        return $this->PurchaseOrder;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseOrderForArrayConstraintsFromSetPurchaseOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchaseOrdersPurchaseOrderItem) {
            // validation for constraint: itemType
            if (!$purchaseOrdersPurchaseOrderItem instanceof \LectorSOAP\StructType\PurchaseOrder) {
                $invalidValues[] = is_object($purchaseOrdersPurchaseOrderItem) ? get_class($purchaseOrdersPurchaseOrderItem) : sprintf('%s(%s)', gettype($purchaseOrdersPurchaseOrderItem), var_export($purchaseOrdersPurchaseOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchaseOrder property can only contain items of type \LectorSOAP\StructType\PurchaseOrder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchaseOrder value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\PurchaseOrder[] $purchaseOrder
     * @return \LectorSOAP\StructType\PurchaseOrders
     */
    public function setPurchaseOrder(array $purchaseOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseOrderArrayErrorMessage = self::validatePurchaseOrderForArrayConstraintsFromSetPurchaseOrder($purchaseOrder))) {
            throw new \InvalidArgumentException($purchaseOrderArrayErrorMessage, __LINE__);
        }
        $this->PurchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Add item to PurchaseOrder value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\PurchaseOrder $item
     * @return \LectorSOAP\StructType\PurchaseOrders
     */
    public function addToPurchaseOrder(\LectorSOAP\StructType\PurchaseOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LectorSOAP\StructType\PurchaseOrder) {
            throw new \InvalidArgumentException(sprintf('The PurchaseOrder property can only contain items of type \LectorSOAP\StructType\PurchaseOrder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchaseOrder[] = $item;
        return $this;
    }
}
