<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrder StructType
 * Meta information extracted from the WSDL
 * - documentation: This tag should contain any documents that are specific for the specific purchase order. Document examples could be duty relief documents or a Certificate Of Origin. The SupplierDocuments-tag should be thought of as a list,
 * containing one to many SupplierDocumenttags (which should comply with the Documents data type). Duty relief documents from this tag are automatically added to SAD box 44.4 of the import declaration. | Contains a list of all the packages in this
 * purchase order. The package-tag is described subsequently. | Valid delivery terms are “EXW”, “FCA”, “CPT”, “CIP”, “DAT”, “DAP”, “DDP”, “FAS”, “FOB”, “CFR” or “CIF”.
 * @subpackage Structs
 */
class PurchaseOrder extends AbstractStructBase
{
    /**
     * The PurchaseOrderId
     * Meta information extracted from the WSDL
     * - documentation: The purchase order identifier in the originating system.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $PurchaseOrderId;
    /**
     * The PurchaseOrderNumber
     * Meta information extracted from the WSDL
     * - documentation: This is the purchase order or transaction number. This number is used both as a search parameter and also a column in the table view on the Inbound Overview page.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $PurchaseOrderNumber;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - documentation: Please use the ‘CountryOfOrigin’ field in variants. A valid international code (ISO2) for denoting the country of origin for the supplied goods. This value is used as the initial value in SAD box 34.
     * - base: xs:string
     * - pattern: [A-Z]{2,3}
     * @var string
     */
    public $Origin;
    /**
     * The CountryOfExport
     * Meta information extracted from the WSDL
     * - documentation: The country exporting the goods as apposed to the country producing the goods. The value is used in SAD Box 15 and defaults to the supplier country if not present.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [A-Z]{2,3}
     * @var string
     */
    public $CountryOfExport;
    /**
     * The PlaceOfExport
     * Meta information extracted from the WSDL
     * - documentation: The town/city of export.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $PlaceOfExport;
    /**
     * The PackingReference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an inbound packing note. This may only be relevant for sending import-declarations to customs authorities other than DK
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $PackingReference;
    /**
     * The PurchaseCurrency
     * Meta information extracted from the WSDL
     * - documentation: The currency of the purchase order.
     * - base: xs:string
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $PurchaseCurrency;
    /**
     * The DeliveryTerm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: com:DeliveryTerm
     * @var string
     */
    public $DeliveryTerm;
    /**
     * The Packaging
     * Meta information extracted from the WSDL
     * - ref: tns:Packaging
     * @var \LectorSOAP\StructType\Packaging
     */
    public $Packaging;
    /**
     * The SupplierDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:SupplierDocuments
     * @var \LectorSOAP\StructType\SupplierDocuments
     */
    public $SupplierDocuments;
    /**
     * The PurchaseOrderAttribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderAttribute;
    /**
     * The PurchaseOrderCreatedDate
     * Meta information extracted from the WSDL
     * - documentation: The date the purchase order was created in the originating system.
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderCreatedDate;
    /**
     * The PreferenceSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:PreferenceSummary
     * @var \LectorSOAP\StructType\PreferenceSummary
     */
    public $PreferenceSummary;
    /**
     * Constructor method for PurchaseOrder
     * @uses PurchaseOrder::setPurchaseOrderId()
     * @uses PurchaseOrder::setPurchaseOrderNumber()
     * @uses PurchaseOrder::setOrigin()
     * @uses PurchaseOrder::setCountryOfExport()
     * @uses PurchaseOrder::setPlaceOfExport()
     * @uses PurchaseOrder::setPackingReference()
     * @uses PurchaseOrder::setPurchaseCurrency()
     * @uses PurchaseOrder::setDeliveryTerm()
     * @uses PurchaseOrder::setPackaging()
     * @uses PurchaseOrder::setSupplierDocuments()
     * @uses PurchaseOrder::setPurchaseOrderAttribute()
     * @uses PurchaseOrder::setPurchaseOrderCreatedDate()
     * @uses PurchaseOrder::setPreferenceSummary()
     * @param string $purchaseOrderId
     * @param string $purchaseOrderNumber
     * @param string $origin
     * @param string $countryOfExport
     * @param string $placeOfExport
     * @param string $packingReference
     * @param string $purchaseCurrency
     * @param string $deliveryTerm
     * @param \LectorSOAP\StructType\Packaging $packaging
     * @param \LectorSOAP\StructType\SupplierDocuments $supplierDocuments
     * @param string $purchaseOrderAttribute
     * @param string $purchaseOrderCreatedDate
     * @param \LectorSOAP\StructType\PreferenceSummary $preferenceSummary
     */
    public function __construct($purchaseOrderId = null, $purchaseOrderNumber = null, $origin = null, $countryOfExport = null, $placeOfExport = null, $packingReference = null, $purchaseCurrency = null, $deliveryTerm = null, \LectorSOAP\StructType\Packaging $packaging = null, \LectorSOAP\StructType\SupplierDocuments $supplierDocuments = null, $purchaseOrderAttribute = null, $purchaseOrderCreatedDate = null, \LectorSOAP\StructType\PreferenceSummary $preferenceSummary = null)
    {
        $this
            ->setPurchaseOrderId($purchaseOrderId)
            ->setPurchaseOrderNumber($purchaseOrderNumber)
            ->setOrigin($origin)
            ->setCountryOfExport($countryOfExport)
            ->setPlaceOfExport($placeOfExport)
            ->setPackingReference($packingReference)
            ->setPurchaseCurrency($purchaseCurrency)
            ->setDeliveryTerm($deliveryTerm)
            ->setPackaging($packaging)
            ->setSupplierDocuments($supplierDocuments)
            ->setPurchaseOrderAttribute($purchaseOrderAttribute)
            ->setPurchaseOrderCreatedDate($purchaseOrderCreatedDate)
            ->setPreferenceSummary($preferenceSummary);
    }
    /**
     * Get PurchaseOrderId value
     * @return string|null
     */
    public function getPurchaseOrderId()
    {
        return $this->PurchaseOrderId;
    }
    /**
     * Set PurchaseOrderId value
     * @param string $purchaseOrderId
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setPurchaseOrderId($purchaseOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderId) && !is_string($purchaseOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderId, true), gettype($purchaseOrderId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($purchaseOrderId) && mb_strlen($purchaseOrderId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($purchaseOrderId)), __LINE__);
        }
        $this->PurchaseOrderId = $purchaseOrderId;
        return $this;
    }
    /**
     * Get PurchaseOrderNumber value
     * @return string|null
     */
    public function getPurchaseOrderNumber()
    {
        return $this->PurchaseOrderNumber;
    }
    /**
     * Set PurchaseOrderNumber value
     * @param string $purchaseOrderNumber
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderNumber) && !is_string($purchaseOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderNumber, true), gettype($purchaseOrderNumber)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($purchaseOrderNumber) && mb_strlen($purchaseOrderNumber) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($purchaseOrderNumber)), __LINE__);
        }
        $this->PurchaseOrderNumber = $purchaseOrderNumber;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,3})
        if (!is_null($origin) && !preg_match('/[A-Z]{2,3}/', $origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,3}', var_export($origin, true)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get CountryOfExport value
     * @return string|null
     */
    public function getCountryOfExport()
    {
        return $this->CountryOfExport;
    }
    /**
     * Set CountryOfExport value
     * @param string $countryOfExport
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setCountryOfExport($countryOfExport = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfExport) && !is_string($countryOfExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfExport, true), gettype($countryOfExport)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,3})
        if (!is_null($countryOfExport) && !preg_match('/[A-Z]{2,3}/', $countryOfExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,3}', var_export($countryOfExport, true)), __LINE__);
        }
        $this->CountryOfExport = $countryOfExport;
        return $this;
    }
    /**
     * Get PlaceOfExport value
     * @return string|null
     */
    public function getPlaceOfExport()
    {
        return $this->PlaceOfExport;
    }
    /**
     * Set PlaceOfExport value
     * @param string $placeOfExport
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setPlaceOfExport($placeOfExport = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfExport) && !is_string($placeOfExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeOfExport, true), gettype($placeOfExport)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($placeOfExport) && mb_strlen($placeOfExport) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($placeOfExport)), __LINE__);
        }
        $this->PlaceOfExport = $placeOfExport;
        return $this;
    }
    /**
     * Get PackingReference value
     * @return string|null
     */
    public function getPackingReference()
    {
        return $this->PackingReference;
    }
    /**
     * Set PackingReference value
     * @param string $packingReference
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setPackingReference($packingReference = null)
    {
        // validation for constraint: string
        if (!is_null($packingReference) && !is_string($packingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packingReference, true), gettype($packingReference)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($packingReference) && mb_strlen($packingReference) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($packingReference)), __LINE__);
        }
        $this->PackingReference = $packingReference;
        return $this;
    }
    /**
     * Get PurchaseCurrency value
     * @return string|null
     */
    public function getPurchaseCurrency()
    {
        return $this->PurchaseCurrency;
    }
    /**
     * Set PurchaseCurrency value
     * @param string $purchaseCurrency
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setPurchaseCurrency($purchaseCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseCurrency) && !is_string($purchaseCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseCurrency, true), gettype($purchaseCurrency)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{3})
        if (!is_null($purchaseCurrency) && !preg_match('/[A-Z]{3}/', $purchaseCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{3}', var_export($purchaseCurrency, true)), __LINE__);
        }
        $this->PurchaseCurrency = $purchaseCurrency;
        return $this;
    }
    /**
     * Get DeliveryTerm value
     * @return string|null
     */
    public function getDeliveryTerm()
    {
        return $this->DeliveryTerm;
    }
    /**
     * Set DeliveryTerm value
     * @uses \LectorSOAP\EnumType\DeliveryTerm::valueIsValid()
     * @uses \LectorSOAP\EnumType\DeliveryTerm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryTerm
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setDeliveryTerm($deliveryTerm = null)
    {
        // validation for constraint: enumeration
        if (!\LectorSOAP\EnumType\DeliveryTerm::valueIsValid($deliveryTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LectorSOAP\EnumType\DeliveryTerm', is_array($deliveryTerm) ? implode(', ', $deliveryTerm) : var_export($deliveryTerm, true), implode(', ', \LectorSOAP\EnumType\DeliveryTerm::getValidValues())), __LINE__);
        }
        $this->DeliveryTerm = $deliveryTerm;
        return $this;
    }
    /**
     * Get Packaging value
     * @return \LectorSOAP\StructType\Packaging|null
     */
    public function getPackaging()
    {
        return $this->Packaging;
    }
    /**
     * Set Packaging value
     * @param \LectorSOAP\StructType\Packaging $packaging
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setPackaging(\LectorSOAP\StructType\Packaging $packaging = null)
    {
        $this->Packaging = $packaging;
        return $this;
    }
    /**
     * Get SupplierDocuments value
     * @return \LectorSOAP\StructType\SupplierDocuments|null
     */
    public function getSupplierDocuments()
    {
        return $this->SupplierDocuments;
    }
    /**
     * Set SupplierDocuments value
     * @param \LectorSOAP\StructType\SupplierDocuments $supplierDocuments
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setSupplierDocuments(\LectorSOAP\StructType\SupplierDocuments $supplierDocuments = null)
    {
        $this->SupplierDocuments = $supplierDocuments;
        return $this;
    }
    /**
     * Get PurchaseOrderAttribute value
     * @return string|null
     */
    public function getPurchaseOrderAttribute()
    {
        return $this->PurchaseOrderAttribute;
    }
    /**
     * Set PurchaseOrderAttribute value
     * @param string $purchaseOrderAttribute
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setPurchaseOrderAttribute($purchaseOrderAttribute = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderAttribute) && !is_string($purchaseOrderAttribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderAttribute, true), gettype($purchaseOrderAttribute)), __LINE__);
        }
        $this->PurchaseOrderAttribute = $purchaseOrderAttribute;
        return $this;
    }
    /**
     * Get PurchaseOrderCreatedDate value
     * @return string|null
     */
    public function getPurchaseOrderCreatedDate()
    {
        return $this->PurchaseOrderCreatedDate;
    }
    /**
     * Set PurchaseOrderCreatedDate value
     * @param string $purchaseOrderCreatedDate
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setPurchaseOrderCreatedDate($purchaseOrderCreatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderCreatedDate) && !is_string($purchaseOrderCreatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderCreatedDate, true), gettype($purchaseOrderCreatedDate)), __LINE__);
        }
        $this->PurchaseOrderCreatedDate = $purchaseOrderCreatedDate;
        return $this;
    }
    /**
     * Get PreferenceSummary value
     * @return \LectorSOAP\StructType\PreferenceSummary|null
     */
    public function getPreferenceSummary()
    {
        return $this->PreferenceSummary;
    }
    /**
     * Set PreferenceSummary value
     * @param \LectorSOAP\StructType\PreferenceSummary $preferenceSummary
     * @return \LectorSOAP\StructType\PurchaseOrder
     */
    public function setPreferenceSummary(\LectorSOAP\StructType\PreferenceSummary $preferenceSummary = null)
    {
        $this->PreferenceSummary = $preferenceSummary;
        return $this;
    }
}
