<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * Meta information extracted from the WSDL
 * - documentation: This element may be used in connection with completing an e-AD document for the Excise Movement and Control system. It is possible to define a category, type and a value for each additional product attribute. Each attribute must be
 * implemented in the create e-AD function. | An optional list of additional values that should be included in the calculation of customs value. Useful for elements like (but not limited to) royalties, that are not included in the invoice amount, but
 * are still part of the products statistical value. We expect a list of elements, containing an amount, a currency and a “CustomsValueType” A CustomsValueType is simply a text-description of up to 50 characters, and is used for distinguishing
 * different additional values in the statistical value components overview on the Inbound Edit page and for certain reports.
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - documentation: The product identifier in the originating system. It is only stored for traceability and debugging purposes.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $ProductId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - documentation: The name of the product in the originating system.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $ProductName;
    /**
     * The ProductNumber
     * Meta information extracted from the WSDL
     * - documentation: The product number from the originating system.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $ProductNumber;
    /**
     * The ProductSKU
     * Meta information extracted from the WSDL
     * - documentation: The product stock keeping unit in the WMS system. e.g. EAN.
     * - base: xs:string
     * - maxLength: 25
     * @var string
     */
    public $ProductSKU;
    /**
     * The ProductQty
     * Meta information extracted from the WSDL
     * - documentation: This is specifically for outbound-handling of internal production/refinement of multiple bonded variants into one new product, which must count-down the parts, but must show up as a new product on an export document. The element
     * should be omitted unless otherwise instructed.
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $ProductQty;
    /**
     * The ProductDescription
     * Meta information extracted from the WSDL
     * - documentation: The product description used in Box 31.5 of the SAD document.
     * - base: xs:string
     * - maxLength: 500
     * @var string
     */
    public $ProductDescription;
    /**
     * The ProductPurchasePrice
     * Meta information extracted from the WSDL
     * - documentation: The product purchase price per unit required for inbound files only. Please note that this value and currency should be as specified on the supplier invoice.
     * - base: xs:decimal
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $ProductPurchasePrice;
    /**
     * The ProductSalesPrice
     * Meta information extracted from the WSDL
     * - documentation: The product sales price per unit as required for outbound files only.
     * - base: xs:decimal
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $ProductSalesPrice;
    /**
     * The ProductCustomsSalesPrice
     * Meta information extracted from the WSDL
     * - documentation: The product customs sales price is used for products with no or intrinsic value. This is only relevant for outbound files and for products that do not have a sales price.
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $ProductCustomsSalesPrice;
    /**
     * The ProductComposition
     * Meta information extracted from the WSDL
     * - documentation: The composition of the product, as a single coherent string, formatted as “[Percentage]% [Material],[Percentage]% [Material]…”. E.g. “80% Cotton, 17% Nylon, 3% Elastane”.
     * - minOccurs: 0
     * @var string
     */
    public $ProductComposition;
    /**
     * The ProductUrl
     * Meta information extracted from the WSDL
     * - documentation: Link a product specification or an image from the originating system. The link is accessed by using the link function on the SAD document record. All image formats and sizes are supported (as long as the browser used for viewing
     * supports it).
     * - base: xs:anyURI
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $ProductUrl;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Used when both an image link and a product specification link from the originating system. is required. The link is accessed by using the link function on the SAD document record. If both an image link AND a product specification
     * link is available, the link function on the SAD document will show the image and the product specification is accessed by pressing the image. All image formats and sizes are supported (as long as the browser used for viewing supports it).
     * - base: xs:anyURI
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $ImageUrl;
    /**
     * The ProductNote
     * Meta information extracted from the WSDL
     * - documentation: This is an optional note which when present is added to Box 44.6 on the SAD document.
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $ProductNote;
    /**
     * The ProductGroupName
     * Meta information extracted from the WSDL
     * - documentation: The name of the product group. This has no value in the customs handling process but can be used for reporting, documentation and statistics.
     * - minOccurs: 0
     * @var string
     */
    public $ProductGroupName;
    /**
     * The ProductGroupNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the product group. This has no value in the customs handling process but can be used for reporting, documentation and statistics.
     * - minOccurs: 0
     * @var string
     */
    public $ProductGroupNumber;
    /**
     * The ProductSubGroupName
     * Meta information extracted from the WSDL
     * - documentation: The name of the product sub-group. This has no value in the customs handling process but can be used for reporting, documentation and statistics.
     * - minOccurs: 0
     * @var string
     */
    public $ProductSubGroupName;
    /**
     * The ProductSubGroupNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the product sub-group. This has no value in the customs handling process but can be used for reporting, documentation and statistics.
     * - minOccurs: 0
     * @var string
     */
    public $ProductSubGroupNumber;
    /**
     * The BusinessArea
     * Meta information extracted from the WSDL
     * - documentation: The name of the business area. This has no value in the customs handling process but can be used for reporting, documentation and statistics.
     * - minOccurs: 0
     * @var string
     */
    public $BusinessArea;
    /**
     * The BusinessAreaNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the business area. This has no value in the customs handling process but can be used for reporting, documentation and statistics.
     * - minOccurs: 0
     * @var string
     */
    public $BusinessAreaNumber;
    /**
     * The BusinessSubArea
     * Meta information extracted from the WSDL
     * - documentation: The name of the business sub-area. This has no value in the customs handling process but can be used for reporting, documentation and statistics.
     * - minOccurs: 0
     * @var string
     */
    public $BusinessSubArea;
    /**
     * The BusinessSubAreaNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the business sub-area. This has no value in the customs handling process but can be used for reporting, documentation and statistics.
     * - minOccurs: 0
     * @var string
     */
    public $BusinessSubAreaNumber;
    /**
     * The GoodsOwnersId
     * Meta information extracted from the WSDL
     * - documentation: A unique value from the originating system that identifies the owner of the product on import. Please note that this element is a Trading Partner data type which includes several sub-tags of mandatory data.
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $GoodsOwnersId;
    /**
     * The Sample
     * Meta information extracted from the WSDL
     * - documentation: Is the product being import a sample or a standard product?
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [YN]
     * @var string
     */
    public $Sample;
    /**
     * The EmcsProductCode
     * Meta information extracted from the WSDL
     * - documentation: The Excise product code according to the code list in Annex II to Council Regulation No 684/2009. The code is used in Box 17b of the e-AD Excise Movement and Control document.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [TBWISE][0-9]{2}
     * @var string
     */
    public $EmcsProductCode;
    /**
     * The AdditionalCustomsValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: com:AdditionalCustomsValues
     * @var \LectorSOAP\StructType\AdditionalCustomsValues
     */
    public $AdditionalCustomsValues;
    /**
     * The AdditionalProductAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: com:AdditionalProductAttributes
     * @var \LectorSOAP\StructType\AdditionalProductAttributes
     */
    public $AdditionalProductAttributes;
    /**
     * The Variants
     * Meta information extracted from the WSDL
     * - ref: com:Variants
     * @var \LectorSOAP\StructType\Variants
     */
    public $Variants;
    /**
     * Constructor method for Product
     * @uses Product::setProductId()
     * @uses Product::setProductName()
     * @uses Product::setProductNumber()
     * @uses Product::setProductSKU()
     * @uses Product::setProductQty()
     * @uses Product::setProductDescription()
     * @uses Product::setProductPurchasePrice()
     * @uses Product::setProductSalesPrice()
     * @uses Product::setProductCustomsSalesPrice()
     * @uses Product::setProductComposition()
     * @uses Product::setProductUrl()
     * @uses Product::setImageUrl()
     * @uses Product::setProductNote()
     * @uses Product::setProductGroupName()
     * @uses Product::setProductGroupNumber()
     * @uses Product::setProductSubGroupName()
     * @uses Product::setProductSubGroupNumber()
     * @uses Product::setBusinessArea()
     * @uses Product::setBusinessAreaNumber()
     * @uses Product::setBusinessSubArea()
     * @uses Product::setBusinessSubAreaNumber()
     * @uses Product::setGoodsOwnersId()
     * @uses Product::setSample()
     * @uses Product::setEmcsProductCode()
     * @uses Product::setAdditionalCustomsValues()
     * @uses Product::setAdditionalProductAttributes()
     * @uses Product::setVariants()
     * @param string $productId
     * @param string $productName
     * @param string $productNumber
     * @param string $productSKU
     * @param float $productQty
     * @param string $productDescription
     * @param float $productPurchasePrice
     * @param float $productSalesPrice
     * @param float $productCustomsSalesPrice
     * @param string $productComposition
     * @param string $productUrl
     * @param string $imageUrl
     * @param string $productNote
     * @param string $productGroupName
     * @param string $productGroupNumber
     * @param string $productSubGroupName
     * @param string $productSubGroupNumber
     * @param string $businessArea
     * @param string $businessAreaNumber
     * @param string $businessSubArea
     * @param string $businessSubAreaNumber
     * @param string $goodsOwnersId
     * @param string $sample
     * @param string $emcsProductCode
     * @param \LectorSOAP\StructType\AdditionalCustomsValues $additionalCustomsValues
     * @param \LectorSOAP\StructType\AdditionalProductAttributes $additionalProductAttributes
     * @param \LectorSOAP\StructType\Variants $variants
     */
    public function __construct($productId = null, $productName = null, $productNumber = null, $productSKU = null, $productQty = null, $productDescription = null, $productPurchasePrice = null, $productSalesPrice = null, $productCustomsSalesPrice = null, $productComposition = null, $productUrl = null, $imageUrl = null, $productNote = null, $productGroupName = null, $productGroupNumber = null, $productSubGroupName = null, $productSubGroupNumber = null, $businessArea = null, $businessAreaNumber = null, $businessSubArea = null, $businessSubAreaNumber = null, $goodsOwnersId = null, $sample = null, $emcsProductCode = null, \LectorSOAP\StructType\AdditionalCustomsValues $additionalCustomsValues = null, \LectorSOAP\StructType\AdditionalProductAttributes $additionalProductAttributes = null, \LectorSOAP\StructType\Variants $variants = null)
    {
        $this
            ->setProductId($productId)
            ->setProductName($productName)
            ->setProductNumber($productNumber)
            ->setProductSKU($productSKU)
            ->setProductQty($productQty)
            ->setProductDescription($productDescription)
            ->setProductPurchasePrice($productPurchasePrice)
            ->setProductSalesPrice($productSalesPrice)
            ->setProductCustomsSalesPrice($productCustomsSalesPrice)
            ->setProductComposition($productComposition)
            ->setProductUrl($productUrl)
            ->setImageUrl($imageUrl)
            ->setProductNote($productNote)
            ->setProductGroupName($productGroupName)
            ->setProductGroupNumber($productGroupNumber)
            ->setProductSubGroupName($productSubGroupName)
            ->setProductSubGroupNumber($productSubGroupNumber)
            ->setBusinessArea($businessArea)
            ->setBusinessAreaNumber($businessAreaNumber)
            ->setBusinessSubArea($businessSubArea)
            ->setBusinessSubAreaNumber($businessSubAreaNumber)
            ->setGoodsOwnersId($goodsOwnersId)
            ->setSample($sample)
            ->setEmcsProductCode($emcsProductCode)
            ->setAdditionalCustomsValues($additionalCustomsValues)
            ->setAdditionalProductAttributes($additionalProductAttributes)
            ->setVariants($variants);
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($productId) && mb_strlen($productId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($productName) && mb_strlen($productName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->ProductNumber;
    }
    /**
     * Set ProductNumber value
     * @param string $productNumber
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNumber, true), gettype($productNumber)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($productNumber) && mb_strlen($productNumber) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($productNumber)), __LINE__);
        }
        $this->ProductNumber = $productNumber;
        return $this;
    }
    /**
     * Get ProductSKU value
     * @return string|null
     */
    public function getProductSKU()
    {
        return $this->ProductSKU;
    }
    /**
     * Set ProductSKU value
     * @param string $productSKU
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductSKU($productSKU = null)
    {
        // validation for constraint: string
        if (!is_null($productSKU) && !is_string($productSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSKU, true), gettype($productSKU)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($productSKU) && mb_strlen($productSKU) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($productSKU)), __LINE__);
        }
        $this->ProductSKU = $productSKU;
        return $this;
    }
    /**
     * Get ProductQty value
     * @return float|null
     */
    public function getProductQty()
    {
        return $this->ProductQty;
    }
    /**
     * Set ProductQty value
     * @param float $productQty
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductQty($productQty = null)
    {
        // validation for constraint: float
        if (!is_null($productQty) && !(is_float($productQty) || is_numeric($productQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($productQty, true), gettype($productQty)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($productQty) && $productQty < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($productQty, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($productQty) && !preg_match('/[0-9]*[.]?[0-9]+/', $productQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($productQty, true)), __LINE__);
        }
        $this->ProductQty = $productQty;
        return $this;
    }
    /**
     * Get ProductDescription value
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->ProductDescription;
    }
    /**
     * Set ProductDescription value
     * @param string $productDescription
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productDescription, true), gettype($productDescription)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($productDescription) && mb_strlen($productDescription) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($productDescription)), __LINE__);
        }
        $this->ProductDescription = $productDescription;
        return $this;
    }
    /**
     * Get ProductPurchasePrice value
     * @return float|null
     */
    public function getProductPurchasePrice()
    {
        return $this->ProductPurchasePrice;
    }
    /**
     * Set ProductPurchasePrice value
     * @param float $productPurchasePrice
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductPurchasePrice($productPurchasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($productPurchasePrice) && !(is_float($productPurchasePrice) || is_numeric($productPurchasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($productPurchasePrice, true), gettype($productPurchasePrice)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($productPurchasePrice) && $productPurchasePrice < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($productPurchasePrice, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($productPurchasePrice) && !preg_match('/[0-9]*[.]?[0-9]+/', $productPurchasePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($productPurchasePrice, true)), __LINE__);
        }
        $this->ProductPurchasePrice = $productPurchasePrice;
        return $this;
    }
    /**
     * Get ProductSalesPrice value
     * @return float|null
     */
    public function getProductSalesPrice()
    {
        return $this->ProductSalesPrice;
    }
    /**
     * Set ProductSalesPrice value
     * @param float $productSalesPrice
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductSalesPrice($productSalesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($productSalesPrice) && !(is_float($productSalesPrice) || is_numeric($productSalesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($productSalesPrice, true), gettype($productSalesPrice)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($productSalesPrice) && $productSalesPrice < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($productSalesPrice, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($productSalesPrice) && !preg_match('/[0-9]*[.]?[0-9]+/', $productSalesPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($productSalesPrice, true)), __LINE__);
        }
        $this->ProductSalesPrice = $productSalesPrice;
        return $this;
    }
    /**
     * Get ProductCustomsSalesPrice value
     * @return float|null
     */
    public function getProductCustomsSalesPrice()
    {
        return $this->ProductCustomsSalesPrice;
    }
    /**
     * Set ProductCustomsSalesPrice value
     * @param float $productCustomsSalesPrice
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductCustomsSalesPrice($productCustomsSalesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($productCustomsSalesPrice) && !(is_float($productCustomsSalesPrice) || is_numeric($productCustomsSalesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($productCustomsSalesPrice, true), gettype($productCustomsSalesPrice)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($productCustomsSalesPrice) && $productCustomsSalesPrice < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($productCustomsSalesPrice, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($productCustomsSalesPrice) && !preg_match('/[0-9]*[.]?[0-9]+/', $productCustomsSalesPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($productCustomsSalesPrice, true)), __LINE__);
        }
        $this->ProductCustomsSalesPrice = $productCustomsSalesPrice;
        return $this;
    }
    /**
     * Get ProductComposition value
     * @return string|null
     */
    public function getProductComposition()
    {
        return $this->ProductComposition;
    }
    /**
     * Set ProductComposition value
     * @param string $productComposition
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductComposition($productComposition = null)
    {
        // validation for constraint: string
        if (!is_null($productComposition) && !is_string($productComposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productComposition, true), gettype($productComposition)), __LINE__);
        }
        $this->ProductComposition = $productComposition;
        return $this;
    }
    /**
     * Get ProductUrl value
     * @return string|null
     */
    public function getProductUrl()
    {
        return $this->ProductUrl;
    }
    /**
     * Set ProductUrl value
     * @param string $productUrl
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductUrl($productUrl = null)
    {
        // validation for constraint: string
        if (!is_null($productUrl) && !is_string($productUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productUrl, true), gettype($productUrl)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($productUrl) && mb_strlen($productUrl) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($productUrl)), __LINE__);
        }
        $this->ProductUrl = $productUrl;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return \LectorSOAP\StructType\Product
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($imageUrl) && mb_strlen($imageUrl) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Get ProductNote value
     * @return string|null
     */
    public function getProductNote()
    {
        return $this->ProductNote;
    }
    /**
     * Set ProductNote value
     * @param string $productNote
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductNote($productNote = null)
    {
        // validation for constraint: string
        if (!is_null($productNote) && !is_string($productNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNote, true), gettype($productNote)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($productNote) && mb_strlen($productNote) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($productNote)), __LINE__);
        }
        $this->ProductNote = $productNote;
        return $this;
    }
    /**
     * Get ProductGroupName value
     * @return string|null
     */
    public function getProductGroupName()
    {
        return $this->ProductGroupName;
    }
    /**
     * Set ProductGroupName value
     * @param string $productGroupName
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductGroupName($productGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($productGroupName) && !is_string($productGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productGroupName, true), gettype($productGroupName)), __LINE__);
        }
        $this->ProductGroupName = $productGroupName;
        return $this;
    }
    /**
     * Get ProductGroupNumber value
     * @return string|null
     */
    public function getProductGroupNumber()
    {
        return $this->ProductGroupNumber;
    }
    /**
     * Set ProductGroupNumber value
     * @param string $productGroupNumber
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductGroupNumber($productGroupNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productGroupNumber) && !is_string($productGroupNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productGroupNumber, true), gettype($productGroupNumber)), __LINE__);
        }
        $this->ProductGroupNumber = $productGroupNumber;
        return $this;
    }
    /**
     * Get ProductSubGroupName value
     * @return string|null
     */
    public function getProductSubGroupName()
    {
        return $this->ProductSubGroupName;
    }
    /**
     * Set ProductSubGroupName value
     * @param string $productSubGroupName
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductSubGroupName($productSubGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($productSubGroupName) && !is_string($productSubGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSubGroupName, true), gettype($productSubGroupName)), __LINE__);
        }
        $this->ProductSubGroupName = $productSubGroupName;
        return $this;
    }
    /**
     * Get ProductSubGroupNumber value
     * @return string|null
     */
    public function getProductSubGroupNumber()
    {
        return $this->ProductSubGroupNumber;
    }
    /**
     * Set ProductSubGroupNumber value
     * @param string $productSubGroupNumber
     * @return \LectorSOAP\StructType\Product
     */
    public function setProductSubGroupNumber($productSubGroupNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productSubGroupNumber) && !is_string($productSubGroupNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSubGroupNumber, true), gettype($productSubGroupNumber)), __LINE__);
        }
        $this->ProductSubGroupNumber = $productSubGroupNumber;
        return $this;
    }
    /**
     * Get BusinessArea value
     * @return string|null
     */
    public function getBusinessArea()
    {
        return $this->BusinessArea;
    }
    /**
     * Set BusinessArea value
     * @param string $businessArea
     * @return \LectorSOAP\StructType\Product
     */
    public function setBusinessArea($businessArea = null)
    {
        // validation for constraint: string
        if (!is_null($businessArea) && !is_string($businessArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessArea, true), gettype($businessArea)), __LINE__);
        }
        $this->BusinessArea = $businessArea;
        return $this;
    }
    /**
     * Get BusinessAreaNumber value
     * @return string|null
     */
    public function getBusinessAreaNumber()
    {
        return $this->BusinessAreaNumber;
    }
    /**
     * Set BusinessAreaNumber value
     * @param string $businessAreaNumber
     * @return \LectorSOAP\StructType\Product
     */
    public function setBusinessAreaNumber($businessAreaNumber = null)
    {
        // validation for constraint: string
        if (!is_null($businessAreaNumber) && !is_string($businessAreaNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessAreaNumber, true), gettype($businessAreaNumber)), __LINE__);
        }
        $this->BusinessAreaNumber = $businessAreaNumber;
        return $this;
    }
    /**
     * Get BusinessSubArea value
     * @return string|null
     */
    public function getBusinessSubArea()
    {
        return $this->BusinessSubArea;
    }
    /**
     * Set BusinessSubArea value
     * @param string $businessSubArea
     * @return \LectorSOAP\StructType\Product
     */
    public function setBusinessSubArea($businessSubArea = null)
    {
        // validation for constraint: string
        if (!is_null($businessSubArea) && !is_string($businessSubArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessSubArea, true), gettype($businessSubArea)), __LINE__);
        }
        $this->BusinessSubArea = $businessSubArea;
        return $this;
    }
    /**
     * Get BusinessSubAreaNumber value
     * @return string|null
     */
    public function getBusinessSubAreaNumber()
    {
        return $this->BusinessSubAreaNumber;
    }
    /**
     * Set BusinessSubAreaNumber value
     * @param string $businessSubAreaNumber
     * @return \LectorSOAP\StructType\Product
     */
    public function setBusinessSubAreaNumber($businessSubAreaNumber = null)
    {
        // validation for constraint: string
        if (!is_null($businessSubAreaNumber) && !is_string($businessSubAreaNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessSubAreaNumber, true), gettype($businessSubAreaNumber)), __LINE__);
        }
        $this->BusinessSubAreaNumber = $businessSubAreaNumber;
        return $this;
    }
    /**
     * Get GoodsOwnersId value
     * @return string|null
     */
    public function getGoodsOwnersId()
    {
        return $this->GoodsOwnersId;
    }
    /**
     * Set GoodsOwnersId value
     * @param string $goodsOwnersId
     * @return \LectorSOAP\StructType\Product
     */
    public function setGoodsOwnersId($goodsOwnersId = null)
    {
        // validation for constraint: string
        if (!is_null($goodsOwnersId) && !is_string($goodsOwnersId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsOwnersId, true), gettype($goodsOwnersId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($goodsOwnersId) && mb_strlen($goodsOwnersId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($goodsOwnersId)), __LINE__);
        }
        $this->GoodsOwnersId = $goodsOwnersId;
        return $this;
    }
    /**
     * Get Sample value
     * @return string|null
     */
    public function getSample()
    {
        return $this->Sample;
    }
    /**
     * Set Sample value
     * @param string $sample
     * @return \LectorSOAP\StructType\Product
     */
    public function setSample($sample = null)
    {
        // validation for constraint: string
        if (!is_null($sample) && !is_string($sample)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sample, true), gettype($sample)), __LINE__);
        }
        // validation for constraint: pattern([YN])
        if (!is_null($sample) && !preg_match('/[YN]/', $sample)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [YN]', var_export($sample, true)), __LINE__);
        }
        $this->Sample = $sample;
        return $this;
    }
    /**
     * Get EmcsProductCode value
     * @return string|null
     */
    public function getEmcsProductCode()
    {
        return $this->EmcsProductCode;
    }
    /**
     * Set EmcsProductCode value
     * @param string $emcsProductCode
     * @return \LectorSOAP\StructType\Product
     */
    public function setEmcsProductCode($emcsProductCode = null)
    {
        // validation for constraint: string
        if (!is_null($emcsProductCode) && !is_string($emcsProductCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emcsProductCode, true), gettype($emcsProductCode)), __LINE__);
        }
        // validation for constraint: pattern([TBWISE][0-9]{2})
        if (!is_null($emcsProductCode) && !preg_match('/[TBWISE][0-9]{2}/', $emcsProductCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [TBWISE][0-9]{2}', var_export($emcsProductCode, true)), __LINE__);
        }
        $this->EmcsProductCode = $emcsProductCode;
        return $this;
    }
    /**
     * Get AdditionalCustomsValues value
     * @return \LectorSOAP\StructType\AdditionalCustomsValues|null
     */
    public function getAdditionalCustomsValues()
    {
        return $this->AdditionalCustomsValues;
    }
    /**
     * Set AdditionalCustomsValues value
     * @param \LectorSOAP\StructType\AdditionalCustomsValues $additionalCustomsValues
     * @return \LectorSOAP\StructType\Product
     */
    public function setAdditionalCustomsValues(\LectorSOAP\StructType\AdditionalCustomsValues $additionalCustomsValues = null)
    {
        $this->AdditionalCustomsValues = $additionalCustomsValues;
        return $this;
    }
    /**
     * Get AdditionalProductAttributes value
     * @return \LectorSOAP\StructType\AdditionalProductAttributes|null
     */
    public function getAdditionalProductAttributes()
    {
        return $this->AdditionalProductAttributes;
    }
    /**
     * Set AdditionalProductAttributes value
     * @param \LectorSOAP\StructType\AdditionalProductAttributes $additionalProductAttributes
     * @return \LectorSOAP\StructType\Product
     */
    public function setAdditionalProductAttributes(\LectorSOAP\StructType\AdditionalProductAttributes $additionalProductAttributes = null)
    {
        $this->AdditionalProductAttributes = $additionalProductAttributes;
        return $this;
    }
    /**
     * Get Variants value
     * @return \LectorSOAP\StructType\Variants|null
     */
    public function getVariants()
    {
        return $this->Variants;
    }
    /**
     * Set Variants value
     * @param \LectorSOAP\StructType\Variants $variants
     * @return \LectorSOAP\StructType\Product
     */
    public function setVariants(\LectorSOAP\StructType\Variants $variants = null)
    {
        $this->Variants = $variants;
        return $this;
    }
}
