<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreferenceSummary StructType
 * @subpackage Structs
 */
class PreferenceSummary extends AbstractStructBase
{
    /**
     * The Preference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \LectorSOAP\StructType\Preference[]
     */
    public $Preference;
    /**
     * Constructor method for PreferenceSummary
     * @uses PreferenceSummary::setPreference()
     * @param \LectorSOAP\StructType\Preference[] $preference
     */
    public function __construct(array $preference = array())
    {
        $this
            ->setPreference($preference);
    }
    /**
     * Get Preference value
     * @return \LectorSOAP\StructType\Preference[]|null
     */
    public function getPreference()
    {
        return $this->Preference;
    }
    /**
     * This method is responsible for validating the values passed to the setPreference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePreferenceForArrayConstraintsFromSetPreference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $preferenceSummaryPreferenceItem) {
            // validation for constraint: itemType
            if (!$preferenceSummaryPreferenceItem instanceof \LectorSOAP\StructType\Preference) {
                $invalidValues[] = is_object($preferenceSummaryPreferenceItem) ? get_class($preferenceSummaryPreferenceItem) : sprintf('%s(%s)', gettype($preferenceSummaryPreferenceItem), var_export($preferenceSummaryPreferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Preference property can only contain items of type \LectorSOAP\StructType\Preference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Preference value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Preference[] $preference
     * @return \LectorSOAP\StructType\PreferenceSummary
     */
    public function setPreference(array $preference = array())
    {
        // validation for constraint: array
        if ('' !== ($preferenceArrayErrorMessage = self::validatePreferenceForArrayConstraintsFromSetPreference($preference))) {
            throw new \InvalidArgumentException($preferenceArrayErrorMessage, __LINE__);
        }
        $this->Preference = $preference;
        return $this;
    }
    /**
     * Add item to Preference value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Preference $item
     * @return \LectorSOAP\StructType\PreferenceSummary
     */
    public function addToPreference(\LectorSOAP\StructType\Preference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LectorSOAP\StructType\Preference) {
            throw new \InvalidArgumentException(sprintf('The Preference property can only contain items of type \LectorSOAP\StructType\Preference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Preference[] = $item;
        return $this;
    }
}
