<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Packaging StructType
 * @subpackage Structs
 */
class Packaging extends AbstractStructBase
{
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \LectorSOAP\StructType\Package[]
     */
    public $Package;
    /**
     * Constructor method for Packaging
     * @uses Packaging::setPackage()
     * @param \LectorSOAP\StructType\Package[] $package
     */
    public function __construct(array $package = array())
    {
        $this
            ->setPackage($package);
    }
    /**
     * Get Package value
     * @return \LectorSOAP\StructType\Package[]|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packagingPackageItem) {
            // validation for constraint: itemType
            if (!$packagingPackageItem instanceof \LectorSOAP\StructType\Package) {
                $invalidValues[] = is_object($packagingPackageItem) ? get_class($packagingPackageItem) : sprintf('%s(%s)', gettype($packagingPackageItem), var_export($packagingPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Package property can only contain items of type \LectorSOAP\StructType\Package, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Package value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Package[] $package
     * @return \LectorSOAP\StructType\Packaging
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Add item to Package value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Package $item
     * @return \LectorSOAP\StructType\Packaging
     */
    public function addToPackage(\LectorSOAP\StructType\Package $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LectorSOAP\StructType\Package) {
            throw new \InvalidArgumentException(sprintf('The Package property can only contain items of type \LectorSOAP\StructType\Package, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Package[] = $item;
        return $this;
    }
}
