<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * Meta information extracted from the WSDL
 * - documentation: A document category i.e. CERTS for SAD Box 44.2, PREFS for SAD Box 44.4 etc. Please refer to the DocumentCategory element for valid values.
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - documentation: The document identifier in the originating system.
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $DocumentId;
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - documentation: A number that clearly identifies the document.
     * - base: xs:string
     * - maxLength: 40
     * @var string
     */
    public $DocumentNumber;
    /**
     * The DocumentDate
     * Meta information extracted from the WSDL
     * - documentation: The date the document was issued.
     * @var string
     */
    public $DocumentDate;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - documentation: A document type code. Ask the LTS team for a valid list of codes.
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * The DocumentCategory
     * Meta information extracted from the WSDL
     * - ref: tns:DocumentCategory
     * @var string
     */
    public $DocumentCategory;
    /**
     * The DocumentPieces
     * Meta information extracted from the WSDL
     * - documentation: The number of pieces denoted on the document.
     * - base: xs:int
     * - default: 0
     * - minInclusive: 0
     * @var int
     */
    public $DocumentPieces;
    /**
     * The DocumentAmount
     * Meta information extracted from the WSDL
     * - documentation: The document amount e.g. supplier invoice amount.
     * - base: xs:decimal
     * - default: 0
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $DocumentAmount;
    /**
     * The DocumentCurrency
     * Meta information extracted from the WSDL
     * - documentation: The document currency. If a document amount is > 0 then a valid currency code (ISO3) is mandatory. Please note that this element is mandatory for invoices.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $DocumentCurrency;
    /**
     * The DocumentExpires
     * Meta information extracted from the WSDL
     * - documentation: The date the document is no longer valid. Some document types that provide duty relief have an expires date.
     * - minOccurs: 0
     * @var string
     */
    public $DocumentExpires;
    /**
     * The DocumentOrigin
     * Meta information extracted from the WSDL
     * - documentation: The origin of the document. Please note that this element is mandatory for invoices.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [A-Z]{2,3}
     * @var string
     */
    public $DocumentOrigin;
    /**
     * The DocumentRex
     * Meta information extracted from the WSDL
     * - documentation: Has the document been issued by a valid Registered Exporter?
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [YN]
     * @var string
     */
    public $DocumentRex;
    /**
     * The DocumentPW
     * Meta information extracted from the WSDL
     * - documentation: Have the goods been produced or partially produced in the beneficiary country as denoted in the document. If this is a duty relief document destined for SAD Box 44.4, then this value should be included.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [pw]
     * @var string
     */
    public $DocumentPW;
    /**
     * The ParentDocumentNumber
     * Meta information extracted from the WSDL
     * - documentation: A number that clearly identifies the document.
     * - base: xs:string
     * - maxLength: 40
     * @var string
     */
    public $ParentDocumentNumber;
    /**
     * The DocumentCopy
     * Meta information extracted from the WSDL
     * - documentation: Is the document an original or a working copy?
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [YN]
     * @var string
     */
    public $DocumentCopy;
    /**
     * Constructor method for Document
     * @uses Document::setDocumentId()
     * @uses Document::setDocumentNumber()
     * @uses Document::setDocumentDate()
     * @uses Document::setDocumentType()
     * @uses Document::setDocumentCategory()
     * @uses Document::setDocumentPieces()
     * @uses Document::setDocumentAmount()
     * @uses Document::setDocumentCurrency()
     * @uses Document::setDocumentExpires()
     * @uses Document::setDocumentOrigin()
     * @uses Document::setDocumentRex()
     * @uses Document::setDocumentPW()
     * @uses Document::setParentDocumentNumber()
     * @uses Document::setDocumentCopy()
     * @param string $documentId
     * @param string $documentNumber
     * @param string $documentDate
     * @param string $documentType
     * @param string $documentCategory
     * @param int $documentPieces
     * @param float $documentAmount
     * @param string $documentCurrency
     * @param string $documentExpires
     * @param string $documentOrigin
     * @param string $documentRex
     * @param string $documentPW
     * @param string $parentDocumentNumber
     * @param string $documentCopy
     */
    public function __construct($documentId = null, $documentNumber = null, $documentDate = null, $documentType = null, $documentCategory = null, $documentPieces = 0, $documentAmount = 0, $documentCurrency = null, $documentExpires = null, $documentOrigin = null, $documentRex = null, $documentPW = null, $parentDocumentNumber = null, $documentCopy = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setDocumentNumber($documentNumber)
            ->setDocumentDate($documentDate)
            ->setDocumentType($documentType)
            ->setDocumentCategory($documentCategory)
            ->setDocumentPieces($documentPieces)
            ->setDocumentAmount($documentAmount)
            ->setDocumentCurrency($documentCurrency)
            ->setDocumentExpires($documentExpires)
            ->setDocumentOrigin($documentOrigin)
            ->setDocumentRex($documentRex)
            ->setDocumentPW($documentPW)
            ->setParentDocumentNumber($parentDocumentNumber)
            ->setDocumentCopy($documentCopy);
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($documentId) && mb_strlen($documentId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($documentId)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($documentNumber) && mb_strlen($documentNumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($documentNumber)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get DocumentCategory value
     * @return string|null
     */
    public function getDocumentCategory()
    {
        return $this->DocumentCategory;
    }
    /**
     * Set DocumentCategory value
     * @uses \LectorSOAP\EnumType\DocumentCategory::valueIsValid()
     * @uses \LectorSOAP\EnumType\DocumentCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentCategory
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentCategory($documentCategory = null)
    {
        // validation for constraint: enumeration
        if (!\LectorSOAP\EnumType\DocumentCategory::valueIsValid($documentCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LectorSOAP\EnumType\DocumentCategory', is_array($documentCategory) ? implode(', ', $documentCategory) : var_export($documentCategory, true), implode(', ', \LectorSOAP\EnumType\DocumentCategory::getValidValues())), __LINE__);
        }
        $this->DocumentCategory = $documentCategory;
        return $this;
    }
    /**
     * Get DocumentPieces value
     * @return int|null
     */
    public function getDocumentPieces()
    {
        return $this->DocumentPieces;
    }
    /**
     * Set DocumentPieces value
     * @param int $documentPieces
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentPieces($documentPieces = 0)
    {
        // validation for constraint: int
        if (!is_null($documentPieces) && !(is_int($documentPieces) || ctype_digit($documentPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentPieces, true), gettype($documentPieces)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($documentPieces) && $documentPieces < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($documentPieces, true)), __LINE__);
        }
        $this->DocumentPieces = $documentPieces;
        return $this;
    }
    /**
     * Get DocumentAmount value
     * @return float|null
     */
    public function getDocumentAmount()
    {
        return $this->DocumentAmount;
    }
    /**
     * Set DocumentAmount value
     * @param float $documentAmount
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentAmount($documentAmount = 0)
    {
        // validation for constraint: float
        if (!is_null($documentAmount) && !(is_float($documentAmount) || is_numeric($documentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($documentAmount, true), gettype($documentAmount)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($documentAmount) && $documentAmount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($documentAmount, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($documentAmount) && !preg_match('/[0-9]*[.]?[0-9]+/', $documentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($documentAmount, true)), __LINE__);
        }
        $this->DocumentAmount = $documentAmount;
        return $this;
    }
    /**
     * Get DocumentCurrency value
     * @return string|null
     */
    public function getDocumentCurrency()
    {
        return $this->DocumentCurrency;
    }
    /**
     * Set DocumentCurrency value
     * @param string $documentCurrency
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentCurrency($documentCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($documentCurrency) && !is_string($documentCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentCurrency, true), gettype($documentCurrency)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{3})
        if (!is_null($documentCurrency) && !preg_match('/[A-Z]{3}/', $documentCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{3}', var_export($documentCurrency, true)), __LINE__);
        }
        $this->DocumentCurrency = $documentCurrency;
        return $this;
    }
    /**
     * Get DocumentExpires value
     * @return string|null
     */
    public function getDocumentExpires()
    {
        return $this->DocumentExpires;
    }
    /**
     * Set DocumentExpires value
     * @param string $documentExpires
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentExpires($documentExpires = null)
    {
        // validation for constraint: string
        if (!is_null($documentExpires) && !is_string($documentExpires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentExpires, true), gettype($documentExpires)), __LINE__);
        }
        $this->DocumentExpires = $documentExpires;
        return $this;
    }
    /**
     * Get DocumentOrigin value
     * @return string|null
     */
    public function getDocumentOrigin()
    {
        return $this->DocumentOrigin;
    }
    /**
     * Set DocumentOrigin value
     * @param string $documentOrigin
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentOrigin($documentOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($documentOrigin) && !is_string($documentOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentOrigin, true), gettype($documentOrigin)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,3})
        if (!is_null($documentOrigin) && !preg_match('/[A-Z]{2,3}/', $documentOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,3}', var_export($documentOrigin, true)), __LINE__);
        }
        $this->DocumentOrigin = $documentOrigin;
        return $this;
    }
    /**
     * Get DocumentRex value
     * @return string|null
     */
    public function getDocumentRex()
    {
        return $this->DocumentRex;
    }
    /**
     * Set DocumentRex value
     * @param string $documentRex
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentRex($documentRex = null)
    {
        // validation for constraint: string
        if (!is_null($documentRex) && !is_string($documentRex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentRex, true), gettype($documentRex)), __LINE__);
        }
        // validation for constraint: pattern([YN])
        if (!is_null($documentRex) && !preg_match('/[YN]/', $documentRex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [YN]', var_export($documentRex, true)), __LINE__);
        }
        $this->DocumentRex = $documentRex;
        return $this;
    }
    /**
     * Get DocumentPW value
     * @return string|null
     */
    public function getDocumentPW()
    {
        return $this->DocumentPW;
    }
    /**
     * Set DocumentPW value
     * @param string $documentPW
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentPW($documentPW = null)
    {
        // validation for constraint: string
        if (!is_null($documentPW) && !is_string($documentPW)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentPW, true), gettype($documentPW)), __LINE__);
        }
        // validation for constraint: pattern([pw])
        if (!is_null($documentPW) && !preg_match('/[pw]/', $documentPW)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [pw]', var_export($documentPW, true)), __LINE__);
        }
        $this->DocumentPW = $documentPW;
        return $this;
    }
    /**
     * Get ParentDocumentNumber value
     * @return string|null
     */
    public function getParentDocumentNumber()
    {
        return $this->ParentDocumentNumber;
    }
    /**
     * Set ParentDocumentNumber value
     * @param string $parentDocumentNumber
     * @return \LectorSOAP\StructType\Document
     */
    public function setParentDocumentNumber($parentDocumentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parentDocumentNumber) && !is_string($parentDocumentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentDocumentNumber, true), gettype($parentDocumentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($parentDocumentNumber) && mb_strlen($parentDocumentNumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($parentDocumentNumber)), __LINE__);
        }
        $this->ParentDocumentNumber = $parentDocumentNumber;
        return $this;
    }
    /**
     * Get DocumentCopy value
     * @return string|null
     */
    public function getDocumentCopy()
    {
        return $this->DocumentCopy;
    }
    /**
     * Set DocumentCopy value
     * @param string $documentCopy
     * @return \LectorSOAP\StructType\Document
     */
    public function setDocumentCopy($documentCopy = null)
    {
        // validation for constraint: string
        if (!is_null($documentCopy) && !is_string($documentCopy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentCopy, true), gettype($documentCopy)), __LINE__);
        }
        // validation for constraint: pattern([YN])
        if (!is_null($documentCopy) && !preg_match('/[YN]/', $documentCopy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [YN]', var_export($documentCopy, true)), __LINE__);
        }
        $this->DocumentCopy = $documentCopy;
        return $this;
    }
}
