<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalProductAttribute StructType
 * @subpackage Structs
 */
class AdditionalProductAttribute extends AbstractStructBase
{
    /**
     * The ProductAttributeCategory
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $ProductAttributeCategory;
    /**
     * The ProductAttributeType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $ProductAttributeType;
    /**
     * The ProductAttributeValue
     * @var string
     */
    public $ProductAttributeValue;
    /**
     * Constructor method for AdditionalProductAttribute
     * @uses AdditionalProductAttribute::setProductAttributeCategory()
     * @uses AdditionalProductAttribute::setProductAttributeType()
     * @uses AdditionalProductAttribute::setProductAttributeValue()
     * @param string $productAttributeCategory
     * @param string $productAttributeType
     * @param string $productAttributeValue
     */
    public function __construct($productAttributeCategory = null, $productAttributeType = null, $productAttributeValue = null)
    {
        $this
            ->setProductAttributeCategory($productAttributeCategory)
            ->setProductAttributeType($productAttributeType)
            ->setProductAttributeValue($productAttributeValue);
    }
    /**
     * Get ProductAttributeCategory value
     * @return string|null
     */
    public function getProductAttributeCategory()
    {
        return $this->ProductAttributeCategory;
    }
    /**
     * Set ProductAttributeCategory value
     * @param string $productAttributeCategory
     * @return \LectorSOAP\StructType\AdditionalProductAttribute
     */
    public function setProductAttributeCategory($productAttributeCategory = null)
    {
        // validation for constraint: string
        if (!is_null($productAttributeCategory) && !is_string($productAttributeCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productAttributeCategory, true), gettype($productAttributeCategory)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($productAttributeCategory) && mb_strlen($productAttributeCategory) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($productAttributeCategory)), __LINE__);
        }
        $this->ProductAttributeCategory = $productAttributeCategory;
        return $this;
    }
    /**
     * Get ProductAttributeType value
     * @return string|null
     */
    public function getProductAttributeType()
    {
        return $this->ProductAttributeType;
    }
    /**
     * Set ProductAttributeType value
     * @param string $productAttributeType
     * @return \LectorSOAP\StructType\AdditionalProductAttribute
     */
    public function setProductAttributeType($productAttributeType = null)
    {
        // validation for constraint: string
        if (!is_null($productAttributeType) && !is_string($productAttributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productAttributeType, true), gettype($productAttributeType)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($productAttributeType) && mb_strlen($productAttributeType) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($productAttributeType)), __LINE__);
        }
        $this->ProductAttributeType = $productAttributeType;
        return $this;
    }
    /**
     * Get ProductAttributeValue value
     * @return string|null
     */
    public function getProductAttributeValue()
    {
        return $this->ProductAttributeValue;
    }
    /**
     * Set ProductAttributeValue value
     * @param string $productAttributeValue
     * @return \LectorSOAP\StructType\AdditionalProductAttribute
     */
    public function setProductAttributeValue($productAttributeValue = null)
    {
        // validation for constraint: string
        if (!is_null($productAttributeValue) && !is_string($productAttributeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productAttributeValue, true), gettype($productAttributeValue)), __LINE__);
        }
        $this->ProductAttributeValue = $productAttributeValue;
        return $this;
    }
}
