<?php

namespace LectorSOAP\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DeliveryTerm EnumType
 * @subpackage Enumerations
 */
class DeliveryTerm extends AbstractStructEnumBase
{
    /**
     * Constant for value 'EXW'
     * Meta information extracted from the WSDL
     * - documentation: Ex Works (named place of delivery). The seller makes the goods available at their premises, or at another named place thereby placing the maximum obligation on the buyer.
     * @return string 'EXW'
     */
    const VALUE_EXW = 'EXW';
    /**
     * Constant for value 'FCA'
     * Meta information extracted from the WSDL
     * - documentation: Free Carrier (named place of delivery).The seller delivers the goods, cleared for export, at a named place.
     * @return string 'FCA'
     */
    const VALUE_FCA = 'FCA';
    /**
     * Constant for value 'CPT'
     * Meta information extracted from the WSDL
     * - documentation: CPT – Carriage Paid To (named place of destination).The seller pays for the carriage of the goods up to the named place of destination. The goods are considered to be delivered when they have been handed over to the first or main
     * carrier.
     * @return string 'CPT'
     */
    const VALUE_CPT = 'CPT';
    /**
     * Constant for value 'CIP'
     * Meta information extracted from the WSDL
     * - documentation: CIP – Carriage and Insurance Paid to (named place of destination). This term is broadly similar to the CPT term, with the exception that the seller is required to obtain insurance for the goods while in transit.
     * @return string 'CIP'
     */
    const VALUE_CIP = 'CIP';
    /**
     * Constant for value 'DAT'
     * Meta information extracted from the WSDL
     * - documentation: Delivered at Terminal.
     * @return string 'DAT'
     */
    const VALUE_DAT = 'DAT';
    /**
     * Constant for value 'DAP'
     * Meta information extracted from the WSDL
     * - documentation: DAP – Delivered At Place (named place of destination)
     * @return string 'DAP'
     */
    const VALUE_DAP = 'DAP';
    /**
     * Constant for value 'DDP'
     * Meta information extracted from the WSDL
     * - documentation: DDP – Delivered Duty Paid (named place of destination). Seller is responsible for delivering the goods to the named place in the country of the buyer, and pays all costs in bringing the goods to the destination including import
     * duties and taxes.
     * @return string 'DDP'
     */
    const VALUE_DDP = 'DDP';
    /**
     * Constant for value 'FAS'
     * Meta information extracted from the WSDL
     * - documentation: FAS – Free Alongside Ship (named port of shipment).
     * @return string 'FAS'
     */
    const VALUE_FAS = 'FAS';
    /**
     * Constant for value 'FOB'
     * Meta information extracted from the WSDL
     * - documentation: FOB – Free on Board (named port of shipment).
     * @return string 'FOB'
     */
    const VALUE_FOB = 'FOB';
    /**
     * Constant for value 'CFR'
     * Meta information extracted from the WSDL
     * - documentation: CFR – Cost and Freight (named port of destination).
     * @return string 'CFR'
     */
    const VALUE_CFR = 'CFR';
    /**
     * Constant for value 'CIF'
     * Meta information extracted from the WSDL
     * - documentation: CIF – Cost, Insurance and Freight (named port of destination)
     * @return string 'CIF'
     */
    const VALUE_CIF = 'CIF';
    /**
     * Return allowed values
     * @uses self::VALUE_EXW
     * @uses self::VALUE_FCA
     * @uses self::VALUE_CPT
     * @uses self::VALUE_CIP
     * @uses self::VALUE_DAT
     * @uses self::VALUE_DAP
     * @uses self::VALUE_DDP
     * @uses self::VALUE_FAS
     * @uses self::VALUE_FOB
     * @uses self::VALUE_CFR
     * @uses self::VALUE_CIF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXW,
            self::VALUE_FCA,
            self::VALUE_CPT,
            self::VALUE_CIP,
            self::VALUE_DAT,
            self::VALUE_DAP,
            self::VALUE_DDP,
            self::VALUE_FAS,
            self::VALUE_FOB,
            self::VALUE_CFR,
            self::VALUE_CIF,
        );
    }
}
