<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Products StructType
 * @subpackage Structs
 */
class Products extends AbstractStructBase
{
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \LectorSOAP\StructType\Product[]
     */
    public $Product;
    /**
     * Constructor method for Products
     * @uses Products::setProduct()
     * @param \LectorSOAP\StructType\Product[] $product
     */
    public function __construct(array $product = array())
    {
        $this
            ->setProduct($product);
    }
    /**
     * Get Product value
     * @return \LectorSOAP\StructType\Product[]|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * This method is responsible for validating the values passed to the setProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductForArrayConstraintsFromSetProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productsProductItem) {
            // validation for constraint: itemType
            if (!$productsProductItem instanceof \LectorSOAP\StructType\Product) {
                $invalidValues[] = is_object($productsProductItem) ? get_class($productsProductItem) : sprintf('%s(%s)', gettype($productsProductItem), var_export($productsProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Product property can only contain items of type \LectorSOAP\StructType\Product, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Product value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Product[] $product
     * @return \LectorSOAP\StructType\Products
     */
    public function setProduct(array $product = array())
    {
        // validation for constraint: array
        if ('' !== ($productArrayErrorMessage = self::validateProductForArrayConstraintsFromSetProduct($product))) {
            throw new \InvalidArgumentException($productArrayErrorMessage, __LINE__);
        }
        $this->Product = $product;
        return $this;
    }
    /**
     * Add item to Product value
     * @throws \InvalidArgumentException
     * @param \LectorSOAP\StructType\Product $item
     * @return \LectorSOAP\StructType\Products
     */
    public function addToProduct(\LectorSOAP\StructType\Product $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LectorSOAP\StructType\Product) {
            throw new \InvalidArgumentException(sprintf('The Product property can only contain items of type \LectorSOAP\StructType\Product, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Product[] = $item;
        return $this;
    }
}
