<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Preference StructType
 * @subpackage Structs
 */
class Preference extends AbstractStructBase
{
    /**
     * The CountryOfOrigin
     * Meta information extracted from the WSDL
     * - documentation: The country of origin - ISO2 - referred to on the document.
     * - base: xs:string
     * - pattern: [A-Z]{2,3}
     * @var string
     */
    public $CountryOfOrigin;
    /**
     * The EuCommodityCode
     * Meta information extracted from the WSDL
     * - documentation: This is the import commodity code (taric) for the EU specification.
     * - base: xs:string
     * - maxLength: 20
     * @var string
     */
    public $EuCommodityCode;
    /**
     * The NonEuCommodityCode
     * Meta information extracted from the WSDL
     * - documentation: The corresponding non EU commodity code. This is used in the LTS TURN function when converting a DK Export to a non-EU import.
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $NonEuCommodityCode;
    /**
     * The PreferencedQuantity
     * Meta information extracted from the WSDL
     * - documentation: The sum of preferenced quantities on the Purchase Order.
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $PreferencedQuantity;
    /**
     * The NonPreferencedQuantity
     * Meta information extracted from the WSDL
     * - documentation: The sum of the non preferenced quantities on the purchase order.
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $NonPreferencedQuantity;
    /**
     * Constructor method for Preference
     * @uses Preference::setCountryOfOrigin()
     * @uses Preference::setEuCommodityCode()
     * @uses Preference::setNonEuCommodityCode()
     * @uses Preference::setPreferencedQuantity()
     * @uses Preference::setNonPreferencedQuantity()
     * @param string $countryOfOrigin
     * @param string $euCommodityCode
     * @param string $nonEuCommodityCode
     * @param float $preferencedQuantity
     * @param float $nonPreferencedQuantity
     */
    public function __construct($countryOfOrigin = null, $euCommodityCode = null, $nonEuCommodityCode = null, $preferencedQuantity = null, $nonPreferencedQuantity = null)
    {
        $this
            ->setCountryOfOrigin($countryOfOrigin)
            ->setEuCommodityCode($euCommodityCode)
            ->setNonEuCommodityCode($nonEuCommodityCode)
            ->setPreferencedQuantity($preferencedQuantity)
            ->setNonPreferencedQuantity($nonPreferencedQuantity);
    }
    /**
     * Get CountryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->CountryOfOrigin;
    }
    /**
     * Set CountryOfOrigin value
     * @param string $countryOfOrigin
     * @return \LectorSOAP\StructType\Preference
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfOrigin, true), gettype($countryOfOrigin)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,3})
        if (!is_null($countryOfOrigin) && !preg_match('/[A-Z]{2,3}/', $countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,3}', var_export($countryOfOrigin, true)), __LINE__);
        }
        $this->CountryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get EuCommodityCode value
     * @return string|null
     */
    public function getEuCommodityCode()
    {
        return $this->EuCommodityCode;
    }
    /**
     * Set EuCommodityCode value
     * @param string $euCommodityCode
     * @return \LectorSOAP\StructType\Preference
     */
    public function setEuCommodityCode($euCommodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($euCommodityCode) && !is_string($euCommodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($euCommodityCode, true), gettype($euCommodityCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($euCommodityCode) && mb_strlen($euCommodityCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($euCommodityCode)), __LINE__);
        }
        $this->EuCommodityCode = $euCommodityCode;
        return $this;
    }
    /**
     * Get NonEuCommodityCode value
     * @return string|null
     */
    public function getNonEuCommodityCode()
    {
        return $this->NonEuCommodityCode;
    }
    /**
     * Set NonEuCommodityCode value
     * @param string $nonEuCommodityCode
     * @return \LectorSOAP\StructType\Preference
     */
    public function setNonEuCommodityCode($nonEuCommodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($nonEuCommodityCode) && !is_string($nonEuCommodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonEuCommodityCode, true), gettype($nonEuCommodityCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($nonEuCommodityCode) && mb_strlen($nonEuCommodityCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($nonEuCommodityCode)), __LINE__);
        }
        $this->NonEuCommodityCode = $nonEuCommodityCode;
        return $this;
    }
    /**
     * Get PreferencedQuantity value
     * @return float|null
     */
    public function getPreferencedQuantity()
    {
        return $this->PreferencedQuantity;
    }
    /**
     * Set PreferencedQuantity value
     * @param float $preferencedQuantity
     * @return \LectorSOAP\StructType\Preference
     */
    public function setPreferencedQuantity($preferencedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($preferencedQuantity) && !(is_float($preferencedQuantity) || is_numeric($preferencedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preferencedQuantity, true), gettype($preferencedQuantity)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($preferencedQuantity) && $preferencedQuantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($preferencedQuantity, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($preferencedQuantity) && !preg_match('/[0-9]*[.]?[0-9]+/', $preferencedQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($preferencedQuantity, true)), __LINE__);
        }
        $this->PreferencedQuantity = $preferencedQuantity;
        return $this;
    }
    /**
     * Get NonPreferencedQuantity value
     * @return float|null
     */
    public function getNonPreferencedQuantity()
    {
        return $this->NonPreferencedQuantity;
    }
    /**
     * Set NonPreferencedQuantity value
     * @param float $nonPreferencedQuantity
     * @return \LectorSOAP\StructType\Preference
     */
    public function setNonPreferencedQuantity($nonPreferencedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($nonPreferencedQuantity) && !(is_float($nonPreferencedQuantity) || is_numeric($nonPreferencedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nonPreferencedQuantity, true), gettype($nonPreferencedQuantity)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nonPreferencedQuantity) && $nonPreferencedQuantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nonPreferencedQuantity, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($nonPreferencedQuantity) && !preg_match('/[0-9]*[.]?[0-9]+/', $nonPreferencedQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($nonPreferencedQuantity, true)), __LINE__);
        }
        $this->NonPreferencedQuantity = $nonPreferencedQuantity;
        return $this;
    }
}
