<?php

namespace LectorSOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Package StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains a list of all the products in this package. The product-tag is described subsequently.
 * @subpackage Structs
 */
class Package extends AbstractStructBase
{
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - documentation: The package identifier in the originating system. This value is stored for traceability and debugging purposes.
     * - base: xs:string
     * - maxLength: 100
     * @var string
     */
    public $PackageId;
    /**
     * The PackageType
     * Meta information extracted from the WSDL
     * - documentation: The kind of package. Valid values are “CARTON”, “PACKAGE”, “BOX”, “PARCEL”, “PACKET”,"PALLET",“UNPACKED”. The value is used as the initial value for SAD Box 31.4 (Package Code). Contact the LTS Team for any
     * updates to this list of types.
     * @var string
     */
    public $PackageType;
    /**
     * The PackageSKU
     * Meta information extracted from the WSDL
     * - documentation: The package stock keeping unit.
     * - base: xs:string
     * - maxLength: 25
     * @var string
     */
    public $PackageSKU;
    /**
     * The PackageQty
     * Meta information extracted from the WSDL
     * - documentation: The number of packages. SAD Box 31.2
     * - base: xs:int
     * - minInclusive: 0
     * @var int
     */
    public $PackageQty;
    /**
     * The PackageGrossMass
     * Meta information extracted from the WSDL
     * - documentation: Total weight of the package in kg. Used as the initial value in SAD Box 35.
     * - base: xs:decimal
     * - default: 0
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $PackageGrossMass;
    /**
     * The PackageNetMass
     * Meta information extracted from the WSDL
     * - documentation: Net weight of the package in kg. Used as the initial value in SAD box 38.
     * - base: xs:decimal
     * - default: 0
     * - minInclusive: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $PackageNetMass;
    /**
     * The ItemsPerPackage
     * Meta information extracted from the WSDL
     * - documentation: The number of items in each package. This value should always correspond to the sum of all variant quantities in the package The value is relevant for cross-checking purposes only
     * - base: xs:decimal
     * - minInclusive: 0
     * - minOccurs: 0
     * - pattern: [0-9]*[.]?[0-9]+
     * @var float
     */
    public $ItemsPerPackage;
    /**
     * The ImportOptions
     * Meta information extracted from the WSDL
     * - documentation: This is a special T2 'label' that is not used in the core functionality when generating Imports. When the value "T2" is present then this value is used in conjunction with Generic Defaults to set the correct procedure code on the SAD
     * document. The element should be omitted if not in use.
     * - minOccurs: 0
     * @var string
     */
    public $ImportOptions;
    /**
     * The UseQtyAsTotals
     * Meta information extracted from the WSDL
     * - documentation: The "Use Quantity As Totals" option is used when the number of packages and the total number of variants is known but the distribution of variants per package is unknown Under normal circumstances the default value for this element
     * is 'N' meaning that LTS will multiply the number of packages with the sum of variants in each package in order to calculate the number of imported items.To prohibit the system in making this calculation set the UseQtyAsTotals element to 'Y'.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [YN]
     * @var string
     */
    public $UseQtyAsTotals;
    /**
     * The GoodsOwner
     * Meta information extracted from the WSDL
     * - documentation: The owner of the goods in this specific package. This is useful for companies sharing the same address and/or purchasing goods together, where some packages may contain goods for a different company. This value is primarily used
     * internally, since only one company can be responsible for an import.
     * @var \LectorSOAP\StructType\TradingPartner
     */
    public $GoodsOwner;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - ref: com:Products
     * @var \LectorSOAP\StructType\Products
     */
    public $Products;
    /**
     * Constructor method for Package
     * @uses Package::setPackageId()
     * @uses Package::setPackageType()
     * @uses Package::setPackageSKU()
     * @uses Package::setPackageQty()
     * @uses Package::setPackageGrossMass()
     * @uses Package::setPackageNetMass()
     * @uses Package::setItemsPerPackage()
     * @uses Package::setImportOptions()
     * @uses Package::setUseQtyAsTotals()
     * @uses Package::setGoodsOwner()
     * @uses Package::setProducts()
     * @param string $packageId
     * @param string $packageType
     * @param string $packageSKU
     * @param int $packageQty
     * @param float $packageGrossMass
     * @param float $packageNetMass
     * @param float $itemsPerPackage
     * @param string $importOptions
     * @param string $useQtyAsTotals
     * @param \LectorSOAP\StructType\TradingPartner $goodsOwner
     * @param \LectorSOAP\StructType\Products $products
     */
    public function __construct($packageId = null, $packageType = null, $packageSKU = null, $packageQty = null, $packageGrossMass = 0, $packageNetMass = 0, $itemsPerPackage = null, $importOptions = null, $useQtyAsTotals = null, \LectorSOAP\StructType\TradingPartner $goodsOwner = null, \LectorSOAP\StructType\Products $products = null)
    {
        $this
            ->setPackageId($packageId)
            ->setPackageType($packageType)
            ->setPackageSKU($packageSKU)
            ->setPackageQty($packageQty)
            ->setPackageGrossMass($packageGrossMass)
            ->setPackageNetMass($packageNetMass)
            ->setItemsPerPackage($itemsPerPackage)
            ->setImportOptions($importOptions)
            ->setUseQtyAsTotals($useQtyAsTotals)
            ->setGoodsOwner($goodsOwner)
            ->setProducts($products);
    }
    /**
     * Get PackageId value
     * @return string|null
     */
    public function getPackageId()
    {
        return $this->PackageId;
    }
    /**
     * Set PackageId value
     * @param string $packageId
     * @return \LectorSOAP\StructType\Package
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: string
        if (!is_null($packageId) && !is_string($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($packageId) && mb_strlen($packageId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($packageId)), __LINE__);
        }
        $this->PackageId = $packageId;
        return $this;
    }
    /**
     * Get PackageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->PackageType;
    }
    /**
     * Set PackageType value
     * @param string $packageType
     * @return \LectorSOAP\StructType\Package
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageType, true), gettype($packageType)), __LINE__);
        }
        $this->PackageType = $packageType;
        return $this;
    }
    /**
     * Get PackageSKU value
     * @return string|null
     */
    public function getPackageSKU()
    {
        return $this->PackageSKU;
    }
    /**
     * Set PackageSKU value
     * @param string $packageSKU
     * @return \LectorSOAP\StructType\Package
     */
    public function setPackageSKU($packageSKU = null)
    {
        // validation for constraint: string
        if (!is_null($packageSKU) && !is_string($packageSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageSKU, true), gettype($packageSKU)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($packageSKU) && mb_strlen($packageSKU) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($packageSKU)), __LINE__);
        }
        $this->PackageSKU = $packageSKU;
        return $this;
    }
    /**
     * Get PackageQty value
     * @return int|null
     */
    public function getPackageQty()
    {
        return $this->PackageQty;
    }
    /**
     * Set PackageQty value
     * @param int $packageQty
     * @return \LectorSOAP\StructType\Package
     */
    public function setPackageQty($packageQty = null)
    {
        // validation for constraint: int
        if (!is_null($packageQty) && !(is_int($packageQty) || ctype_digit($packageQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageQty, true), gettype($packageQty)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($packageQty) && $packageQty < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($packageQty, true)), __LINE__);
        }
        $this->PackageQty = $packageQty;
        return $this;
    }
    /**
     * Get PackageGrossMass value
     * @return float|null
     */
    public function getPackageGrossMass()
    {
        return $this->PackageGrossMass;
    }
    /**
     * Set PackageGrossMass value
     * @param float $packageGrossMass
     * @return \LectorSOAP\StructType\Package
     */
    public function setPackageGrossMass($packageGrossMass = 0)
    {
        // validation for constraint: float
        if (!is_null($packageGrossMass) && !(is_float($packageGrossMass) || is_numeric($packageGrossMass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($packageGrossMass, true), gettype($packageGrossMass)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($packageGrossMass) && $packageGrossMass < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($packageGrossMass, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($packageGrossMass) && !preg_match('/[0-9]*[.]?[0-9]+/', $packageGrossMass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($packageGrossMass, true)), __LINE__);
        }
        $this->PackageGrossMass = $packageGrossMass;
        return $this;
    }
    /**
     * Get PackageNetMass value
     * @return float|null
     */
    public function getPackageNetMass()
    {
        return $this->PackageNetMass;
    }
    /**
     * Set PackageNetMass value
     * @param float $packageNetMass
     * @return \LectorSOAP\StructType\Package
     */
    public function setPackageNetMass($packageNetMass = 0)
    {
        // validation for constraint: float
        if (!is_null($packageNetMass) && !(is_float($packageNetMass) || is_numeric($packageNetMass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($packageNetMass, true), gettype($packageNetMass)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($packageNetMass) && $packageNetMass < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($packageNetMass, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($packageNetMass) && !preg_match('/[0-9]*[.]?[0-9]+/', $packageNetMass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($packageNetMass, true)), __LINE__);
        }
        $this->PackageNetMass = $packageNetMass;
        return $this;
    }
    /**
     * Get ItemsPerPackage value
     * @return float|null
     */
    public function getItemsPerPackage()
    {
        return $this->ItemsPerPackage;
    }
    /**
     * Set ItemsPerPackage value
     * @param float $itemsPerPackage
     * @return \LectorSOAP\StructType\Package
     */
    public function setItemsPerPackage($itemsPerPackage = null)
    {
        // validation for constraint: float
        if (!is_null($itemsPerPackage) && !(is_float($itemsPerPackage) || is_numeric($itemsPerPackage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemsPerPackage, true), gettype($itemsPerPackage)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($itemsPerPackage) && $itemsPerPackage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($itemsPerPackage, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*[.]?[0-9]+)
        if (!is_null($itemsPerPackage) && !preg_match('/[0-9]*[.]?[0-9]+/', $itemsPerPackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*[.]?[0-9]+', var_export($itemsPerPackage, true)), __LINE__);
        }
        $this->ItemsPerPackage = $itemsPerPackage;
        return $this;
    }
    /**
     * Get ImportOptions value
     * @return string|null
     */
    public function getImportOptions()
    {
        return $this->ImportOptions;
    }
    /**
     * Set ImportOptions value
     * @param string $importOptions
     * @return \LectorSOAP\StructType\Package
     */
    public function setImportOptions($importOptions = null)
    {
        // validation for constraint: string
        if (!is_null($importOptions) && !is_string($importOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importOptions, true), gettype($importOptions)), __LINE__);
        }
        $this->ImportOptions = $importOptions;
        return $this;
    }
    /**
     * Get UseQtyAsTotals value
     * @return string|null
     */
    public function getUseQtyAsTotals()
    {
        return $this->UseQtyAsTotals;
    }
    /**
     * Set UseQtyAsTotals value
     * @param string $useQtyAsTotals
     * @return \LectorSOAP\StructType\Package
     */
    public function setUseQtyAsTotals($useQtyAsTotals = null)
    {
        // validation for constraint: string
        if (!is_null($useQtyAsTotals) && !is_string($useQtyAsTotals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useQtyAsTotals, true), gettype($useQtyAsTotals)), __LINE__);
        }
        // validation for constraint: pattern([YN])
        if (!is_null($useQtyAsTotals) && !preg_match('/[YN]/', $useQtyAsTotals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [YN]', var_export($useQtyAsTotals, true)), __LINE__);
        }
        $this->UseQtyAsTotals = $useQtyAsTotals;
        return $this;
    }
    /**
     * Get GoodsOwner value
     * @return \LectorSOAP\StructType\TradingPartner|null
     */
    public function getGoodsOwner()
    {
        return $this->GoodsOwner;
    }
    /**
     * Set GoodsOwner value
     * @param \LectorSOAP\StructType\TradingPartner $goodsOwner
     * @return \LectorSOAP\StructType\Package
     */
    public function setGoodsOwner(\LectorSOAP\StructType\TradingPartner $goodsOwner = null)
    {
        $this->GoodsOwner = $goodsOwner;
        return $this;
    }
    /**
     * Get Products value
     * @return \LectorSOAP\StructType\Products|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \LectorSOAP\StructType\Products $products
     * @return \LectorSOAP\StructType\Package
     */
    public function setProducts(\LectorSOAP\StructType\Products $products = null)
    {
        $this->Products = $products;
        return $this;
    }
}
