<?php

namespace LectorSOAP\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @subpackage Services
 */
class Upload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named uploadInbound
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LectorSOAP\StructType\UploadInboundRequest $uploadInboundRequest
     * @return \LectorSOAP\StructType\UploadInboundResponse|bool
     */
    public function uploadInbound(\LectorSOAP\StructType\UploadInboundRequest $uploadInboundRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->uploadInbound($uploadInboundRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LectorSOAP\StructType\UploadInboundResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
