<?php

namespace LectorSOAP\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ValueComponentType EnumType
 * @subpackage Enumerations
 */
class ValueComponentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PURCHASE_AMOUNT'
     * Meta information extracted from the WSDL
     * - documentation: The total purchase price of all items on the declaration
     * @return string 'PURCHASE_AMOUNT'
     */
    const VALUE_PURCHASE_AMOUNT = 'PURCHASE_AMOUNT';
    /**
     * Constant for value 'INVOICE_AMOUNT'
     * Meta information extracted from the WSDL
     * - documentation: The calculated invoice amount, that is sent to customs. Will either be a copy of purchase amount (if no invoice amount has been typed on the declaration header), or calculated as "LineInvoiceAmount = TotalInvoiceAmount /
     * TotalPurchaseAmount * LinePurchaseAmount".
     * @return string 'INVOICE_AMOUNT'
     */
    const VALUE_INVOICE_AMOUNT = 'INVOICE_AMOUNT';
    /**
     * Constant for value 'ALLOWANCE_AMOUNT'
     * Meta information extracted from the WSDL
     * - documentation: The calculated allowance amount, which may or may not be documented on the commercial invoice, and should be subtracted from the invoice amount and is therefore not included in the statistical value. Calculated as
     * "LineAllowanceAmount = TotalAllowanceAmount / TotalPurchaseAmount * LinePurchaseAmount".
     * @return string 'ALLOWANCE_AMOUNT'
     */
    const VALUE_ALLOWANCE_AMOUNT = 'ALLOWANCE_AMOUNT';
    /**
     * Constant for value 'ADDITIONAL_PRODUCT_VALUE'
     * Meta information extracted from the WSDL
     * - documentation: This includes any values that should be part of the statistical value, but is not necessarily included in the commercial invoice. - e.g. moulds created for the production process or royalties paid to someone other than the
     * manufacturer.
     * @return string 'ADDITIONAL_PRODUCT_VALUE'
     */
    const VALUE_ADDITIONAL_PRODUCT_VALUE = 'ADDITIONAL_PRODUCT_VALUE';
    /**
     * Constant for value 'ADDITIONAL_PRODUCT_VALUE_ADJ'
     * Meta information extracted from the WSDL
     * - documentation: For royalty-fees etc. that depend on the invoice amount, rather than the purchase amount, this component will contain any differences between the two.
     * @return string 'ADDITIONAL_PRODUCT_VALUE_ADJ'
     */
    const VALUE_ADDITIONAL_PRODUCT_VALUE_ADJ = 'ADDITIONAL_PRODUCT_VALUE_ADJ';
    /**
     * Constant for value 'INSURANCE'
     * Meta information extracted from the WSDL
     * - documentation: Insurance may be included in statistical value. It is calculated as a fixed percentage of the invoice amount.
     * @return string 'INSURANCE'
     */
    const VALUE_INSURANCE = 'INSURANCE';
    /**
     * Constant for value 'FREIGHT'
     * Meta information extracted from the WSDL
     * - documentation: Any non-eu freight should be included in statistical value (entered on main declaration). Calculated as "LineFreight = TotalFreight / TotalColli * LineColli".
     * @return string 'FREIGHT'
     */
    const VALUE_FREIGHT = 'FREIGHT';
    /**
     * Constant for value 'FREIGHT_DISCOUNT'
     * Meta information extracted from the WSDL
     * - documentation: It is calculated as a fixed percentage of the Non-EU freight amount.
     * @return string 'FREIGHT_DISCOUNT'
     */
    const VALUE_FREIGHT_DISCOUNT = 'FREIGHT_DISCOUNT';
    /**
     * Constant for value 'EU_FREIGHT'
     * Meta information extracted from the WSDL
     * - documentation: The freight costs within the EU. Note this value is not part of the statistical value calculation.
     * @return string 'EU_FREIGHT'
     */
    const VALUE_EU_FREIGHT = 'EU_FREIGHT';
    /**
     * Constant for value 'ADDITIONAL_PRODUCT_VALUE_SALE'
     * Meta information extracted from the WSDL
     * - documentation: This includes the value adjustment when doing inward porcessing. For reimport, it will also include extra freight to and from the processing
     * @return string 'ADDITIONAL_PRODUCT_VALUE_SALE'
     */
    const VALUE_ADDITIONAL_PRODUCT_VALUE_SALE = 'ADDITIONAL_PRODUCT_VALUE_SALE';
    /**
     * Constant for value 'PRO_RATA'
     * Meta information extracted from the WSDL
     * - documentation: The calculated value that these pieces represent, based on the value and number of pieces of the entire record of the import declaration. Calculated as "CclValue = ImportRecordValue / ImportRecordQuantity * CclQuantity".
     * @return string 'PRO_RATA'
     */
    const VALUE_PRO_RATA = 'PRO_RATA';
    /**
     * Constant for value 'INWARD_PROCESSING_VALUE'
     * Meta information extracted from the WSDL
     * - documentation: This includes the value adjustment when doing inward porcessing. For reimport, it will also include extra freight to and from the processing plant.
     * @return string 'INWARD_PROCESSING_VALUE'
     */
    const VALUE_INWARD_PROCESSING_VALUE = 'INWARD_PROCESSING_VALUE';
    /**
     * Return allowed values
     * @uses self::VALUE_PURCHASE_AMOUNT
     * @uses self::VALUE_INVOICE_AMOUNT
     * @uses self::VALUE_ALLOWANCE_AMOUNT
     * @uses self::VALUE_ADDITIONAL_PRODUCT_VALUE
     * @uses self::VALUE_ADDITIONAL_PRODUCT_VALUE_ADJ
     * @uses self::VALUE_INSURANCE
     * @uses self::VALUE_FREIGHT
     * @uses self::VALUE_FREIGHT_DISCOUNT
     * @uses self::VALUE_EU_FREIGHT
     * @uses self::VALUE_ADDITIONAL_PRODUCT_VALUE_SALE
     * @uses self::VALUE_PRO_RATA
     * @uses self::VALUE_INWARD_PROCESSING_VALUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PURCHASE_AMOUNT,
            self::VALUE_INVOICE_AMOUNT,
            self::VALUE_ALLOWANCE_AMOUNT,
            self::VALUE_ADDITIONAL_PRODUCT_VALUE,
            self::VALUE_ADDITIONAL_PRODUCT_VALUE_ADJ,
            self::VALUE_INSURANCE,
            self::VALUE_FREIGHT,
            self::VALUE_FREIGHT_DISCOUNT,
            self::VALUE_EU_FREIGHT,
            self::VALUE_ADDITIONAL_PRODUCT_VALUE_SALE,
            self::VALUE_PRO_RATA,
            self::VALUE_INWARD_PROCESSING_VALUE,
        );
    }
}
