<?php

namespace LectorSOAP;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'uploadInboundRequest' => '\\LectorSOAP\\StructType\\UploadInboundRequest',
            'uploadInboundResponse' => '\\LectorSOAP\\StructType\\UploadInboundResponse',
            'InterfaceHeader' => '\\LectorSOAP\\StructType\\InterfaceHeader',
            'Inbound' => '\\LectorSOAP\\StructType\\Inbound',
            'InboundCargo' => '\\LectorSOAP\\StructType\\InboundCargo',
            'PurchaseOrders' => '\\LectorSOAP\\StructType\\PurchaseOrders',
            'PurchaseOrder' => '\\LectorSOAP\\StructType\\PurchaseOrder',
            'Packaging' => '\\LectorSOAP\\StructType\\Packaging',
            'Package' => '\\LectorSOAP\\StructType\\Package',
            'PreferenceSummary' => '\\LectorSOAP\\StructType\\PreferenceSummary',
            'Preference' => '\\LectorSOAP\\StructType\\Preference',
            'InboundDocuments' => '\\LectorSOAP\\StructType\\InboundDocuments',
            'SupplierDocuments' => '\\LectorSOAP\\StructType\\SupplierDocuments',
            'Document' => '\\LectorSOAP\\StructType\\Document',
            'Products' => '\\LectorSOAP\\StructType\\Products',
            'Product' => '\\LectorSOAP\\StructType\\Product',
            'Variants' => '\\LectorSOAP\\StructType\\Variants',
            'Variant' => '\\LectorSOAP\\StructType\\Variant',
            'AdditionalCustomsValues' => '\\LectorSOAP\\StructType\\AdditionalCustomsValues',
            'AdditionalCustomsValue' => '\\LectorSOAP\\StructType\\AdditionalCustomsValue',
            'AdditionalProductAttributes' => '\\LectorSOAP\\StructType\\AdditionalProductAttributes',
            'AdditionalProductAttribute' => '\\LectorSOAP\\StructType\\AdditionalProductAttribute',
            'TradingPartner' => '\\LectorSOAP\\StructType\\TradingPartner',
        );
    }
}
