<?php

namespace rx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @author  Rishiraj Purohit
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetWeather
     * Meta informations extracted from the WSDL
     * - documentation: Get weather report for all major cities around the world. | Get weather report for all major cities around the world. | Get weather report for all major cities around the world.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rx\StructType\GetWeather $parameters
     * @return \rx\StructType\GetWeatherResponse|bool
     */
    public function GetWeather(\rx\StructType\GetWeather $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWeather($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCitiesByCountry
     * Meta informations extracted from the WSDL
     * - documentation: Get all major cities by country name(full / part). | Get all major cities by country name(full / part). | Get all major cities by country name(full / part).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rx\StructType\GetCitiesByCountry $parameters
     * @return \rx\StructType\GetCitiesByCountryResponse|bool
     */
    public function GetCitiesByCountry(\rx\StructType\GetCitiesByCountry $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCitiesByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \rx\StructType\GetCitiesByCountryResponse|\rx\StructType\GetWeatherResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
