<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSSerieVO StructType
 * @subpackage Structs
 */
class WSSerieVO extends AbstractStructBase
{
    /**
     * The anoFim
     * @var int
     */
    public $anoFim;
    /**
     * The anoInicio
     * @var int
     */
    public $anoInicio;
    /**
     * The aviso
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $aviso;
    /**
     * The diaFim
     * @var int
     */
    public $diaFim;
    /**
     * The diaInicio
     * @var int
     */
    public $diaInicio;
    /**
     * The especial
     * @var bool
     */
    public $especial;
    /**
     * The fonte
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fonte;
    /**
     * The fullName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fullName;
    /**
     * The gestorProprietario
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $gestorProprietario;
    /**
     * The mesFim
     * @var int
     */
    public $mesFim;
    /**
     * The mesInicio
     * @var int
     */
    public $mesInicio;
    /**
     * The nomeAbreviado
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nomeAbreviado;
    /**
     * The nomeCompleto
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nomeCompleto;
    /**
     * The oid
     * @var int
     */
    public $oid;
    /**
     * The periodicidade
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $periodicidade;
    /**
     * The periodicidadeSigla
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $periodicidadeSigla;
    /**
     * The possuiBloqueios
     * @var bool
     */
    public $possuiBloqueios;
    /**
     * The publica
     * @var bool
     */
    public $publica;
    /**
     * The shortName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shortName;
    /**
     * The ultimoValor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\WSValorSerieVO
     */
    public $ultimoValor;
    /**
     * The unidadePadrao
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $unidadePadrao;
    /**
     * The unidadePadraoIngles
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $unidadePadraoIngles;
    /**
     * The valorDiaNaoUtil
     * @var bool
     */
    public $valorDiaNaoUtil;
    /**
     * The valores
     * Meta information extracted from the WSDL
     * - arrayType: tns2:WSValorSerieVO[]
     * - base: soapenc:Array
     * - nillable: true
     * - ref: soapenc:arrayType
     * @var \StructType\WSValorSerieVO[]
     */
    public $valores;
    /**
     * Constructor method for WSSerieVO
     * @uses WSSerieVO::setAnoFim()
     * @uses WSSerieVO::setAnoInicio()
     * @uses WSSerieVO::setAviso()
     * @uses WSSerieVO::setDiaFim()
     * @uses WSSerieVO::setDiaInicio()
     * @uses WSSerieVO::setEspecial()
     * @uses WSSerieVO::setFonte()
     * @uses WSSerieVO::setFullName()
     * @uses WSSerieVO::setGestorProprietario()
     * @uses WSSerieVO::setMesFim()
     * @uses WSSerieVO::setMesInicio()
     * @uses WSSerieVO::setNomeAbreviado()
     * @uses WSSerieVO::setNomeCompleto()
     * @uses WSSerieVO::setOid()
     * @uses WSSerieVO::setPeriodicidade()
     * @uses WSSerieVO::setPeriodicidadeSigla()
     * @uses WSSerieVO::setPossuiBloqueios()
     * @uses WSSerieVO::setPublica()
     * @uses WSSerieVO::setShortName()
     * @uses WSSerieVO::setUltimoValor()
     * @uses WSSerieVO::setUnidadePadrao()
     * @uses WSSerieVO::setUnidadePadraoIngles()
     * @uses WSSerieVO::setValorDiaNaoUtil()
     * @uses WSSerieVO::setValores()
     * @param int $anoFim
     * @param int $anoInicio
     * @param string $aviso
     * @param int $diaFim
     * @param int $diaInicio
     * @param bool $especial
     * @param string $fonte
     * @param string $fullName
     * @param string $gestorProprietario
     * @param int $mesFim
     * @param int $mesInicio
     * @param string $nomeAbreviado
     * @param string $nomeCompleto
     * @param int $oid
     * @param string $periodicidade
     * @param string $periodicidadeSigla
     * @param bool $possuiBloqueios
     * @param bool $publica
     * @param string $shortName
     * @param \StructType\WSValorSerieVO $ultimoValor
     * @param string $unidadePadrao
     * @param string $unidadePadraoIngles
     * @param bool $valorDiaNaoUtil
     * @param \StructType\WSValorSerieVO[] $valores
     */
    public function __construct($anoFim = null, $anoInicio = null, $aviso = null, $diaFim = null, $diaInicio = null, $especial = null, $fonte = null, $fullName = null, $gestorProprietario = null, $mesFim = null, $mesInicio = null, $nomeAbreviado = null, $nomeCompleto = null, $oid = null, $periodicidade = null, $periodicidadeSigla = null, $possuiBloqueios = null, $publica = null, $shortName = null, \StructType\WSValorSerieVO $ultimoValor = null, $unidadePadrao = null, $unidadePadraoIngles = null, $valorDiaNaoUtil = null, array $valores = array())
    {
        $this
            ->setAnoFim($anoFim)
            ->setAnoInicio($anoInicio)
            ->setAviso($aviso)
            ->setDiaFim($diaFim)
            ->setDiaInicio($diaInicio)
            ->setEspecial($especial)
            ->setFonte($fonte)
            ->setFullName($fullName)
            ->setGestorProprietario($gestorProprietario)
            ->setMesFim($mesFim)
            ->setMesInicio($mesInicio)
            ->setNomeAbreviado($nomeAbreviado)
            ->setNomeCompleto($nomeCompleto)
            ->setOid($oid)
            ->setPeriodicidade($periodicidade)
            ->setPeriodicidadeSigla($periodicidadeSigla)
            ->setPossuiBloqueios($possuiBloqueios)
            ->setPublica($publica)
            ->setShortName($shortName)
            ->setUltimoValor($ultimoValor)
            ->setUnidadePadrao($unidadePadrao)
            ->setUnidadePadraoIngles($unidadePadraoIngles)
            ->setValorDiaNaoUtil($valorDiaNaoUtil)
            ->setValores($valores);
    }
    /**
     * Get anoFim value
     * @return int|null
     */
    public function getAnoFim()
    {
        return $this->anoFim;
    }
    /**
     * Set anoFim value
     * @param int $anoFim
     * @return \StructType\WSSerieVO
     */
    public function setAnoFim($anoFim = null)
    {
        // validation for constraint: int
        if (!is_null($anoFim) && !(is_int($anoFim) || ctype_digit($anoFim))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anoFim, true), gettype($anoFim)), __LINE__);
        }
        $this->anoFim = $anoFim;
        return $this;
    }
    /**
     * Get anoInicio value
     * @return int|null
     */
    public function getAnoInicio()
    {
        return $this->anoInicio;
    }
    /**
     * Set anoInicio value
     * @param int $anoInicio
     * @return \StructType\WSSerieVO
     */
    public function setAnoInicio($anoInicio = null)
    {
        // validation for constraint: int
        if (!is_null($anoInicio) && !(is_int($anoInicio) || ctype_digit($anoInicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anoInicio, true), gettype($anoInicio)), __LINE__);
        }
        $this->anoInicio = $anoInicio;
        return $this;
    }
    /**
     * Get aviso value
     * @return string|null
     */
    public function getAviso()
    {
        return $this->aviso;
    }
    /**
     * Set aviso value
     * @param string $aviso
     * @return \StructType\WSSerieVO
     */
    public function setAviso($aviso = null)
    {
        // validation for constraint: string
        if (!is_null($aviso) && !is_string($aviso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aviso, true), gettype($aviso)), __LINE__);
        }
        $this->aviso = $aviso;
        return $this;
    }
    /**
     * Get diaFim value
     * @return int|null
     */
    public function getDiaFim()
    {
        return $this->diaFim;
    }
    /**
     * Set diaFim value
     * @param int $diaFim
     * @return \StructType\WSSerieVO
     */
    public function setDiaFim($diaFim = null)
    {
        // validation for constraint: int
        if (!is_null($diaFim) && !(is_int($diaFim) || ctype_digit($diaFim))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($diaFim, true), gettype($diaFim)), __LINE__);
        }
        $this->diaFim = $diaFim;
        return $this;
    }
    /**
     * Get diaInicio value
     * @return int|null
     */
    public function getDiaInicio()
    {
        return $this->diaInicio;
    }
    /**
     * Set diaInicio value
     * @param int $diaInicio
     * @return \StructType\WSSerieVO
     */
    public function setDiaInicio($diaInicio = null)
    {
        // validation for constraint: int
        if (!is_null($diaInicio) && !(is_int($diaInicio) || ctype_digit($diaInicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($diaInicio, true), gettype($diaInicio)), __LINE__);
        }
        $this->diaInicio = $diaInicio;
        return $this;
    }
    /**
     * Get especial value
     * @return bool|null
     */
    public function getEspecial()
    {
        return $this->especial;
    }
    /**
     * Set especial value
     * @param bool $especial
     * @return \StructType\WSSerieVO
     */
    public function setEspecial($especial = null)
    {
        // validation for constraint: boolean
        if (!is_null($especial) && !is_bool($especial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($especial, true), gettype($especial)), __LINE__);
        }
        $this->especial = $especial;
        return $this;
    }
    /**
     * Get fonte value
     * @return string|null
     */
    public function getFonte()
    {
        return $this->fonte;
    }
    /**
     * Set fonte value
     * @param string $fonte
     * @return \StructType\WSSerieVO
     */
    public function setFonte($fonte = null)
    {
        // validation for constraint: string
        if (!is_null($fonte) && !is_string($fonte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fonte, true), gettype($fonte)), __LINE__);
        }
        $this->fonte = $fonte;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\WSSerieVO
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get gestorProprietario value
     * @return string|null
     */
    public function getGestorProprietario()
    {
        return $this->gestorProprietario;
    }
    /**
     * Set gestorProprietario value
     * @param string $gestorProprietario
     * @return \StructType\WSSerieVO
     */
    public function setGestorProprietario($gestorProprietario = null)
    {
        // validation for constraint: string
        if (!is_null($gestorProprietario) && !is_string($gestorProprietario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gestorProprietario, true), gettype($gestorProprietario)), __LINE__);
        }
        $this->gestorProprietario = $gestorProprietario;
        return $this;
    }
    /**
     * Get mesFim value
     * @return int|null
     */
    public function getMesFim()
    {
        return $this->mesFim;
    }
    /**
     * Set mesFim value
     * @param int $mesFim
     * @return \StructType\WSSerieVO
     */
    public function setMesFim($mesFim = null)
    {
        // validation for constraint: int
        if (!is_null($mesFim) && !(is_int($mesFim) || ctype_digit($mesFim))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mesFim, true), gettype($mesFim)), __LINE__);
        }
        $this->mesFim = $mesFim;
        return $this;
    }
    /**
     * Get mesInicio value
     * @return int|null
     */
    public function getMesInicio()
    {
        return $this->mesInicio;
    }
    /**
     * Set mesInicio value
     * @param int $mesInicio
     * @return \StructType\WSSerieVO
     */
    public function setMesInicio($mesInicio = null)
    {
        // validation for constraint: int
        if (!is_null($mesInicio) && !(is_int($mesInicio) || ctype_digit($mesInicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mesInicio, true), gettype($mesInicio)), __LINE__);
        }
        $this->mesInicio = $mesInicio;
        return $this;
    }
    /**
     * Get nomeAbreviado value
     * @return string|null
     */
    public function getNomeAbreviado()
    {
        return $this->nomeAbreviado;
    }
    /**
     * Set nomeAbreviado value
     * @param string $nomeAbreviado
     * @return \StructType\WSSerieVO
     */
    public function setNomeAbreviado($nomeAbreviado = null)
    {
        // validation for constraint: string
        if (!is_null($nomeAbreviado) && !is_string($nomeAbreviado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeAbreviado, true), gettype($nomeAbreviado)), __LINE__);
        }
        $this->nomeAbreviado = $nomeAbreviado;
        return $this;
    }
    /**
     * Get nomeCompleto value
     * @return string|null
     */
    public function getNomeCompleto()
    {
        return $this->nomeCompleto;
    }
    /**
     * Set nomeCompleto value
     * @param string $nomeCompleto
     * @return \StructType\WSSerieVO
     */
    public function setNomeCompleto($nomeCompleto = null)
    {
        // validation for constraint: string
        if (!is_null($nomeCompleto) && !is_string($nomeCompleto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeCompleto, true), gettype($nomeCompleto)), __LINE__);
        }
        $this->nomeCompleto = $nomeCompleto;
        return $this;
    }
    /**
     * Get oid value
     * @return int|null
     */
    public function getOid()
    {
        return $this->oid;
    }
    /**
     * Set oid value
     * @param int $oid
     * @return \StructType\WSSerieVO
     */
    public function setOid($oid = null)
    {
        // validation for constraint: int
        if (!is_null($oid) && !(is_int($oid) || ctype_digit($oid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oid, true), gettype($oid)), __LINE__);
        }
        $this->oid = $oid;
        return $this;
    }
    /**
     * Get periodicidade value
     * @return string|null
     */
    public function getPeriodicidade()
    {
        return $this->periodicidade;
    }
    /**
     * Set periodicidade value
     * @param string $periodicidade
     * @return \StructType\WSSerieVO
     */
    public function setPeriodicidade($periodicidade = null)
    {
        // validation for constraint: string
        if (!is_null($periodicidade) && !is_string($periodicidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodicidade, true), gettype($periodicidade)), __LINE__);
        }
        $this->periodicidade = $periodicidade;
        return $this;
    }
    /**
     * Get periodicidadeSigla value
     * @return string|null
     */
    public function getPeriodicidadeSigla()
    {
        return $this->periodicidadeSigla;
    }
    /**
     * Set periodicidadeSigla value
     * @param string $periodicidadeSigla
     * @return \StructType\WSSerieVO
     */
    public function setPeriodicidadeSigla($periodicidadeSigla = null)
    {
        // validation for constraint: string
        if (!is_null($periodicidadeSigla) && !is_string($periodicidadeSigla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodicidadeSigla, true), gettype($periodicidadeSigla)), __LINE__);
        }
        $this->periodicidadeSigla = $periodicidadeSigla;
        return $this;
    }
    /**
     * Get possuiBloqueios value
     * @return bool|null
     */
    public function getPossuiBloqueios()
    {
        return $this->possuiBloqueios;
    }
    /**
     * Set possuiBloqueios value
     * @param bool $possuiBloqueios
     * @return \StructType\WSSerieVO
     */
    public function setPossuiBloqueios($possuiBloqueios = null)
    {
        // validation for constraint: boolean
        if (!is_null($possuiBloqueios) && !is_bool($possuiBloqueios)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($possuiBloqueios, true), gettype($possuiBloqueios)), __LINE__);
        }
        $this->possuiBloqueios = $possuiBloqueios;
        return $this;
    }
    /**
     * Get publica value
     * @return bool|null
     */
    public function getPublica()
    {
        return $this->publica;
    }
    /**
     * Set publica value
     * @param bool $publica
     * @return \StructType\WSSerieVO
     */
    public function setPublica($publica = null)
    {
        // validation for constraint: boolean
        if (!is_null($publica) && !is_bool($publica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($publica, true), gettype($publica)), __LINE__);
        }
        $this->publica = $publica;
        return $this;
    }
    /**
     * Get shortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->shortName;
    }
    /**
     * Set shortName value
     * @param string $shortName
     * @return \StructType\WSSerieVO
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortName, true), gettype($shortName)), __LINE__);
        }
        $this->shortName = $shortName;
        return $this;
    }
    /**
     * Get ultimoValor value
     * @return \StructType\WSValorSerieVO|null
     */
    public function getUltimoValor()
    {
        return $this->ultimoValor;
    }
    /**
     * Set ultimoValor value
     * @param \StructType\WSValorSerieVO $ultimoValor
     * @return \StructType\WSSerieVO
     */
    public function setUltimoValor(\StructType\WSValorSerieVO $ultimoValor = null)
    {
        $this->ultimoValor = $ultimoValor;
        return $this;
    }
    /**
     * Get unidadePadrao value
     * @return string|null
     */
    public function getUnidadePadrao()
    {
        return $this->unidadePadrao;
    }
    /**
     * Set unidadePadrao value
     * @param string $unidadePadrao
     * @return \StructType\WSSerieVO
     */
    public function setUnidadePadrao($unidadePadrao = null)
    {
        // validation for constraint: string
        if (!is_null($unidadePadrao) && !is_string($unidadePadrao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unidadePadrao, true), gettype($unidadePadrao)), __LINE__);
        }
        $this->unidadePadrao = $unidadePadrao;
        return $this;
    }
    /**
     * Get unidadePadraoIngles value
     * @return string|null
     */
    public function getUnidadePadraoIngles()
    {
        return $this->unidadePadraoIngles;
    }
    /**
     * Set unidadePadraoIngles value
     * @param string $unidadePadraoIngles
     * @return \StructType\WSSerieVO
     */
    public function setUnidadePadraoIngles($unidadePadraoIngles = null)
    {
        // validation for constraint: string
        if (!is_null($unidadePadraoIngles) && !is_string($unidadePadraoIngles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unidadePadraoIngles, true), gettype($unidadePadraoIngles)), __LINE__);
        }
        $this->unidadePadraoIngles = $unidadePadraoIngles;
        return $this;
    }
    /**
     * Get valorDiaNaoUtil value
     * @return bool|null
     */
    public function getValorDiaNaoUtil()
    {
        return $this->valorDiaNaoUtil;
    }
    /**
     * Set valorDiaNaoUtil value
     * @param bool $valorDiaNaoUtil
     * @return \StructType\WSSerieVO
     */
    public function setValorDiaNaoUtil($valorDiaNaoUtil = null)
    {
        // validation for constraint: boolean
        if (!is_null($valorDiaNaoUtil) && !is_bool($valorDiaNaoUtil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valorDiaNaoUtil, true), gettype($valorDiaNaoUtil)), __LINE__);
        }
        $this->valorDiaNaoUtil = $valorDiaNaoUtil;
        return $this;
    }
    /**
     * Get valores value
     * @return \StructType\WSValorSerieVO[]|null
     */
    public function getValores()
    {
        return $this->valores;
    }
    /**
     * This method is responsible for validating the values passed to the setValores method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValores method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValoresForArrayConstraintsFromSetValores(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $wSSerieVOValoresItem) {
            // validation for constraint: itemType
            if (!$wSSerieVOValoresItem instanceof \StructType\WSValorSerieVO) {
                $invalidValues[] = is_object($wSSerieVOValoresItem) ? get_class($wSSerieVOValoresItem) : sprintf('%s(%s)', gettype($wSSerieVOValoresItem), var_export($wSSerieVOValoresItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The valores property can only contain items of type \StructType\WSValorSerieVO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set valores value
     * @throws \InvalidArgumentException
     * @param \StructType\WSValorSerieVO[] $valores
     * @return \StructType\WSSerieVO
     */
    public function setValores(array $valores = array())
    {
        // validation for constraint: array
        if ('' !== ($valoresArrayErrorMessage = self::validateValoresForArrayConstraintsFromSetValores($valores))) {
            throw new \InvalidArgumentException($valoresArrayErrorMessage, __LINE__);
        }
        $this->valores = $valores;
        return $this;
    }
    /**
     * Add item to valores value
     * @throws \InvalidArgumentException
     * @param \StructType\WSValorSerieVO $item
     * @return \StructType\WSSerieVO
     */
    public function addToValores(\StructType\WSValorSerieVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSValorSerieVO) {
            throw new \InvalidArgumentException(sprintf('The valores property can only contain items of type \StructType\WSValorSerieVO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->valores[] = $item;
        return $this;
    }
}
