<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSValorSerieVO StructType
 * @subpackage Structs
 */
class WSValorSerieVO extends AbstractStructBase
{
    /**
     * The ano
     * @var int
     */
    public $ano;
    /**
     * The anoFim
     * @var int
     */
    public $anoFim;
    /**
     * The bloqueado
     * @var bool
     */
    public $bloqueado;
    /**
     * The bloqueioLiberado
     * @var bool
     */
    public $bloqueioLiberado;
    /**
     * The dia
     * @var int
     */
    public $dia;
    /**
     * The diaFim
     * @var int
     */
    public $diaFim;
    /**
     * The mes
     * @var int
     */
    public $mes;
    /**
     * The mesFim
     * @var int
     */
    public $mesFim;
    /**
     * The oid
     * @var int
     */
    public $oid;
    /**
     * The oidSerie
     * @var int
     */
    public $oidSerie;
    /**
     * The svalor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $svalor;
    /**
     * The valor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $valor;
    /**
     * Constructor method for WSValorSerieVO
     * @uses WSValorSerieVO::setAno()
     * @uses WSValorSerieVO::setAnoFim()
     * @uses WSValorSerieVO::setBloqueado()
     * @uses WSValorSerieVO::setBloqueioLiberado()
     * @uses WSValorSerieVO::setDia()
     * @uses WSValorSerieVO::setDiaFim()
     * @uses WSValorSerieVO::setMes()
     * @uses WSValorSerieVO::setMesFim()
     * @uses WSValorSerieVO::setOid()
     * @uses WSValorSerieVO::setOidSerie()
     * @uses WSValorSerieVO::setSvalor()
     * @uses WSValorSerieVO::setValor()
     * @param int $ano
     * @param int $anoFim
     * @param bool $bloqueado
     * @param bool $bloqueioLiberado
     * @param int $dia
     * @param int $diaFim
     * @param int $mes
     * @param int $mesFim
     * @param int $oid
     * @param int $oidSerie
     * @param string $svalor
     * @param float $valor
     */
    public function __construct($ano = null, $anoFim = null, $bloqueado = null, $bloqueioLiberado = null, $dia = null, $diaFim = null, $mes = null, $mesFim = null, $oid = null, $oidSerie = null, $svalor = null, $valor = null)
    {
        $this
            ->setAno($ano)
            ->setAnoFim($anoFim)
            ->setBloqueado($bloqueado)
            ->setBloqueioLiberado($bloqueioLiberado)
            ->setDia($dia)
            ->setDiaFim($diaFim)
            ->setMes($mes)
            ->setMesFim($mesFim)
            ->setOid($oid)
            ->setOidSerie($oidSerie)
            ->setSvalor($svalor)
            ->setValor($valor);
    }
    /**
     * Get ano value
     * @return int|null
     */
    public function getAno()
    {
        return $this->ano;
    }
    /**
     * Set ano value
     * @param int $ano
     * @return \StructType\WSValorSerieVO
     */
    public function setAno($ano = null)
    {
        // validation for constraint: int
        if (!is_null($ano) && !(is_int($ano) || ctype_digit($ano))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ano, true), gettype($ano)), __LINE__);
        }
        $this->ano = $ano;
        return $this;
    }
    /**
     * Get anoFim value
     * @return int|null
     */
    public function getAnoFim()
    {
        return $this->anoFim;
    }
    /**
     * Set anoFim value
     * @param int $anoFim
     * @return \StructType\WSValorSerieVO
     */
    public function setAnoFim($anoFim = null)
    {
        // validation for constraint: int
        if (!is_null($anoFim) && !(is_int($anoFim) || ctype_digit($anoFim))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anoFim, true), gettype($anoFim)), __LINE__);
        }
        $this->anoFim = $anoFim;
        return $this;
    }
    /**
     * Get bloqueado value
     * @return bool|null
     */
    public function getBloqueado()
    {
        return $this->bloqueado;
    }
    /**
     * Set bloqueado value
     * @param bool $bloqueado
     * @return \StructType\WSValorSerieVO
     */
    public function setBloqueado($bloqueado = null)
    {
        // validation for constraint: boolean
        if (!is_null($bloqueado) && !is_bool($bloqueado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bloqueado, true), gettype($bloqueado)), __LINE__);
        }
        $this->bloqueado = $bloqueado;
        return $this;
    }
    /**
     * Get bloqueioLiberado value
     * @return bool|null
     */
    public function getBloqueioLiberado()
    {
        return $this->bloqueioLiberado;
    }
    /**
     * Set bloqueioLiberado value
     * @param bool $bloqueioLiberado
     * @return \StructType\WSValorSerieVO
     */
    public function setBloqueioLiberado($bloqueioLiberado = null)
    {
        // validation for constraint: boolean
        if (!is_null($bloqueioLiberado) && !is_bool($bloqueioLiberado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bloqueioLiberado, true), gettype($bloqueioLiberado)), __LINE__);
        }
        $this->bloqueioLiberado = $bloqueioLiberado;
        return $this;
    }
    /**
     * Get dia value
     * @return int|null
     */
    public function getDia()
    {
        return $this->dia;
    }
    /**
     * Set dia value
     * @param int $dia
     * @return \StructType\WSValorSerieVO
     */
    public function setDia($dia = null)
    {
        // validation for constraint: int
        if (!is_null($dia) && !(is_int($dia) || ctype_digit($dia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dia, true), gettype($dia)), __LINE__);
        }
        $this->dia = $dia;
        return $this;
    }
    /**
     * Get diaFim value
     * @return int|null
     */
    public function getDiaFim()
    {
        return $this->diaFim;
    }
    /**
     * Set diaFim value
     * @param int $diaFim
     * @return \StructType\WSValorSerieVO
     */
    public function setDiaFim($diaFim = null)
    {
        // validation for constraint: int
        if (!is_null($diaFim) && !(is_int($diaFim) || ctype_digit($diaFim))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($diaFim, true), gettype($diaFim)), __LINE__);
        }
        $this->diaFim = $diaFim;
        return $this;
    }
    /**
     * Get mes value
     * @return int|null
     */
    public function getMes()
    {
        return $this->mes;
    }
    /**
     * Set mes value
     * @param int $mes
     * @return \StructType\WSValorSerieVO
     */
    public function setMes($mes = null)
    {
        // validation for constraint: int
        if (!is_null($mes) && !(is_int($mes) || ctype_digit($mes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mes, true), gettype($mes)), __LINE__);
        }
        $this->mes = $mes;
        return $this;
    }
    /**
     * Get mesFim value
     * @return int|null
     */
    public function getMesFim()
    {
        return $this->mesFim;
    }
    /**
     * Set mesFim value
     * @param int $mesFim
     * @return \StructType\WSValorSerieVO
     */
    public function setMesFim($mesFim = null)
    {
        // validation for constraint: int
        if (!is_null($mesFim) && !(is_int($mesFim) || ctype_digit($mesFim))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mesFim, true), gettype($mesFim)), __LINE__);
        }
        $this->mesFim = $mesFim;
        return $this;
    }
    /**
     * Get oid value
     * @return int|null
     */
    public function getOid()
    {
        return $this->oid;
    }
    /**
     * Set oid value
     * @param int $oid
     * @return \StructType\WSValorSerieVO
     */
    public function setOid($oid = null)
    {
        // validation for constraint: int
        if (!is_null($oid) && !(is_int($oid) || ctype_digit($oid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oid, true), gettype($oid)), __LINE__);
        }
        $this->oid = $oid;
        return $this;
    }
    /**
     * Get oidSerie value
     * @return int|null
     */
    public function getOidSerie()
    {
        return $this->oidSerie;
    }
    /**
     * Set oidSerie value
     * @param int $oidSerie
     * @return \StructType\WSValorSerieVO
     */
    public function setOidSerie($oidSerie = null)
    {
        // validation for constraint: int
        if (!is_null($oidSerie) && !(is_int($oidSerie) || ctype_digit($oidSerie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oidSerie, true), gettype($oidSerie)), __LINE__);
        }
        $this->oidSerie = $oidSerie;
        return $this;
    }
    /**
     * Get svalor value
     * @return string|null
     */
    public function getSvalor()
    {
        return $this->svalor;
    }
    /**
     * Set svalor value
     * @param string $svalor
     * @return \StructType\WSValorSerieVO
     */
    public function setSvalor($svalor = null)
    {
        // validation for constraint: string
        if (!is_null($svalor) && !is_string($svalor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($svalor, true), gettype($svalor)), __LINE__);
        }
        $this->svalor = $svalor;
        return $this;
    }
    /**
     * Get valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->valor;
    }
    /**
     * Set valor value
     * @param float $valor
     * @return \StructType\WSValorSerieVO
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->valor = $valor;
        return $this;
    }
}
