<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getValoresSeriesVO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param long[] $in0
     * @param string $in1
     * @param string $in2
     * @return \StructType\WSSerieVO[]|bool
     */
    public function getValoresSeriesVO(array $in0, $in1, $in2)
    {
        try {
            $this->setResult($this->getSoapClient()->getValoresSeriesVO($in0, $in1, $in2));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUltimosValoresSerieVO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $in0
     * @param string $in1
     * @return \StructType\WSSerieVO|bool
     */
    public function getUltimosValoresSerieVO($in0, $in1)
    {
        try {
            $this->setResult($this->getSoapClient()->getUltimosValoresSerieVO($in0, $in1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getValoresSeriesXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param long[] $in0
     * @param string $in1
     * @param string $in2
     * @return string|bool
     */
    public function getValoresSeriesXML(array $in0, $in1, $in2)
    {
        try {
            $this->setResult($this->getSoapClient()->getValoresSeriesXML($in0, $in1, $in2));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUltimoValorVO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $in0
     * @return \StructType\WSSerieVO|bool
     */
    public function getUltimoValorVO($in0)
    {
        try {
            $this->setResult($this->getSoapClient()->getUltimoValorVO($in0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUltimoValorXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $in0
     * @return string|bool
     */
    public function getUltimoValorXML($in0)
    {
        try {
            $this->setResult($this->getSoapClient()->getUltimoValorXML($in0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getValor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $in0
     * @param string $in1
     * @return decimal|bool
     */
    public function getValor($in0, $in1)
    {
        try {
            $this->setResult($this->getSoapClient()->getValor($in0, $in1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getValorEspecial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $in0
     * @param string $in1
     * @param string $in2
     * @return decimal|bool
     */
    public function getValorEspecial($in0, $in1, $in2)
    {
        try {
            $this->setResult($this->getSoapClient()->getValorEspecial($in0, $in1, $in2));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return decimal|string|\StructType\WSSerieVO|\StructType\WSSerieVO[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
