<?php

namespace Frontdesk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientResponseModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientResponseModel
 * @subpackage Structs
 */
class ClientResponseModel extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionType;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Amount;
    /**
     * The AmountBeforeDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AmountBeforeDiscount;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthCode;
    /**
     * The BankMID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankMID;
    /**
     * The BindCardErrDescc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BindCardErrDescc;
    /**
     * The CCName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCName;
    /**
     * The CCNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCNo;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardType;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The DCCConversionRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DCCConversionRate;
    /**
     * The DCCStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DCCStatus;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Discount;
    /**
     * The ErrDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrDesc;
    /**
     * The Lang
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lang;
    /**
     * The MerchantCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantCode;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalAmount;
    /**
     * The OriginalCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalCurrency;
    /**
     * The PaymentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentId;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentType;
    /**
     * The QRCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QRCode;
    /**
     * The QRValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QRValue;
    /**
     * The RefNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefNo;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The Requery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Requery;
    /**
     * The S_bankname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $S_bankname;
    /**
     * The S_country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $S_country;
    /**
     * The SettlementAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SettlementAmount;
    /**
     * The SettlementCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SettlementCurrency;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Signature;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Status;
    /**
     * The TokenId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TokenId;
    /**
     * The TransId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransId;
    /**
     * The Xfield1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Xfield1;
    /**
     * The Xfield2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Xfield2;
    /**
     * Constructor method for ClientResponseModel
     * @uses ClientResponseModel::setActionType()
     * @uses ClientResponseModel::setAmount()
     * @uses ClientResponseModel::setAmountBeforeDiscount()
     * @uses ClientResponseModel::setAuthCode()
     * @uses ClientResponseModel::setBankMID()
     * @uses ClientResponseModel::setBindCardErrDescc()
     * @uses ClientResponseModel::setCCName()
     * @uses ClientResponseModel::setCCNo()
     * @uses ClientResponseModel::setCardType()
     * @uses ClientResponseModel::setCurrency()
     * @uses ClientResponseModel::setDCCConversionRate()
     * @uses ClientResponseModel::setDCCStatus()
     * @uses ClientResponseModel::setDiscount()
     * @uses ClientResponseModel::setErrDesc()
     * @uses ClientResponseModel::setLang()
     * @uses ClientResponseModel::setMerchantCode()
     * @uses ClientResponseModel::setOriginalAmount()
     * @uses ClientResponseModel::setOriginalCurrency()
     * @uses ClientResponseModel::setPaymentId()
     * @uses ClientResponseModel::setPaymentType()
     * @uses ClientResponseModel::setQRCode()
     * @uses ClientResponseModel::setQRValue()
     * @uses ClientResponseModel::setRefNo()
     * @uses ClientResponseModel::setRemark()
     * @uses ClientResponseModel::setRequery()
     * @uses ClientResponseModel::setS_bankname()
     * @uses ClientResponseModel::setS_country()
     * @uses ClientResponseModel::setSettlementAmount()
     * @uses ClientResponseModel::setSettlementCurrency()
     * @uses ClientResponseModel::setSignature()
     * @uses ClientResponseModel::setStatus()
     * @uses ClientResponseModel::setTokenId()
     * @uses ClientResponseModel::setTransId()
     * @uses ClientResponseModel::setXfield1()
     * @uses ClientResponseModel::setXfield2()
     * @param string $actionType
     * @param string $amount
     * @param string $amountBeforeDiscount
     * @param string $authCode
     * @param string $bankMID
     * @param string $bindCardErrDescc
     * @param string $cCName
     * @param string $cCNo
     * @param string $cardType
     * @param string $currency
     * @param string $dCCConversionRate
     * @param int $dCCStatus
     * @param string $discount
     * @param string $errDesc
     * @param string $lang
     * @param string $merchantCode
     * @param string $originalAmount
     * @param string $originalCurrency
     * @param int $paymentId
     * @param string $paymentType
     * @param string $qRCode
     * @param string $qRValue
     * @param string $refNo
     * @param string $remark
     * @param string $requery
     * @param string $s_bankname
     * @param string $s_country
     * @param string $settlementAmount
     * @param string $settlementCurrency
     * @param string $signature
     * @param int $status
     * @param string $tokenId
     * @param string $transId
     * @param string $xfield1
     * @param string $xfield2
     */
    public function __construct($actionType = null, $amount = null, $amountBeforeDiscount = null, $authCode = null, $bankMID = null, $bindCardErrDescc = null, $cCName = null, $cCNo = null, $cardType = null, $currency = null, $dCCConversionRate = null, $dCCStatus = null, $discount = null, $errDesc = null, $lang = null, $merchantCode = null, $originalAmount = null, $originalCurrency = null, $paymentId = null, $paymentType = null, $qRCode = null, $qRValue = null, $refNo = null, $remark = null, $requery = null, $s_bankname = null, $s_country = null, $settlementAmount = null, $settlementCurrency = null, $signature = null, $status = null, $tokenId = null, $transId = null, $xfield1 = null, $xfield2 = null)
    {
        $this
            ->setActionType($actionType)
            ->setAmount($amount)
            ->setAmountBeforeDiscount($amountBeforeDiscount)
            ->setAuthCode($authCode)
            ->setBankMID($bankMID)
            ->setBindCardErrDescc($bindCardErrDescc)
            ->setCCName($cCName)
            ->setCCNo($cCNo)
            ->setCardType($cardType)
            ->setCurrency($currency)
            ->setDCCConversionRate($dCCConversionRate)
            ->setDCCStatus($dCCStatus)
            ->setDiscount($discount)
            ->setErrDesc($errDesc)
            ->setLang($lang)
            ->setMerchantCode($merchantCode)
            ->setOriginalAmount($originalAmount)
            ->setOriginalCurrency($originalCurrency)
            ->setPaymentId($paymentId)
            ->setPaymentType($paymentType)
            ->setQRCode($qRCode)
            ->setQRValue($qRValue)
            ->setRefNo($refNo)
            ->setRemark($remark)
            ->setRequery($requery)
            ->setS_bankname($s_bankname)
            ->setS_country($s_country)
            ->setSettlementAmount($settlementAmount)
            ->setSettlementCurrency($settlementCurrency)
            ->setSignature($signature)
            ->setStatus($status)
            ->setTokenId($tokenId)
            ->setTransId($transId)
            ->setXfield1($xfield1)
            ->setXfield2($xfield2);
    }
    /**
     * Get ActionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionType()
    {
        return isset($this->ActionType) ? $this->ActionType : null;
    }
    /**
     * Set ActionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionType
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: string
        if (!is_null($actionType) && !is_string($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionType, true), gettype($actionType)), __LINE__);
        }
        if (is_null($actionType) || (is_array($actionType) && empty($actionType))) {
            unset($this->ActionType);
        } else {
            $this->ActionType = $actionType;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amount
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get AmountBeforeDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountBeforeDiscount()
    {
        return isset($this->AmountBeforeDiscount) ? $this->AmountBeforeDiscount : null;
    }
    /**
     * Set AmountBeforeDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amountBeforeDiscount
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setAmountBeforeDiscount($amountBeforeDiscount = null)
    {
        // validation for constraint: string
        if (!is_null($amountBeforeDiscount) && !is_string($amountBeforeDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountBeforeDiscount, true), gettype($amountBeforeDiscount)), __LINE__);
        }
        if (is_null($amountBeforeDiscount) || (is_array($amountBeforeDiscount) && empty($amountBeforeDiscount))) {
            unset($this->AmountBeforeDiscount);
        } else {
            $this->AmountBeforeDiscount = $amountBeforeDiscount;
        }
        return $this;
    }
    /**
     * Get AuthCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthCode()
    {
        return isset($this->AuthCode) ? $this->AuthCode : null;
    }
    /**
     * Set AuthCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authCode
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        if (is_null($authCode) || (is_array($authCode) && empty($authCode))) {
            unset($this->AuthCode);
        } else {
            $this->AuthCode = $authCode;
        }
        return $this;
    }
    /**
     * Get BankMID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankMID()
    {
        return isset($this->BankMID) ? $this->BankMID : null;
    }
    /**
     * Set BankMID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankMID
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setBankMID($bankMID = null)
    {
        // validation for constraint: string
        if (!is_null($bankMID) && !is_string($bankMID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankMID, true), gettype($bankMID)), __LINE__);
        }
        if (is_null($bankMID) || (is_array($bankMID) && empty($bankMID))) {
            unset($this->BankMID);
        } else {
            $this->BankMID = $bankMID;
        }
        return $this;
    }
    /**
     * Get BindCardErrDescc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBindCardErrDescc()
    {
        return isset($this->BindCardErrDescc) ? $this->BindCardErrDescc : null;
    }
    /**
     * Set BindCardErrDescc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bindCardErrDescc
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setBindCardErrDescc($bindCardErrDescc = null)
    {
        // validation for constraint: string
        if (!is_null($bindCardErrDescc) && !is_string($bindCardErrDescc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bindCardErrDescc, true), gettype($bindCardErrDescc)), __LINE__);
        }
        if (is_null($bindCardErrDescc) || (is_array($bindCardErrDescc) && empty($bindCardErrDescc))) {
            unset($this->BindCardErrDescc);
        } else {
            $this->BindCardErrDescc = $bindCardErrDescc;
        }
        return $this;
    }
    /**
     * Get CCName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCName()
    {
        return isset($this->CCName) ? $this->CCName : null;
    }
    /**
     * Set CCName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCName
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setCCName($cCName = null)
    {
        // validation for constraint: string
        if (!is_null($cCName) && !is_string($cCName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCName, true), gettype($cCName)), __LINE__);
        }
        if (is_null($cCName) || (is_array($cCName) && empty($cCName))) {
            unset($this->CCName);
        } else {
            $this->CCName = $cCName;
        }
        return $this;
    }
    /**
     * Get CCNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCNo()
    {
        return isset($this->CCNo) ? $this->CCNo : null;
    }
    /**
     * Set CCNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCNo
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setCCNo($cCNo = null)
    {
        // validation for constraint: string
        if (!is_null($cCNo) && !is_string($cCNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCNo, true), gettype($cCNo)), __LINE__);
        }
        if (is_null($cCNo) || (is_array($cCNo) && empty($cCNo))) {
            unset($this->CCNo);
        } else {
            $this->CCNo = $cCNo;
        }
        return $this;
    }
    /**
     * Get CardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardType()
    {
        return isset($this->CardType) ? $this->CardType : null;
    }
    /**
     * Set CardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardType
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        if (is_null($cardType) || (is_array($cardType) && empty($cardType))) {
            unset($this->CardType);
        } else {
            $this->CardType = $cardType;
        }
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get DCCConversionRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDCCConversionRate()
    {
        return isset($this->DCCConversionRate) ? $this->DCCConversionRate : null;
    }
    /**
     * Set DCCConversionRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dCCConversionRate
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setDCCConversionRate($dCCConversionRate = null)
    {
        // validation for constraint: string
        if (!is_null($dCCConversionRate) && !is_string($dCCConversionRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dCCConversionRate, true), gettype($dCCConversionRate)), __LINE__);
        }
        if (is_null($dCCConversionRate) || (is_array($dCCConversionRate) && empty($dCCConversionRate))) {
            unset($this->DCCConversionRate);
        } else {
            $this->DCCConversionRate = $dCCConversionRate;
        }
        return $this;
    }
    /**
     * Get DCCStatus value
     * @return int|null
     */
    public function getDCCStatus()
    {
        return $this->DCCStatus;
    }
    /**
     * Set DCCStatus value
     * @param int $dCCStatus
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setDCCStatus($dCCStatus = null)
    {
        // validation for constraint: int
        if (!is_null($dCCStatus) && !(is_int($dCCStatus) || ctype_digit($dCCStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dCCStatus, true), gettype($dCCStatus)), __LINE__);
        }
        $this->DCCStatus = $dCCStatus;
        return $this;
    }
    /**
     * Get Discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscount()
    {
        return isset($this->Discount) ? $this->Discount : null;
    }
    /**
     * Set Discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $discount
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        if (is_null($discount) || (is_array($discount) && empty($discount))) {
            unset($this->Discount);
        } else {
            $this->Discount = $discount;
        }
        return $this;
    }
    /**
     * Get ErrDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrDesc()
    {
        return isset($this->ErrDesc) ? $this->ErrDesc : null;
    }
    /**
     * Set ErrDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errDesc
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setErrDesc($errDesc = null)
    {
        // validation for constraint: string
        if (!is_null($errDesc) && !is_string($errDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errDesc, true), gettype($errDesc)), __LINE__);
        }
        if (is_null($errDesc) || (is_array($errDesc) && empty($errDesc))) {
            unset($this->ErrDesc);
        } else {
            $this->ErrDesc = $errDesc;
        }
        return $this;
    }
    /**
     * Get Lang value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLang()
    {
        return isset($this->Lang) ? $this->Lang : null;
    }
    /**
     * Set Lang value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lang
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        if (is_null($lang) || (is_array($lang) && empty($lang))) {
            unset($this->Lang);
        } else {
            $this->Lang = $lang;
        }
        return $this;
    }
    /**
     * Get MerchantCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantCode()
    {
        return isset($this->MerchantCode) ? $this->MerchantCode : null;
    }
    /**
     * Set MerchantCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantCode
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setMerchantCode($merchantCode = null)
    {
        // validation for constraint: string
        if (!is_null($merchantCode) && !is_string($merchantCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantCode, true), gettype($merchantCode)), __LINE__);
        }
        if (is_null($merchantCode) || (is_array($merchantCode) && empty($merchantCode))) {
            unset($this->MerchantCode);
        } else {
            $this->MerchantCode = $merchantCode;
        }
        return $this;
    }
    /**
     * Get OriginalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalAmount()
    {
        return isset($this->OriginalAmount) ? $this->OriginalAmount : null;
    }
    /**
     * Set OriginalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalAmount
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: string
        if (!is_null($originalAmount) && !is_string($originalAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        if (is_null($originalAmount) || (is_array($originalAmount) && empty($originalAmount))) {
            unset($this->OriginalAmount);
        } else {
            $this->OriginalAmount = $originalAmount;
        }
        return $this;
    }
    /**
     * Get OriginalCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalCurrency()
    {
        return isset($this->OriginalCurrency) ? $this->OriginalCurrency : null;
    }
    /**
     * Set OriginalCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalCurrency
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setOriginalCurrency($originalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originalCurrency) && !is_string($originalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalCurrency, true), gettype($originalCurrency)), __LINE__);
        }
        if (is_null($originalCurrency) || (is_array($originalCurrency) && empty($originalCurrency))) {
            unset($this->OriginalCurrency);
        } else {
            $this->OriginalCurrency = $originalCurrency;
        }
        return $this;
    }
    /**
     * Get PaymentId value
     * @return int|null
     */
    public function getPaymentId()
    {
        return $this->PaymentId;
    }
    /**
     * Set PaymentId value
     * @param int $paymentId
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentId) && !(is_int($paymentId) || ctype_digit($paymentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentId, true), gettype($paymentId)), __LINE__);
        }
        $this->PaymentId = $paymentId;
        return $this;
    }
    /**
     * Get PaymentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentType()
    {
        return isset($this->PaymentType) ? $this->PaymentType : null;
    }
    /**
     * Set PaymentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentType
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        if (is_null($paymentType) || (is_array($paymentType) && empty($paymentType))) {
            unset($this->PaymentType);
        } else {
            $this->PaymentType = $paymentType;
        }
        return $this;
    }
    /**
     * Get QRCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQRCode()
    {
        return isset($this->QRCode) ? $this->QRCode : null;
    }
    /**
     * Set QRCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $qRCode
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setQRCode($qRCode = null)
    {
        // validation for constraint: string
        if (!is_null($qRCode) && !is_string($qRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qRCode, true), gettype($qRCode)), __LINE__);
        }
        if (is_null($qRCode) || (is_array($qRCode) && empty($qRCode))) {
            unset($this->QRCode);
        } else {
            $this->QRCode = $qRCode;
        }
        return $this;
    }
    /**
     * Get QRValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQRValue()
    {
        return isset($this->QRValue) ? $this->QRValue : null;
    }
    /**
     * Set QRValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $qRValue
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setQRValue($qRValue = null)
    {
        // validation for constraint: string
        if (!is_null($qRValue) && !is_string($qRValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qRValue, true), gettype($qRValue)), __LINE__);
        }
        if (is_null($qRValue) || (is_array($qRValue) && empty($qRValue))) {
            unset($this->QRValue);
        } else {
            $this->QRValue = $qRValue;
        }
        return $this;
    }
    /**
     * Get RefNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefNo()
    {
        return isset($this->RefNo) ? $this->RefNo : null;
    }
    /**
     * Set RefNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refNo
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setRefNo($refNo = null)
    {
        // validation for constraint: string
        if (!is_null($refNo) && !is_string($refNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNo, true), gettype($refNo)), __LINE__);
        }
        if (is_null($refNo) || (is_array($refNo) && empty($refNo))) {
            unset($this->RefNo);
        } else {
            $this->RefNo = $refNo;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get Requery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequery()
    {
        return isset($this->Requery) ? $this->Requery : null;
    }
    /**
     * Set Requery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requery
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setRequery($requery = null)
    {
        // validation for constraint: string
        if (!is_null($requery) && !is_string($requery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requery, true), gettype($requery)), __LINE__);
        }
        if (is_null($requery) || (is_array($requery) && empty($requery))) {
            unset($this->Requery);
        } else {
            $this->Requery = $requery;
        }
        return $this;
    }
    /**
     * Get S_bankname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getS_bankname()
    {
        return isset($this->S_bankname) ? $this->S_bankname : null;
    }
    /**
     * Set S_bankname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $s_bankname
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setS_bankname($s_bankname = null)
    {
        // validation for constraint: string
        if (!is_null($s_bankname) && !is_string($s_bankname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($s_bankname, true), gettype($s_bankname)), __LINE__);
        }
        if (is_null($s_bankname) || (is_array($s_bankname) && empty($s_bankname))) {
            unset($this->S_bankname);
        } else {
            $this->S_bankname = $s_bankname;
        }
        return $this;
    }
    /**
     * Get S_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getS_country()
    {
        return isset($this->S_country) ? $this->S_country : null;
    }
    /**
     * Set S_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $s_country
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setS_country($s_country = null)
    {
        // validation for constraint: string
        if (!is_null($s_country) && !is_string($s_country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($s_country, true), gettype($s_country)), __LINE__);
        }
        if (is_null($s_country) || (is_array($s_country) && empty($s_country))) {
            unset($this->S_country);
        } else {
            $this->S_country = $s_country;
        }
        return $this;
    }
    /**
     * Get SettlementAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSettlementAmount()
    {
        return isset($this->SettlementAmount) ? $this->SettlementAmount : null;
    }
    /**
     * Set SettlementAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $settlementAmount
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setSettlementAmount($settlementAmount = null)
    {
        // validation for constraint: string
        if (!is_null($settlementAmount) && !is_string($settlementAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementAmount, true), gettype($settlementAmount)), __LINE__);
        }
        if (is_null($settlementAmount) || (is_array($settlementAmount) && empty($settlementAmount))) {
            unset($this->SettlementAmount);
        } else {
            $this->SettlementAmount = $settlementAmount;
        }
        return $this;
    }
    /**
     * Get SettlementCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSettlementCurrency()
    {
        return isset($this->SettlementCurrency) ? $this->SettlementCurrency : null;
    }
    /**
     * Set SettlementCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $settlementCurrency
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setSettlementCurrency($settlementCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($settlementCurrency) && !is_string($settlementCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementCurrency, true), gettype($settlementCurrency)), __LINE__);
        }
        if (is_null($settlementCurrency) || (is_array($settlementCurrency) && empty($settlementCurrency))) {
            unset($this->SettlementCurrency);
        } else {
            $this->SettlementCurrency = $settlementCurrency;
        }
        return $this;
    }
    /**
     * Get Signature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignature()
    {
        return isset($this->Signature) ? $this->Signature : null;
    }
    /**
     * Set Signature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signature
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signature, true), gettype($signature)), __LINE__);
        }
        if (is_null($signature) || (is_array($signature) && empty($signature))) {
            unset($this->Signature);
        } else {
            $this->Signature = $signature;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokenId()
    {
        return isset($this->TokenId) ? $this->TokenId : null;
    }
    /**
     * Set TokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokenId
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        if (is_null($tokenId) || (is_array($tokenId) && empty($tokenId))) {
            unset($this->TokenId);
        } else {
            $this->TokenId = $tokenId;
        }
        return $this;
    }
    /**
     * Get TransId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransId()
    {
        return isset($this->TransId) ? $this->TransId : null;
    }
    /**
     * Set TransId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transId
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setTransId($transId = null)
    {
        // validation for constraint: string
        if (!is_null($transId) && !is_string($transId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transId, true), gettype($transId)), __LINE__);
        }
        if (is_null($transId) || (is_array($transId) && empty($transId))) {
            unset($this->TransId);
        } else {
            $this->TransId = $transId;
        }
        return $this;
    }
    /**
     * Get Xfield1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXfield1()
    {
        return isset($this->Xfield1) ? $this->Xfield1 : null;
    }
    /**
     * Set Xfield1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xfield1
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setXfield1($xfield1 = null)
    {
        // validation for constraint: string
        if (!is_null($xfield1) && !is_string($xfield1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xfield1, true), gettype($xfield1)), __LINE__);
        }
        if (is_null($xfield1) || (is_array($xfield1) && empty($xfield1))) {
            unset($this->Xfield1);
        } else {
            $this->Xfield1 = $xfield1;
        }
        return $this;
    }
    /**
     * Get Xfield2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXfield2()
    {
        return isset($this->Xfield2) ? $this->Xfield2 : null;
    }
    /**
     * Set Xfield2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xfield2
     * @return \Frontdesk\StructType\ClientResponseModel
     */
    public function setXfield2($xfield2 = null)
    {
        // validation for constraint: string
        if (!is_null($xfield2) && !is_string($xfield2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xfield2, true), gettype($xfield2)), __LINE__);
        }
        if (is_null($xfield2) || (is_array($xfield2) && empty($xfield2))) {
            unset($this->Xfield2);
        } else {
            $this->Xfield2 = $xfield2;
        }
        return $this;
    }
}
